/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.Platform;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import sybase.isql.ErrorMessages;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLEngine;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLResultSet;
import sybase.isql.Preferences;
import sybase.isql.ResultsProcessor;
import sybase.isql.UnbufferedISQLResultSet;
import sybase.isql.isql;

class TextResultsPanel
extends JPanel
implements ResultsProcessor,
Runnable {
    private JTextArea _textArea = null;
    private StringBuffer _buffer = null;
    private boolean _append = false;
    private boolean _interrupt = false;
    private boolean _printBlankLines = false;
    private ISQLConnectionImpl _connection = null;

    TextResultsPanel(ISQLConnectionImpl iSQLConnectionImpl) {
        super(new GridLayout(0, 1));
        this._connection = iSQLConnectionImpl;
        this._textArea = new JTextArea();
        this._textArea.setFont(new Font("Monospaced", 0, 12));
        this._textArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this._textArea);
        this.add(jScrollPane);
        this.setOpaque(true);
        this.setBackground(SystemColor.window);
        this.setAlignmentX(0.0f);
        this._buffer = new StringBuffer();
    }

    void reset() {
        this._textArea.setText("");
        this._append = false;
        this._interrupt = false;
        this._printBlankLines = false;
    }

    void interrupt() {
        this._interrupt = true;
    }

    @Override
    public synchronized void startProcessingResults(ISQLConnection iSQLConnection) {
    }

    @Override
    public void endProcessingResults(ISQLConnection iSQLConnection) {
        SwingUtilities.invokeLater(this);
    }

    @Override
    public synchronized void run() {
        try {
            if (this._append) {
                this._textArea.append(this._buffer.toString());
            } else {
                this._textArea.setText(this._buffer.toString());
                this._append = true;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            isql.getIO(this._connection).writeln(ISQLResource.getFormattedString(ErrorMessages.getName(), "NOT_ENOUGH_MEMORY_TO_DISPLAY_RESULTSET", Platform.isMacOS() ? ISQLResource.getISQLString(GeneralResources.getName(), "Preferences") : ISQLResource.getISQLString(GeneralResources.getName(), "Options")) + "\n", 2);
        }
        this._buffer.setLength(0);
        this._textArea.setCaretPosition(0);
        try {
            Rectangle rectangle = this._textArea.modelToView(0);
            if (rectangle != null) {
                this._textArea.scrollRectToVisible(rectangle);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void printBlankLines() {
        if (this._printBlankLines) {
            this._buffer.append("\n\n");
            this._printBlankLines = false;
        }
    }

    @Override
    public synchronized boolean processResultSet(ISQLConnection iSQLConnection, String string, ISQLResultSet iSQLResultSet, boolean bl) throws ResultsProcessor.ResultsProcessorException {
        int n = Preferences.getPluginIntPreference((ISQLConnectionImpl)iSQLConnection, "truncationLength", "256");
        int n2 = this._buffer.length();
        try {
            this.printBlankLines();
            this.printResultSet(this._buffer, iSQLConnection, string, iSQLResultSet, n);
            this._printBlankLines = true;
        }
        catch (InterruptedException interruptedException) {
            String string2 = ISQLResource.getISQLString(GeneralResources.getName(), "Interrupted by user");
            this._buffer.setLength(n2);
            this._buffer.append(string2);
            throw new ResultsProcessor.ResultsProcessorException(string2, interruptedException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            String string3 = ISQLResource.getFormattedString(ErrorMessages.getName(), "NOT_ENOUGH_MEMORY_TO_DISPLAY_RESULTSET", Platform.isMacOS() ? ISQLResource.getISQLString(GeneralResources.getName(), "Preferences") : ISQLResource.getISQLString(GeneralResources.getName(), "Options"));
            this._buffer.setLength(n2);
            this._buffer.append(string3);
            throw new ResultsProcessor.ResultsProcessorException(string3, outOfMemoryError);
        }
        return false;
    }

    public synchronized boolean processAsyncMessages(ISQLConnection iSQLConnection, Vector vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = vector.elementAt(i).toString();
            this._buffer.append(string);
            this._buffer.append('\n');
        }
        this._printBlankLines = true;
        return true;
    }

    @Override
    public synchronized boolean processUpdateCount(ISQLConnection iSQLConnection, String string, int n) {
        if (iSQLConnection.getDatabaseType() != 1 || ISQLConnectionImpl.statementReturnsUpdateCount(string)) {
            this.printBlankLines();
            this.printUpdateCount(this._buffer, string, n);
        }
        return true;
    }

    void addLines(Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i).toString();
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        if (this._append) {
            this._textArea.append(stringBuffer.toString());
        } else {
            this._textArea.setText(stringBuffer.toString());
            this._append = true;
        }
    }

    void destroy() {
        this._connection = null;
        this._textArea = null;
    }

    void selectAll() {
        if (this._textArea != null) {
            this._textArea.requestFocusInWindow();
            this._textArea.selectAll();
        }
    }

    boolean hasSelectedText() {
        int n;
        int n2;
        boolean bl = false;
        if (this._textArea != null && (n2 = this._textArea.getSelectionStart()) != (n = this._textArea.getSelectionEnd())) {
            bl = true;
        }
        return bl;
    }

    private void printUpdateCount(StringBuffer stringBuffer, String string, int n) {
        if (n > 0) {
            String string2;
            int n2 = ISQLEngine.guessUpdateType(string);
            switch (n2) {
                case 1: {
                    string2 = "{0} record(s) inserted";
                    break;
                }
                case 2: {
                    string2 = "{0} record(s) updated";
                    break;
                }
                case 3: {
                    string2 = "{0} record(s) deleted";
                    break;
                }
                default: {
                    string2 = "{0} record(s) affected";
                }
            }
            stringBuffer.append(ISQLResource.getFormattedString(GeneralResources.getName(), string2, Integer.toString(n)));
            stringBuffer.append("\n");
        }
    }

    private void printResultSet(StringBuffer stringBuffer, ISQLConnection iSQLConnection, String string, ISQLResultSet iSQLResultSet, int n) throws InterruptedException {
        int n2;
        boolean bl = ISQLConnectionImpl.statementIsProcedureCall(string) ? false : ISQLConnectionImpl.statementReturnsResultSet(string);
        int n3 = Preferences.getPluginIntPreference((ISQLConnectionImpl)iSQLConnection, "maximumDisplayedRows", "500");
        UnbufferedISQLResultSet unbufferedISQLResultSet = new UnbufferedISQLResultSet(iSQLResultSet.getScrollableResultSet().getJDBCResultSet(), iSQLConnection, string);
        int n4 = unbufferedISQLResultSet.getColumnCount();
        int n5 = n;
        if (n5 == 0) {
            n5 = Integer.MAX_VALUE;
        }
        int[] nArray = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            nArray[n2] = TextResultsPanel.estimateColumnWidth(unbufferedISQLResultSet, n2);
            String string2 = unbufferedISQLResultSet.getColumnLabel(n2).trim();
            nArray[n2] = Math.max(string2.length(), nArray[n2]);
            nArray[n2] = Math.min(n5, nArray[n2]);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuffer.append(TextResultsPanel.padString(unbufferedISQLResultSet.getColumnLabel(n2), nArray[n2]));
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n");
        for (n2 = 0; n2 < n4; ++n2) {
            int n6 = nArray[n2];
            for (int i = 0; i < n6; ++i) {
                stringBuffer.append("-");
            }
            stringBuffer.append(" ");
        }
        stringBuffer.append("\n");
        int n7 = 0;
        while (true) {
            block17: {
                if (this._interrupt) {
                    stringBuffer.setLength(0);
                    stringBuffer.trimToSize();
                    throw new InterruptedException();
                }
                try {
                    if (!unbufferedISQLResultSet.rowExists(n7)) {
                    }
                    break block17;
                }
                catch (SQLException sQLException) {
                    String string3;
                    String string4 = sQLException.getSQLState();
                    int n8 = sQLException.getErrorCode();
                    if (string4 != null && string4.equals("HY001") && n8 == -299) {
                        stringBuffer.setLength(0);
                        stringBuffer.trimToSize();
                        break;
                    }
                    if (string4 != null && string4.equals("JZ006") && (string3 = sQLException.getMessage()) != null && string3.indexOf("JZ0PA") != -1) {
                        stringBuffer.setLength(0);
                        stringBuffer.trimToSize();
                        break;
                    }
                    isql.getIO(iSQLResultSet.getConnection()).writeln(sQLException, ISQLResource.getISQLString(ErrorMessages.getName(), "ErrorReadingResultSet"), 2);
                }
                break;
            }
            if (n3 != -1 && n7 == n3) {
                stringBuffer.append(ISQLResource.getFormattedString(GeneralResources.getName(), "(First {0} rows)", Integer.toString(n7)));
                break;
            }
            try {
                for (n2 = 0; n2 < n4; ++n2) {
                    stringBuffer.append(TextResultsPanel.padString(unbufferedISQLResultSet.getStringValueAt(n7, n2), nArray[n2]));
                    stringBuffer.append(" ");
                }
                stringBuffer.append("\n");
            }
            catch (SQLException sQLException) {
                break;
            }
            ++n7;
        }
        if (bl && (n3 == -1 || n7 != n3)) {
            stringBuffer.append(ISQLResource.getFormattedString(GeneralResources.getName(), "({0} rows)", Integer.toString(n7)));
        }
    }

    private static int estimateColumnWidth(UnbufferedISQLResultSet unbufferedISQLResultSet, int n) {
        int n2 = unbufferedISQLResultSet.getColumnWidth(n);
        if (unbufferedISQLResultSet.isColumnBinary(n)) {
            n2 += 2;
        }
        return n2;
    }

    private static String padString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = n - string.length();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append(" ");
            }
        } else if (n2 < 0) {
            stringBuffer.setLength(n);
        }
        return stringBuffer.toString();
    }
}

