/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.customization.CustomizeDialog;
import com.sybase.util.SybLabel;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.SybRadioButton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import sybase.isql.BasePage;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLHelpManager;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLResource;
import sybase.isql.ParentFrame;
import sybase.isql.Preferences;
import sybase.isql.WindowManager;

class ToolbarPage
extends BasePage {
    private String _opt_executeToolbarButtonSemantics = Preferences.getExecuteToolbarButtonSemantics();
    private SybRadioButton _executeAll = null;
    private SybRadioButton _executeSelection = null;

    ToolbarPage(CustomizeDialog customizeDialog, ISQLConnection iSQLConnection) {
        super(customizeDialog, iSQLConnection);
        this.createUI();
    }

    private void createUI() {
        ISQLResource iSQLResource = ISQLResource.getISQLResource(GeneralResources.getName());
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        SybLabel sybLabel = new SybLabel(iSQLResource.getString("EXECUTE_TOOLBAR_BUTTON_BEHAVIOR"));
        this.add((Component)sybLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._executeAll = new SybRadioButton(iSQLResource.getString("EXECUTE_ALL_STATEMENTS"));
        this.add((Component)this._executeAll, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this._executeSelection = new SybRadioButton(iSQLResource.getString("EXECUTE_SELECTED_STATEMENTS"));
        this.add((Component)this._executeSelection, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        SybMultiLineLabel sybMultiLineLabel = new SybMultiLineLabel(iSQLResource.getString("EXECUTE_SELECTED_STATEMENTS_DESC"));
        this.add((Component)sybMultiLineLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 0, 0), 0, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this._executeAll);
        buttonGroup.add((AbstractButton)this._executeSelection);
        if (Preferences.isPreferenceLocked("executeToolbarButtonSemantics")) {
            this._executeAll.setEnabled(false);
            this._executeSelection.setEnabled(false);
        }
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 4, 1, 1, 0.0, 1.0, 21, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void initialize() {
        if (this._opt_executeToolbarButtonSemantics.equalsIgnoreCase("selection")) {
            this._executeSelection.setSelected(true);
        } else {
            this._executeAll.setSelected(true);
        }
    }

    public String getTitle() {
        return ISQLResource.getISQLString(GeneralResources.getName(), "TOOLBAR_PAGE_TITLE");
    }

    public void showHelp() {
        ISQLHelpManager.showHelp((ISQLConnectionImpl)this._connection, (Window)this._parent, "HELP_ISQL_OPTIONS_TOOLBAR");
    }

    public Component getComponent() {
        return this;
    }

    @Override
    public void acceptChanges() {
        String string = this._executeAll.isSelected() ? "all" : "selection";
        if (!string.equalsIgnoreCase(this._opt_executeToolbarButtonSemantics)) {
            this._opt_executeToolbarButtonSemantics = string;
            Preferences.setExecuteToolbarButtonSemantics(this._opt_executeToolbarButtonSemantics);
            Object[] objectArray = WindowManager.getParentFrames();
            for (int i = 0; i < objectArray.length; ++i) {
                ParentFrame parentFrame = (ParentFrame)objectArray[i];
                parentFrame.recreateToolBar();
            }
        }
    }

    @Override
    public void destroy() {
        this._executeAll = null;
        this._executeSelection = null;
        super.destroy();
    }

    @Override
    public Icon getCustomizationGroupIcon() {
        return ISQLImages.getImageIcon("toolbar16");
    }
}

