/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.resultSetTable.ScrollableResultSet;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLResultSet;
import sybase.isql.ISQLResultSetImpl;
import sybase.isql.Preferences;

class UnbufferedISQLResultSet
implements ISQLResultSet {
    private ISQLResultSet _rs;
    private ResultSet _resultSet;
    private Statement _statement;
    private int _row;
    private String _nullDisplayString;
    private boolean _moreDataExists;
    private Object[] _rowData;
    private int _columnCount;
    private ISQLConnection _connection;
    private ResultSetMetaData _metaData;
    private String _sql;
    private NumberFormat _numberFormatter;

    UnbufferedISQLResultSet(ResultSet resultSet, ISQLConnection iSQLConnection, String string) {
        this._rs = null;
        this._resultSet = null;
        this._statement = null;
        this._row = -1;
        this._rowData = null;
        this._columnCount = -1;
        this._connection = null;
        this._metaData = null;
        this._sql = null;
        this._numberFormatter = null;
        this._resultSet = resultSet;
        this._connection = iSQLConnection;
        this._sql = string;
        try {
            this._metaData = resultSet.getMetaData();
            this._columnCount = this._metaData.getColumnCount();
        }
        catch (SQLException sQLException) {
            this._metaData = null;
            this._columnCount = 0;
        }
        this._nullDisplayString = Preferences.getPluginStringPreference((ISQLConnectionImpl)iSQLConnection, "nulls", "(NULL)");
        this._moreDataExists = true;
    }

    UnbufferedISQLResultSet(ISQLResultSet iSQLResultSet, ISQLConnection iSQLConnection) throws SQLException {
        block6: {
            ISQLResultSetImpl iSQLResultSetImpl;
            this._rs = null;
            this._resultSet = null;
            this._statement = null;
            this._row = -1;
            this._rowData = null;
            this._columnCount = -1;
            this._connection = null;
            this._metaData = null;
            this._sql = null;
            this._numberFormatter = null;
            this._rs = iSQLResultSet;
            this._connection = iSQLConnection;
            this._columnCount = iSQLResultSet.getColumnCount();
            if (!(iSQLResultSet instanceof ISQLResultSetImpl) || !((iSQLConnection = (iSQLResultSetImpl = (ISQLResultSetImpl)iSQLResultSet).getConnection()) instanceof ISQLConnectionImpl)) break block6;
            ISQLConnectionImpl iSQLConnectionImpl = (ISQLConnectionImpl)iSQLConnection;
            String string = iSQLResultSetImpl.getSQLStatement();
            try {
                this._statement = iSQLConnectionImpl.getJDBCConnection().createStatement(1003, 1007);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this._statement = iSQLConnectionImpl.getJDBCConnection().createStatement();
            }
            this._statement.setFetchSize(1);
            if (ISQLConnectionImpl.statementReturnsResultSet(string)) {
                this._resultSet = this._statement.executeQuery(string);
            } else {
                boolean bl = this._statement.execute(string);
                this._resultSet = ISQLConnectionImpl.getFirstResultSet(this._statement, bl);
            }
            this._metaData = this._resultSet.getMetaData();
            this._nullDisplayString = Preferences.getPluginStringPreference((ISQLConnectionImpl)iSQLConnection, "nulls", "(NULL)");
            this._row = -1;
            this._moreDataExists = true;
        }
    }

    @Override
    public void close() {
        this._connection = null;
        this._rs = null;
        this._rowData = null;
        this._metaData = null;
        if (this._resultSet != null) {
            try {
                this._resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this._resultSet = null;
        }
        if (this._statement != null) {
            try {
                this._statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public ScrollableResultSet getScrollableResultSet() {
        if (this._rs != null) {
            return this._rs.getScrollableResultSet();
        }
        return null;
    }

    @Override
    public ISQLConnection getConnection() {
        return this._connection;
    }

    @Override
    public String getSQLStatement() {
        String string = this._sql != null ? this._sql : this._rs.getSQLStatement();
        return string;
    }

    @Override
    public int getColumnCount() {
        int n = 0;
        if (this._metaData != null) {
            try {
                n = this._metaData.getColumnCount();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return n;
    }

    @Override
    public int getColumnSQLType(int n) {
        int n2 = 1;
        if (this._metaData != null) {
            try {
                n2 = this._metaData.getColumnType(n + 1);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Override
    public String getColumnTypeName(int n) {
        String string = null;
        if (this._metaData != null) {
            try {
                string = this._metaData.getColumnTypeName(n + 1);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public Class getColumnClass(int n) {
        int n2 = this.getColumnSQLType(n);
        Class clazz = ScrollableResultSet.convertSQLTypeToJavaType((int)n2);
        return clazz;
    }

    @Override
    public boolean isColumnBinary(int n) {
        boolean bl = false;
        if (this._metaData != null) {
            try {
                int n2 = this._metaData.getColumnType(n + 1);
                bl = n2 == -2 || n2 == 2004 || n2 == -4 || n2 == -3;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return bl;
    }

    @Override
    public String getColumnName(int n) {
        String string = "";
        if (this._metaData != null) {
            try {
                string = this._metaData.getColumnName(n + 1);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public String getColumnLabel(int n) {
        String string = "";
        if (this._metaData != null) {
            try {
                string = this._metaData.getColumnLabel(n + 1);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return string;
    }

    @Override
    public int getColumnAlignment(int n) {
        int n2 = 1;
        if (this._metaData != null) {
            try {
                int n3 = this._metaData.getColumnType(n + 1);
                n2 = ISQLResultSetImpl.getAlignmentForSQLType(n3);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Override
    public int getColumnWidth(int n) {
        int n2 = 0;
        if (this._metaData != null) {
            try {
                n2 = this._metaData.getColumnDisplaySize(n + 1);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Override
    public int getPrecision(int n) {
        int n2 = 0;
        if (this._metaData != null) {
            try {
                n2 = this._metaData.getPrecision(n + 1);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Override
    public int getScale(int n) {
        int n2 = 0;
        if (this._metaData != null) {
            try {
                n2 = this._metaData.getScale(n + 1);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Override
    public int getRowCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean rowExists(int n) throws SQLException {
        boolean bl = this.moveToRow(n);
        return bl;
    }

    @Override
    public Object getValueAt(int n, int n2) throws SQLException {
        Object object = null;
        if (this._resultSet != null && this.moveToRow(n)) {
            object = this._rowData[n2];
        }
        return object;
    }

    @Override
    public String getStringValueAt(int n, int n2) throws SQLException {
        String string;
        Object object = this.getValueAt(n, n2);
        if (object == null) {
            string = this._nullDisplayString;
        } else if (this.isColumnBinary(n2)) {
            string = ISQLResultSetImpl.blobToString((InputStream)object, Integer.MAX_VALUE);
        } else if (object instanceof Boolean) {
            string = ((Boolean)object).booleanValue() ? "1" : "0";
        } else {
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                int n3 = bigDecimal.precision();
                int n4 = bigDecimal.scale();
                if (this._numberFormatter == null) {
                    this._numberFormatter = NumberFormat.getInstance();
                    this._numberFormatter.setGroupingUsed(false);
                }
                this._numberFormatter.setMaximumIntegerDigits(n3);
                this._numberFormatter.setMaximumFractionDigits(n4);
                this._numberFormatter.setMinimumFractionDigits(n4);
                return this._numberFormatter.format(object);
            }
            string = object.toString();
        }
        return string;
    }

    @Override
    public boolean hasPartialData() {
        return false;
    }

    private boolean moveToRow(int n) throws SQLException {
        boolean bl = false;
        if (this._resultSet != null && this._moreDataExists) {
            try {
                if (this._row < n && this._moreDataExists) {
                    while (this._row < n && this._moreDataExists) {
                        this._moreDataExists = this._resultSet.next();
                        ++this._row;
                    }
                    if (this._moreDataExists) {
                        if (this._rowData == null) {
                            this._rowData = new Object[this._columnCount];
                        }
                        for (int i = 1; i <= this._columnCount; ++i) {
                            this._rowData[i - 1] = this.getResultSetValue(this._resultSet, i - 1, this.getColumnSQLType(i - 1));
                        }
                    }
                }
                if (this._moreDataExists && n == this._row) {
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                this._moreDataExists = false;
                throw sQLException;
            }
        }
        return bl;
    }

    private Object getResultSetValue(ResultSet resultSet, int n, int n2) throws SQLException {
        Object object;
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                object = resultSet.getString(n + 1);
                break;
            }
            case 2: 
            case 3: {
                try {
                    object = resultSet.getBigDecimal(n + 1);
                }
                catch (Exception exception) {
                    try {
                        object = resultSet.getObject(n + 1);
                    }
                    catch (Exception exception2) {
                        object = resultSet.getString(n + 1);
                    }
                }
                break;
            }
            case -7: {
                object = resultSet.getBoolean(n + 1);
                break;
            }
            case -6: {
                int n3 = resultSet.getInt(n + 1);
                if (n3 < 0) {
                    n3 += 256;
                }
                object = n3;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = resultSet.getBinaryStream(n + 1);
                break;
            }
            case 5: {
                if (this._metaData != null && this._metaData.isSigned(n + 1)) {
                    object = resultSet.getShort(n + 1);
                    break;
                }
                object = resultSet.getInt(n + 1);
                break;
            }
            case 4: {
                if (this._metaData != null && this._metaData.isSigned(n + 1)) {
                    object = resultSet.getInt(n + 1);
                    break;
                }
                object = resultSet.getLong(n + 1);
                break;
            }
            case -5: {
                if (this._metaData != null && this._metaData.isSigned(n + 1)) {
                    object = resultSet.getLong(n + 1);
                    break;
                }
                object = resultSet.getBigDecimal(n + 1);
                break;
            }
            case 6: 
            case 8: {
                object = new Double(resultSet.getDouble(n + 1));
                break;
            }
            case 7: {
                object = new Float(resultSet.getFloat(n + 1));
                break;
            }
            case 91: {
                object = resultSet.getDate(n + 1);
                break;
            }
            case 92: {
                object = resultSet.getTime(n + 1);
                break;
            }
            case 93: {
                object = resultSet.getTimestamp(n + 1);
                break;
            }
            default: {
                object = resultSet.getObject(n + 1);
            }
        }
        if (resultSet.wasNull()) {
            object = null;
        }
        return object;
    }

    ResultSetMetaData getMetaData() {
        return this._metaData;
    }
}

