/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.DialogUtils;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.SybRadioButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLResource;
import sybase.isql.WhatToPrintDialogResources;

class WhatToPrintDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private static Object _result;
    private SybRadioButton _rbSQLStatements = null;
    private SybRadioButton _rbResultSets = null;
    private SybCheckBox[] _cbResultSet = null;
    private SybButton _ok = null;
    private SybButton _cancel = null;

    static Object open(JFrame jFrame, int n, Result result) {
        WhatToPrintDialog whatToPrintDialog = new WhatToPrintDialog(jFrame, n, result);
        whatToPrintDialog.setVisible(true);
        whatToPrintDialog.destroy();
        return _result;
    }

    private WhatToPrintDialog(JFrame jFrame, int n, Result result) {
        super((Window)jFrame, Dialog.ModalityType.DOCUMENT_MODAL);
        _result = Result.NOTHING;
        this.createUI(jFrame, n, result);
    }

    private void createUI(JFrame jFrame, int n, Result result) {
        int n2 = 0;
        ISQLResource iSQLResource = ISQLResource.getISQLResource(WhatToPrintDialogResources.getName());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ButtonGroup buttonGroup = new ButtonGroup();
        SybLabel sybLabel = new SybLabel(iSQLResource.getISQLString("ABOUT"));
        ImageIcon imageIcon = ISQLImages.getImageIcon("printer32");
        SybLabel sybLabel2 = new SybLabel((Icon)imageIcon);
        jPanel.add((Component)sybLabel2, new GridBagConstraints(0, n2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
        jPanel.add((Component)sybLabel, new GridBagConstraints(1, n2++, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 10, 5, 0), 0, 0));
        int n3 = imageIcon.getIconWidth() + 10;
        this._rbSQLStatements = new SybRadioButton(iSQLResource.getISQLString("SQL_STATEMENTS"));
        buttonGroup.add((AbstractButton)this._rbSQLStatements);
        jPanel.add((Component)this._rbSQLStatements, new GridBagConstraints(0, n2++, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, n3, 0, 0), 0, 0));
        this._rbResultSets = new SybRadioButton(iSQLResource.getISQLString("RESULTS"));
        buttonGroup.add((AbstractButton)this._rbResultSets);
        if (n == 0) {
            this._rbResultSets.setEnabled(false);
        }
        jPanel.add((Component)this._rbResultSets, new GridBagConstraints(0, n2++, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, n3, 0, 0), 0, 0));
        if (n > 1) {
            this._rbSQLStatements.addItemListener((ItemListener)this);
            this._rbResultSets.addItemListener((ItemListener)this);
            this._cbResultSet = new SybCheckBox[n];
            for (int i = 0; i < n; ++i) {
                this._cbResultSet[i] = new SybCheckBox(iSQLResource.getFormattedString("RESULT_SET_N", Integer.toString(i + 1)));
                this._cbResultSet[i].setSelected(true);
                jPanel.add((Component)this._cbResultSet[i], new GridBagConstraints(0, n2++, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, n3 + 20, 0, 0), 0, 0));
            }
        }
        this._ok = new SybButton(iSQLResource.getISQLString("OK"));
        this._ok.addActionListener((ActionListener)this);
        this._cancel = new SybButton(iSQLResource.getISQLString("CANCEL"));
        this._cancel.addActionListener((ActionListener)this);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._ok, this._cancel});
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)this._ok);
        jPanel2.add(Box.createHorizontalStrut(5));
        jPanel2.add((Component)this._cancel);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, n2++, 0, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 0, 0), 0, 0));
        jPanel.add(Box.createHorizontalStrut(200), new GridBagConstraints(0, n2++, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        switch (result) {
            case SQL_STATEMENTS: {
                this._rbSQLStatements.setSelected(true);
                this._rbSQLStatements.requestFocusInWindow();
                break;
            }
            default: {
                if (n > 0) {
                    this._rbResultSets.setSelected(true);
                    this._rbResultSets.requestFocusInWindow();
                    break;
                }
                this._rbSQLStatements.setSelected(true);
                this._rbSQLStatements.requestFocusInWindow();
            }
        }
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this.getContentPane().add(jPanel);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this.setTitle(iSQLResource.getISQLString("TITLE"));
        this.pack();
        if (this._rbSQLStatements.isSelected()) {
            this._rbSQLStatements.requestFocusInWindow();
        } else {
            this._rbResultSets.requestFocusInWindow();
        }
        this.setLocationRelativeTo(jFrame);
        this.setResizable(false);
    }

    private void destroy() {
        if (this._ok != null) {
            this._ok.removeActionListener((ActionListener)this);
            this._ok = null;
        }
        if (this._cancel != null) {
            this._cancel.removeActionListener((ActionListener)this);
            this._cancel = null;
        }
        DialogUtils.removeComponents((Container)this);
    }

    private void handleOK() {
        if (this._rbSQLStatements.isSelected()) {
            _result = Result.SQL_STATEMENTS;
        } else if (this._cbResultSet == null) {
            _result = new int[]{0};
        } else {
            int n;
            int n2 = 0;
            for (n = 0; n < this._cbResultSet.length; ++n) {
                if (!this._cbResultSet[n].isSelected()) continue;
                ++n2;
            }
            int[] nArray = new int[n2];
            n2 = 0;
            for (n = 0; n < this._cbResultSet.length; ++n) {
                if (!this._cbResultSet[n].isSelected()) continue;
                nArray[n2++] = n;
            }
            _result = nArray;
        }
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel) {
            this.setVisible(false);
        } else {
            String string = actionEvent.getActionCommand();
            if (string != null && string.equals(ESCAPE_KEY_COMMAND)) {
                this.setVisible(false);
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            boolean bl = itemEvent.getItem() == this._rbResultSets;
            for (int i = 0; i < this._cbResultSet.length; ++i) {
                this._cbResultSet[i].setEnabled(bl);
            }
        }
    }

    static enum Result {
        NOTHING,
        SQL_STATEMENTS,
        RESULT_SETS;

    }
}

