/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.ianywhere.errorreporting.ExceptionHandler;
import com.sybase.asa.common.ChangePasswordDialog;
import com.sybase.asa.common.CommonResourceBundle;
import com.sybase.asa.logon.ASAConnectionInfo;
import com.sybase.asa.logon.LogonDialogClient;
import com.sybase.asa.logon.LogonDialogFactory;
import com.sybase.asa.logon.LogonSource;
import com.sybase.asa.logon.ODBCUtils;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.MacApplication;
import com.sybase.util.MacApplicationFactory;
import com.sybase.util.OEMSupport;
import com.sybase.util.Platform;
import com.sybase.util.SCC;
import com.sybase.util.SCCException;
import com.sybase.util.SCCFactory;
import com.sybase.util.SCCTextOutput;
import com.sybase.util.SplashScreen;
import com.sybase.util.SybOptionPane;
import com.sybase.util.UIUtils;
import com.sybase.util.win32.Win32Util;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import sybase.isql.CommandLineOptions;
import sybase.isql.ConnectingDialog;
import sybase.isql.ErrorMessages;
import sybase.isql.FontLoader;
import sybase.isql.FrontEnd;
import sybase.isql.GUIIO;
import sybase.isql.GeneralResources;
import sybase.isql.IO;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLHelpManager;
import sybase.isql.ISQLImages;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLResource;
import sybase.isql.ISQLUpdateService;
import sybase.isql.MenuResources;
import sybase.isql.ParentFrame;
import sybase.isql.ParserUtils;
import sybase.isql.PlanFrame;
import sybase.isql.PluginMgr;
import sybase.isql.Preferences;
import sybase.isql.SCCRunner;
import sybase.isql.isql;

class WindowManager
implements FrontEnd,
WindowListener,
SCCTextOutput {
    private static SCC _scc;
    private static ArrayList<ParentFrame> _allFrames;
    private static ISQLConnection _uiActiveConnection;
    private static ParentFrame _activeFrame;
    static WindowManager _theWindowManager;
    private static CommandLineOptions _commandLineOptions;
    private static boolean _shutdownRequested;
    private MacApplication _macApplication = null;
    private String _mruLogonSourceClassName = null;
    private static final int X_OFFSET = 30;
    private static final int Y_OFFSET = 30;

    WindowManager() {
    }

    static FrontEnd create() {
        _theWindowManager = new WindowManager();
        return _theWindowManager;
    }

    static WindowManager getWindowManager() {
        return _theWindowManager;
    }

    SCC getSCCProvider() {
        String string;
        if (_scc == null && (string = Preferences.getSourceControlSystem()) != null) {
            if (!string.equals(SCCFactory.getCustomSourceControlName()) && !string.equals(SCCFactory.getDefaultSourceControlName())) {
                SybOptionPane.showMessageDialog((Component)WindowManager.getAnyParentFrame(), (Object)GeneralResources.getFormattedString(GeneralResources.getName(), "DefaultSCCChanged", string), (String)GeneralResources.getISQLString(GeneralResources.getName(), "Interactive SQL"), (int)2);
                Preferences.setSourceControlSystem(null);
                return null;
            }
            String string2 = "DBISQL " + Integer.toString(11) + "." + Integer.toString(0) + "." + Integer.toString(1);
            try {
                _scc = SCCFactory.getSCC(null, (String)string, (String)string2);
            }
            catch (SCCException sCCException) {
                SybOptionPane.showMessageDialog((Component)_activeFrame, (Object)ErrorMessages.getFormattedString(ErrorMessages.getName(), "ERROR_CANT_GET_SCC_PROVIDER", sCCException.getLocalizedMessage()), (String)GeneralResources.getISQLString(GeneralResources.getName(), "Interactive SQL"), (int)0);
                Preferences.setSourceControlSystem(null);
            }
        }
        return _scc;
    }

    SCC getSCC() {
        if (_scc == null) {
            this.getSCCProvider();
            if (_scc != null) {
                boolean bl;
                if ((_scc.getCapabilities() & 0x200) != 0 && !(bl = this.openSCCProject(false))) {
                    return null;
                }
                this.updateSourceControlStatusPanes();
            }
        }
        return _scc;
    }

    boolean openSCCProject(boolean bl) {
        boolean bl2 = true;
        int n = 0;
        final String[] stringArray = new String[]{Preferences.getSourceControlUser()};
        final String[] stringArray2 = new String[]{Preferences.getSourceControlProject()};
        final String[] stringArray3 = new String[]{Preferences.getSourceControlProjectPath()};
        final String[] stringArray4 = new String[]{Preferences.getSourceControlAuxProjectPath()};
        ParentFrame parentFrame = WindowManager.getAnyParentFrame();
        if (bl || stringArray2[0] == null || stringArray2[0].length() == 0) {
            final boolean[] blArray = new boolean[]{false};
            final boolean[] blArray2 = new boolean[]{false};
            SCCRunner sCCRunner = new SCCRunner(parentFrame){

                @Override
                protected void doit() throws SCCException {
                    boolean bl;
                    blArray2[0] = bl = this._scc.getProjectPath(stringArray, stringArray2, stringArray3, stringArray4, true, false, blArray);
                }
            };
            if (!sCCRunner.call(_scc)) {
                SybOptionPane.showMessageDialog((Component)parentFrame, (Object)ErrorMessages.getFormattedString(ErrorMessages.getName(), "ErrorOpeningSCCProject", sCCRunner.getException().getLocalizedMessage()), (String)GeneralResources.getISQLString(GeneralResources.getName(), "Interactive SQL"), (int)0);
                bl2 = false;
            } else {
                bl2 = blArray2[0];
            }
            if (blArray[0]) {
                n = 1;
            }
        }
        if (bl2) {
            try {
                _scc.closeProject();
            }
            catch (SCCException sCCException) {
                // empty catch block
            }
            try {
                _scc.openProject(stringArray, stringArray2, stringArray3, stringArray4, null, (SCCTextOutput)this, (long)(n | 2));
                Preferences.setSourceControlUser(stringArray[0]);
                Preferences.setSourceControlProject(stringArray2[0]);
                Preferences.setSourceControlProjectPath(stringArray3[0]);
                Preferences.setSourceControlAuxProjectPath(stringArray4[0]);
            }
            catch (SCCException sCCException) {
                SybOptionPane.showMessageDialog((Component)parentFrame, (Object)ErrorMessages.getFormattedString(ErrorMessages.getName(), "ErrorOpeningSCCProject", sCCException.getLocalizedMessage()), (String)GeneralResources.getISQLString(GeneralResources.getName(), "Interactive SQL"), (int)0);
                bl2 = false;
            }
        }
        return bl2;
    }

    void discardSCC() {
        if (_scc != null) {
            _scc.destroy();
            _scc = null;
            this.updateSourceControlStatusPanes();
        }
    }

    private void updateSourceControlStatusPanes() {
        for (int i = 0; i < _allFrames.size(); ++i) {
            ParentFrame parentFrame = _allFrames.get(i);
            parentFrame.updateSourceControlIndicator();
        }
    }

    private ParentFrame createWindowForConnection(ISQLConnection iSQLConnection) {
        Rectangle rectangle = this.getInitialChildWindowLocation();
        ParentFrame parentFrame = new ParentFrame(iSQLConnection, rectangle);
        int n = Preferences.getIntOption(iSQLConnection, "windowState");
        parentFrame.setExtendedState(n &= 0xFFFFFFFE);
        parentFrame.addWindowListener(this);
        _allFrames.add(parentFrame);
        return parentFrame;
    }

    private ParentFrame createUnconnectedWindow() {
        ISQLConnectionImpl iSQLConnectionImpl = new ISQLConnectionImpl();
        ParentFrame parentFrame = this.createWindowForConnection(iSQLConnectionImpl);
        return parentFrame;
    }

    ParentFrame createWindow() {
        ParentFrame parentFrame = this.createWindow(_commandLineOptions.getPlugin(), WindowManager._commandLineOptions.connectionInfo);
        return parentFrame;
    }

    ParentFrame createWindow(ISQLPlugin iSQLPlugin, AbstractConnectionInfo abstractConnectionInfo) {
        ParentFrame parentFrame = this.createUnconnectedWindow();
        if (_commandLineOptions != null) {
            this.connectFrameUsingConnectionInfo(parentFrame, iSQLPlugin, abstractConnectionInfo);
        }
        return parentFrame;
    }

    @Override
    public void changeWindowConnection(ISQLConnection iSQLConnection, ISQLConnection iSQLConnection2) {
        ParentFrame parentFrame = WindowManager.findFrameByConnection(iSQLConnection);
        if (parentFrame != null) {
            parentFrame.setConnection(iSQLConnection2);
        }
    }

    @Override
    public IO getIO() {
        ParentFrame parentFrame = null;
        IO iO = null;
        parentFrame = _activeFrame == null && _allFrames != null && _allFrames.size() > 0 ? _allFrames.get(_allFrames.size() - 1) : _activeFrame;
        iO = parentFrame != null ? parentFrame.getIO() : isql.getDefaultIO();
        return iO;
    }

    @Override
    public void closeUIForConnection(ISQLConnection iSQLConnection) {
        DeferredWindowCloser deferredWindowCloser = new DeferredWindowCloser(iSQLConnection);
        SwingUtilities.invokeLater(deferredWindowCloser);
    }

    private void handleMacAction(String string, ActionEvent actionEvent) {
        if (_activeFrame != null) {
            _activeFrame.processMenu(string, actionEvent);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public void run(CommandLineOptions commandLineOptions) {
        String string;
        Object object;
        Object object2;
        isql.setDefaultIO(new GUIIO(null));
        _commandLineOptions = commandLineOptions;
        ExceptionHandler.install();
        if (Platform.isMacOS()) {
            try {
                this._macApplication = MacApplicationFactory.newInstance();
                object2 = MenuResources.getISQLString(MenuResources.getName(), "About");
                this._macApplication.setAboutAction((Action)new AbstractAction((String)object2){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        WindowManager.this.handleMacAction("About", actionEvent);
                    }
                });
                object2 = MenuResources.getISQLString(MenuResources.getName(), "Options...");
                this._macApplication.setPreferencesAction((Action)new AbstractAction((String)object2){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        WindowManager.this.handleMacAction("Options...", actionEvent);
                    }
                });
                object2 = MenuResources.getISQLString(MenuResources.getName(), "Exit");
                this._macApplication.setQuitAction((Action)new AbstractAction((String)object2){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        WindowManager.this.handleMacAction("Exit", actionEvent);
                    }
                });
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        ParentFrame parentFrame = this.createUnconnectedWindow();
        if (commandLineOptions.file != null) {
            parentFrame.openFile(commandLineOptions.file);
        }
        UIUtils.ensureWindowIsVisible((Window)parentFrame);
        parentFrame.setVisible(true);
        SplashScreen.close();
        _activeFrame = parentFrame;
        if (!isql.options.quiet && Platform.isWindows() && ODBCUtils.isTracingEnabled()) {
            SybOptionPane.showMessageDialog((Component)parentFrame, (Object)GeneralResources.getISQLString(GeneralResources.getName(), "WARNING_ODBC_TRACING_IS_ON"), (String)GeneralResources.getISQLString(GeneralResources.getName(), "Interactive SQL"), (int)2);
        }
        this.getSCC();
        if (commandLineOptions.connectOnStartup) {
            this.connectFrameUsingConnectionInfo(parentFrame, commandLineOptions.getPlugin(), commandLineOptions.connectionInfo);
        }
        if (System.getProperty("com.sybase.util.FastLoader", "0").equals("1")) {
            object = PlanFrame.getAllPlanFrames();
            long l = commandLineOptions.file != null && PluginMgr.getPluginForPlanFile(commandLineOptions.file.getName()) != null && ((PlanFrame[])object).length > 0 ? Win32Util.getHWND((Window)object[((PlanFrame[])object).length - 1]) : Win32Util.getHWND((Window)parentFrame);
            if (l != 0L) {
                Win32Util.setForegroundWindow((long)l, (boolean)true);
            }
        } else {
            object2 = PlanFrame.getAllPlanFrames();
            if (commandLineOptions.file != null && PluginMgr.getPluginForPlanFile(commandLineOptions.file.getName()) != null && ((PlanFrame[])object2).length > 0) {
                object2[((PlanFrame[])object2).length - 1].toFront();
            }
        }
        if (!isql.options.quiet && (string = Preferences.getStringOption(parentFrame.getConnection(), "on_error")) != null && string.equalsIgnoreCase("Exit")) {
            SybOptionPane.showMessageDialog((Component)parentFrame, (Object)GeneralResources.getISQLString(GeneralResources.getName(), "WARNING_EXIT_ON_ERROR"), (String)GeneralResources.getISQLString(GeneralResources.getName(), "Interactive SQL"), (int)2);
        }
        FontLoader.go();
        if (commandLineOptions.tail.length() != 0) {
            String string2 = isql.stripQuotes(commandLineOptions.tail.toString());
            StringBuffer stringBuffer = new StringBuffer();
            object = ParserUtils.searchForFile(string2, null);
            if (object != null) {
                stringBuffer.append("READ \"");
                stringBuffer.append(ParserUtils.escapeFileName(((File)object).toString()));
                stringBuffer.append("\";");
            } else {
                stringBuffer.append(string2);
                if (stringBuffer.charAt(stringBuffer.length() - 1) != ';') {
                    stringBuffer.append(';');
                }
            }
            parentFrame.executeSQL(stringBuffer.toString());
        }
        if (commandLineOptions.initialSQL != null) {
            parentFrame.setSQLStatement(commandLineOptions.initialSQL);
            if (commandLineOptions.executeInitialSQL) {
                parentFrame.executeSQL(commandLineOptions.initialSQL);
            }
        }
        if (OEMSupport.getOEMSupport().getCheckForUpdates()) {
            ISQLUpdateService.checkForUpdates();
        }
    }

    void connectFrameUsingConnectionInfo(ParentFrame parentFrame, ISQLPlugin iSQLPlugin, AbstractConnectionInfo abstractConnectionInfo) {
        ISQLConnection iSQLConnection = parentFrame.getConnection();
        if (iSQLPlugin != null && abstractConnectionInfo != null && abstractConnectionInfo.canAttemptConnection()) {
            ConnectingDialogClient connectingDialogClient = new ConnectingDialogClient(iSQLConnection, iSQLPlugin, abstractConnectionInfo);
            ConnectingDialog.showDialog(parentFrame, connectingDialogClient);
        }
        if (!iSQLConnection.isConnected()) {
            this.connect(iSQLConnection, iSQLPlugin, abstractConnectionInfo, FrontEnd.PromptBehavior.ALWAYS, true, null);
        }
    }

    @Override
    public void requestShutdown() {
        if (!_shutdownRequested) {
            _shutdownRequested = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (WindowManager.this.destroy()) {
                        isql.AppStopped();
                    }
                    _shutdownRequested = false;
                }
            });
        }
    }

    @Override
    public boolean isShutdownRequested() {
        return _shutdownRequested;
    }

    @Override
    public boolean destroy() {
        boolean bl = WindowManager.closeAllWindows();
        if (bl) {
            isql.uiIndependentFini();
            _activeFrame = null;
            _allFrames = new ArrayList();
            this.discardSCC();
            _uiActiveConnection = null;
            _commandLineOptions = null;
            _theWindowManager = null;
        }
        return bl;
    }

    private static boolean closeAllWindows() {
        boolean bl = true;
        if (_allFrames != null) {
            Object[] objectArray = _allFrames.toArray();
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                ParentFrame parentFrame = (ParentFrame)objectArray[i];
                if (parentFrame.isOKToClose()) {
                    int n2;
                    parentFrame.removeWindowListener(_theWindowManager);
                    parentFrame.close();
                    if (parentFrame == _activeFrame) {
                        _activeFrame = null;
                    }
                    if ((n2 = _allFrames.indexOf(parentFrame)) == -1) continue;
                    _allFrames.remove(n2);
                    continue;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public void notifyConnectionOpened(ISQLConnection iSQLConnection) {
        ParentFrame parentFrame = WindowManager.findFrameByConnection(iSQLConnection);
        if (parentFrame != null) {
            parentFrame.setWindowTitle();
        }
    }

    @Override
    public void notifyConnectionClosed(ISQLConnection iSQLConnection) {
        ParentFrame parentFrame = WindowManager.findFrameByConnection(iSQLConnection);
        if (parentFrame != null) {
            parentFrame.notifyConnectionClosed();
        }
    }

    @Override
    public void notifyDatabaseSelected(ISQLConnection iSQLConnection, String string) {
        ParentFrame parentFrame = WindowManager.findFrameByConnection(iSQLConnection);
        if (parentFrame != null) {
            parentFrame.setDBName(string);
        }
    }

    @Override
    public void notifyDatabaseListChanged(ISQLConnection iSQLConnection) {
        ParentFrame parentFrame = WindowManager.findFrameByConnection(iSQLConnection);
        if (parentFrame != null) {
            parentFrame.refreshDatabaseList(iSQLConnection);
        }
    }

    @Override
    public void notifyCurrentUserChanged(ISQLConnection iSQLConnection) {
        ParentFrame parentFrame = WindowManager.findFrameByConnection(iSQLConnection);
        if (parentFrame != null) {
            parentFrame.updateWindowTitle(null);
        }
    }

    @Override
    public ISQLConnection findConnectionByName(String string) {
        ISQLConnection iSQLConnection = null;
        int n = _allFrames.size();
        for (int i = 0; i < n; ++i) {
            ParentFrame parentFrame = _allFrames.get(i);
            iSQLConnection = parentFrame.getConnection();
            if (iSQLConnection == null) continue;
            String string2 = iSQLConnection.getName();
            if (string2 == null && string == null || string.equalsIgnoreCase(string2)) break;
            iSQLConnection = null;
        }
        return iSQLConnection;
    }

    @Override
    public ISQLConnection getUIActiveConnection() {
        return _uiActiveConnection;
    }

    @Override
    public boolean activateNamedConnection(String string) {
        int n;
        boolean bl = false;
        ParentFrame parentFrame = WindowManager.findFrameByConnectionName(string);
        if (parentFrame != null && (n = _allFrames.indexOf(parentFrame)) != -1) {
            if (parentFrame.getState() == 1) {
                parentFrame.setState(0);
            }
            UIUtils.ensureWindowIsVisible((Window)parentFrame);
            parentFrame.setVisible(true);
            bl = true;
        }
        return bl;
    }

    @Override
    public void closeAllConnections() {
        int n = _allFrames.size();
        for (int i = n - 1; i >= 0; --i) {
            ParentFrame parentFrame = _allFrames.get(i);
            parentFrame.notifyConnectionClosed();
        }
    }

    @Override
    public boolean startLogging(ISQLConnection iSQLConnection, String string) {
        boolean bl = false;
        ParentFrame parentFrame = WindowManager.findFrameByConnection(iSQLConnection);
        if (parentFrame != null) {
            bl = parentFrame.startLogging(string);
        }
        return bl;
    }

    @Override
    public void log(ISQLConnection iSQLConnection, String string) {
        ParentFrame parentFrame = WindowManager.findFrameByConnection(iSQLConnection);
        if (parentFrame != null) {
            parentFrame.log(string);
        }
    }

    @Override
    public void stopLogging(ISQLConnection iSQLConnection) {
        ParentFrame parentFrame = WindowManager.findFrameByConnection(iSQLConnection);
        if (parentFrame != null) {
            parentFrame.stopLogging();
        }
    }

    @Override
    public void enableUIForConnection(ISQLConnection iSQLConnection, boolean bl) {
        ParentFrame parentFrame = WindowManager.findFrameByConnection(iSQLConnection);
        if (parentFrame != null && parentFrame.isVisible()) {
            parentFrame.enableUI(bl);
        }
    }

    @Override
    public void clear(ISQLConnection iSQLConnection) {
        ParentFrame parentFrame = WindowManager.findFrameByConnection(iSQLConnection);
        if (parentFrame != null) {
            parentFrame.clear();
        }
    }

    @Override
    public boolean connect(ISQLConnection iSQLConnection, ISQLPlugin iSQLPlugin, AbstractConnectionInfo abstractConnectionInfo, FrontEnd.PromptBehavior promptBehavior, boolean bl, Vector<String> vector) {
        ParentFrame parentFrame;
        boolean bl2;
        block16: {
            bl2 = false;
            parentFrame = WindowManager.findFrameByConnection(iSQLConnection);
            if (parentFrame == null) {
                throw new IllegalArgumentException("ISQLConnection does not have a corresponding ParentFrame");
            }
            if (promptBehavior != FrontEnd.PromptBehavior.ALWAYS && abstractConnectionInfo != null && iSQLPlugin != null) {
                ((ISQLConnectionImpl)iSQLConnection).setConnectionInfo(iSQLPlugin, abstractConnectionInfo);
                if (abstractConnectionInfo.canAttemptConnection()) {
                    try {
                        Connection connection = iSQLConnection.getJDBCConnection();
                        iSQLConnection.connect(null);
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                        bl2 = true;
                    }
                    catch (SQLException sQLException) {
                        if (!bl) {
                            SybOptionPane.showMessageDialog((Component)parentFrame, (Object)(ErrorMessages.getISQLString(ErrorMessages.getName(), "Could not connect to the database.") + "\n" + sQLException.getLocalizedMessage()), (String)GeneralResources.getISQLString(GeneralResources.getName(), "Interactive SQL"), (int)0);
                        }
                    }
                    catch (Exception exception) {
                        if (!(exception instanceof RuntimeException)) break block16;
                        throw (RuntimeException)exception;
                    }
                }
            }
        }
        if (!bl2 && promptBehavior != FrontEnd.PromptBehavior.NEVER) {
            LogonSource logonSource;
            ISQLPlugin[] iSQLPluginArray = PluginMgr.getPluginList();
            LogonSource[] logonSourceArray = new LogonSource[iSQLPluginArray.length];
            int n = -1;
            for (int i = 0; i < iSQLPluginArray.length; ++i) {
                logonSourceArray[i] = iSQLPluginArray[i].getLogonSource();
                logonSourceArray[i].setInitialConnectionInfo(abstractConnectionInfo);
                if (n != -1) continue;
                if (abstractConnectionInfo != null) {
                    if (!abstractConnectionInfo.getClass().equals(iSQLPluginArray[i].getConnectionInfo().getClass())) continue;
                    n = i;
                    continue;
                }
                if (this._mruLogonSourceClassName == null || !this._mruLogonSourceClassName.equals(logonSourceArray[i].getClass().getName())) continue;
                n = i;
            }
            if (n == -1) {
                n = 0;
            }
            MyLogonDialogClient myLogonDialogClient = new MyLogonDialogClient((ISQLConnectionImpl)iSQLConnection, iSQLPluginArray, logonSourceArray);
            LogonDialogFactory.create(parentFrame, null, ISQLImages.getImage("isql16"), logonSourceArray, n, null, myLogonDialogClient, 2);
            if (iSQLConnection.isConnected() && (logonSource = myLogonDialogClient.getLogonSource()) != null) {
                this._mruLogonSourceClassName = logonSource.getClass().getName();
            }
            myLogonDialogClient.destroy();
        }
        if (iSQLConnection.isConnected()) {
            this.postConnect(parentFrame, iSQLConnection);
        }
        return iSQLConnection.isConnected();
    }

    private void postConnect(ParentFrame parentFrame, ISQLConnection iSQLConnection) {
        String string;
        parentFrame.setWindowTitle();
        Preferences.load(iSQLConnection);
        if (!isql.options.quiet) {
            this.warnAboutUnsupportedDatabases(parentFrame, iSQLConnection);
        }
        if ((string = Preferences.getStringOption(iSQLConnection, "isql_log")) != null && string.length() != 0) {
            this.startLogging(iSQLConnection, string);
        }
        _uiActiveConnection = iSQLConnection;
    }

    private void warnAboutUnsupportedDatabases(final JFrame jFrame, ISQLConnection iSQLConnection) {
        if (iSQLConnection.getDatabaseType() == 99) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SybOptionPane.showMessageDialog((Component)jFrame, (Object)GeneralResources.getISQLString(GeneralResources.getName(), "UNSUPPORTED_DATBASE_WARNING"), (String)GeneralResources.getISQLString(GeneralResources.getName(), "Interactive SQL"), (int)2);
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    @Override
    public void openHelp(ISQLConnection iSQLConnection, String string) {
        ParentFrame parentFrame = WindowManager.findFrameByConnection(iSQLConnection);
        if (parentFrame != null) {
            ISQLHelpManager.showHelp((ISQLConnectionImpl)iSQLConnection, parentFrame, string);
        }
    }

    @Override
    public void openPreferencesDialog(ISQLConnection iSQLConnection) {
        ParentFrame parentFrame = WindowManager.findFrameByConnection(iSQLConnection);
        if (parentFrame != null) {
            parentFrame.openCustomizationDialog();
        }
    }

    static Object[] getParentFrames() {
        return _allFrames.toArray();
    }

    private Rectangle getInitialChildWindowLocation() {
        Rectangle rectangle;
        Rectangle rectangle2 = UIUtils.getWorkArea();
        Rectangle rectangle3 = this.loadWindowSize();
        if (rectangle3 == null) {
            rectangle = rectangle2;
            if (_activeFrame == null) {
                int n = 50;
                rectangle3 = new Rectangle(rectangle.x + n, rectangle.y + n, rectangle.width - n * 2, rectangle.height - n * 2);
            } else {
                rectangle3 = _activeFrame.getBounds(null);
            }
        } else {
            rectangle = UIUtils.getWorkArea((int)rectangle3.x, (int)rectangle3.y);
        }
        if (_activeFrame != null) {
            Rectangle rectangle4 = _activeFrame.getBounds(null);
            if (rectangle3.equals(rectangle4)) {
                rectangle3.x += 30;
                rectangle3.y += 30;
            }
            if (rectangle3.x + rectangle3.width > rectangle.x + rectangle.width || rectangle3.y + rectangle3.height > rectangle.y + rectangle.height) {
                rectangle3.x = rectangle.x;
                rectangle3.y = rectangle.y;
            }
        } else {
            for (int i = 0; i < _allFrames.size(); ++i) {
                ParentFrame parentFrame = _allFrames.get(i);
                if (parentFrame.getState() == 1) continue;
                Rectangle rectangle5 = parentFrame.getBounds(null);
                if (rectangle3.equals(rectangle5)) {
                    rectangle3.x += 30;
                    rectangle3.y += 30;
                }
                if (rectangle3.x + rectangle3.width <= rectangle.x + rectangle.width && rectangle3.y + rectangle3.height <= rectangle.y + rectangle.height) continue;
                rectangle3.x = rectangle.x;
                rectangle3.y = rectangle.y;
            }
        }
        return rectangle3;
    }

    private Rectangle loadWindowSize() {
        Rectangle rectangle = Preferences.loadWindowSize(null, "windowPosition");
        return rectangle;
    }

    static ParentFrame getAnyParentFrame() {
        ParentFrame parentFrame = _activeFrame;
        if (parentFrame == null) {
            for (int i = _allFrames.size() - 1; i >= 0; --i) {
                ParentFrame parentFrame2 = _allFrames.get(i);
                if (!parentFrame2.isShowing()) continue;
                parentFrame = parentFrame2;
                break;
            }
        }
        return parentFrame;
    }

    static ParentFrame findFrameByFileName(String string) {
        File file;
        ParentFrame parentFrame = null;
        int n = _allFrames.size();
        for (int i = 0; !(i >= n || (file = (parentFrame = _allFrames.get(i)).getFile()) != null && file.toString().equalsIgnoreCase(string)); ++i) {
            parentFrame = null;
        }
        return parentFrame;
    }

    static ParentFrame findFrameByConnection(ISQLConnection iSQLConnection) {
        ISQLConnection iSQLConnection2;
        ParentFrame parentFrame = null;
        int n = _allFrames.size();
        for (int i = 0; i < n && ((iSQLConnection2 = (parentFrame = _allFrames.get(i)).getConnection()) == null || iSQLConnection2 != iSQLConnection); ++i) {
            parentFrame = null;
        }
        return parentFrame;
    }

    private static ParentFrame findFrameByConnectionName(String string) {
        String string2;
        ISQLConnection iSQLConnection;
        ParentFrame parentFrame = null;
        int n = _allFrames.size();
        for (int i = 0; !(i >= n || (iSQLConnection = (parentFrame = _allFrames.get(i)).getConnection()) != null && ((string2 = iSQLConnection.getName()) == null && string == null || string2 != null && string != null && string2.equalsIgnoreCase(string))); ++i) {
            parentFrame = null;
        }
        return parentFrame;
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        ParentFrame parentFrame = (ParentFrame)windowEvent.getSource();
        if (parentFrame.isVisible()) {
            _uiActiveConnection = parentFrame.getConnection();
            _activeFrame = parentFrame;
        }
    }

    static void notifyFrameClosed(ParentFrame parentFrame) {
        parentFrame.removeWindowListener(_theWindowManager);
        int n = _allFrames.indexOf(parentFrame);
        if (n >= 0) {
            _allFrames.remove(n);
            if (_allFrames.size() == 0) {
                _theWindowManager.requestShutdown();
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        ParentFrame parentFrame = (ParentFrame)windowEvent.getSource();
        WindowManager.notifyFrameClosed(parentFrame);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        ParentFrame parentFrame = (ParentFrame)windowEvent.getSource();
        if (parentFrame == _activeFrame) {
            _uiActiveConnection = null;
            _activeFrame = null;
        }
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public Object getActiveJFrame() {
        return _activeFrame;
    }

    @Override
    public Object getJFrameForConnection(ISQLConnection iSQLConnection) {
        return WindowManager.findFrameByConnection(iSQLConnection);
    }

    public int write(int n, String string) {
        ParentFrame parentFrame = _activeFrame;
        if (parentFrame == null && _allFrames.size() > 0) {
            parentFrame = _allFrames.get(_allFrames.size() - 1);
        }
        int n2 = parentFrame != null ? parentFrame.displaySCCMessage(n, string) : 0;
        return n2;
    }

    static void displayCommandLineHelp(String string) {
        JTextArea jTextArea = new JTextArea(string);
        Font font = jTextArea.getFont();
        jTextArea.setFont(new Font("monospaced", font.getStyle(), font.getSize()));
        jTextArea.setOpaque(false);
        JOptionPane.showMessageDialog(null, jTextArea, ISQLResource.getISQLString(GeneralResources.getName(), "Interactive SQL"), 0);
    }

    private static boolean dbgEnabled() {
        return false;
    }

    static {
        UIUtils.installLookAndFeel();
        if (System.getProperty("isql.splashPage", "1").equals("1")) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(CommonResourceBundle.class.getName());
            new SplashScreen(ISQLImages.getImage("splash"), resourceBundle.getString("SHORT_COPYRIGHT"), null, ISQLImages.getImage("isql16"), ISQLResource.getISQLString(GeneralResources.getName(), "Interactive SQL"));
        }
        _scc = null;
        _allFrames = new ArrayList();
        _uiActiveConnection = null;
        _activeFrame = null;
        _theWindowManager = null;
        _commandLineOptions = null;
        _shutdownRequested = false;
    }

    static class MyLogonDialogClient
    implements LogonDialogClient {
        private ISQLPlugin[] _plugins;
        private LogonSource[] _logonSources;
        private ISQLConnectionImpl _isqlConnection;
        private Vector<String> _warnings;
        private LogonSource _logonSource = null;

        MyLogonDialogClient(ISQLConnectionImpl iSQLConnectionImpl, ISQLPlugin[] iSQLPluginArray, LogonSource[] logonSourceArray) {
            this._isqlConnection = iSQLConnectionImpl;
            this._plugins = iSQLPluginArray;
            this._logonSources = logonSourceArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleOK(JDialog jDialog, LogonSource logonSource) {
            boolean bl = false;
            ISQLPlugin iSQLPlugin = this._plugins[0];
            for (int i = 0; i < this._logonSources.length; ++i) {
                if (this._logonSources[i] != logonSource) continue;
                iSQLPlugin = this._plugins[i];
                break;
            }
            AbstractConnectionInfo abstractConnectionInfo = logonSource.getConnectionInfo();
            this._isqlConnection.setConnectionInfo(iSQLPlugin, abstractConnectionInfo);
            this._warnings = new Vector();
            try {
                Connection connection = this._isqlConnection.getJDBCConnection();
                try {
                    this._isqlConnection.connect(this._warnings);
                }
                catch (SQLException sQLException) {
                    if (sQLException.getErrorCode() == -1152 && abstractConnectionInfo instanceof ASAConnectionInfo) {
                        ChangePasswordDialog changePasswordDialog;
                        while ((changePasswordDialog = new ChangePasswordDialog(jDialog, ISQLResource.getISQLString(GeneralResources.getName(), "CHANGE_PASSWORD_TITLE"), 0, ISQLResource.getISQLString(GeneralResources.getName(), "CHANGE_PASSWORD_TEXT"), abstractConnectionInfo.getUserName())).open()) {
                            ASAConnectionInfo aSAConnectionInfo = (ASAConnectionInfo)this._isqlConnection.getConnectionInfo();
                            aSAConnectionInfo.setPassword(new String(changePasswordDialog.getOldPassword()));
                            aSAConnectionInfo.setNewPassword(changePasswordDialog.getNewPassword());
                            try {
                                this._isqlConnection.connect(this._warnings);
                            }
                            catch (SQLException sQLException2) {
                                logonSource.reportConnectionFailure(sQLException2);
                            }
                            finally {
                                aSAConnectionInfo.setNewPassword(null);
                            }
                        }
                    }
                    throw sQLException;
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this._logonSource = logonSource;
                bl = true;
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                logonSource.reportConnectionFailure(exception);
            }
            return bl;
        }

        void destroy() {
            this._logonSource = null;
            this._isqlConnection = null;
            this._plugins = null;
            this._logonSources = null;
        }

        LogonSource getLogonSource() {
            return this._logonSource;
        }

        Vector<String> getWarnings() {
            return this._warnings;
        }
    }

    class ConnectingDialogClient
    implements Runnable {
        private ISQLPlugin _plugin;
        private AbstractConnectionInfo _info;
        private ISQLConnection _connection;

        ConnectingDialogClient(ISQLConnection iSQLConnection, ISQLPlugin iSQLPlugin, AbstractConnectionInfo abstractConnectionInfo) {
            this._connection = iSQLConnection;
            this._plugin = iSQLPlugin;
            this._info = abstractConnectionInfo;
        }

        @Override
        public void run() {
            WindowManager.this.connect(this._connection, this._plugin, this._info, FrontEnd.PromptBehavior.NEVER, true, null);
        }
    }

    static class DeferredWindowCloser
    implements Runnable {
        private ISQLConnection _connection;

        DeferredWindowCloser(ISQLConnection iSQLConnection) {
            this._connection = iSQLConnection;
        }

        @Override
        public void run() {
            ParentFrame parentFrame = WindowManager.findFrameByConnection(this._connection);
            if (parentFrame != null) {
                parentFrame.close();
            }
            this._connection = null;
        }
    }
}

