/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.sybase.util.DialogUtils;
import com.sybase.util.SybButton;
import com.sybase.util.SybMultiLineLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import sybase.isql.EncodingDialogResources;
import sybase.isql.EncodingDialogResourcesBase;
import sybase.isql.GeneralResources;
import sybase.isql.ISQLResource;
import sybase.isql.InputOutputOptions;

class WriteEncodingDialog
extends JDialog
implements ActionListener {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private String _encoding = null;
    private String _userSelectedEncoding = "UTF-8";
    private boolean _retcode;
    private SybButton _ok = null;
    private SybButton _cancel = null;
    private SybButton _showMoreEncodings = null;
    private JList _encodings = null;
    private boolean _showingAllEncodings = false;
    private String _initialEncoding = null;

    WriteEncodingDialog(JFrame jFrame, String string, String string2) {
        super((Window)jFrame, string, Dialog.ModalityType.DOCUMENT_MODAL);
        Insets insets = new Insets(0, 0, 0, 0);
        EncodingDialogResourcesBase encodingDialogResourcesBase = (EncodingDialogResourcesBase)ISQLResource.getISQLResource(EncodingDialogResources.getName());
        Vector<String> vector = this.getEncodingList();
        this._encodings = new JList<String>(vector);
        this._encodings.setVisibleRowCount(6);
        if (string2 != null) {
            this._encodings.setSelectedValue(this._userSelectedEncoding, true);
        } else {
            this._encodings.setSelectedIndex(0);
        }
        this._showMoreEncodings = new SybButton(encodingDialogResourcesBase.getISQLString("ShowFewerEncodings"));
        this._showMoreEncodings.addActionListener((ActionListener)this);
        Dimension dimension = this._showMoreEncodings.getPreferredSize();
        this._showMoreEncodings.setText(encodingDialogResourcesBase.getISQLString("ShowMoreEncodings"));
        Dimension dimension2 = this._showMoreEncodings.getPreferredSize();
        dimension.width = Math.max(dimension.width, dimension2.width);
        dimension.height = Math.max(dimension.height, dimension2.height);
        this._showMoreEncodings.setPreferredSize(dimension);
        this._showMoreEncodings.setMinimumSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(UIManager.getIcon("OptionPane.warningIcon"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 5, 5), 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        String string3 = string2 == null ? ISQLResource.getISQLString(GeneralResources.getName(), "WRITE_ENCODING_MSG_DEFAULT_ENCODING") : ISQLResource.getFormattedString(GeneralResources.getName(), "WRITE_ENCODING_MSG_SPECIFIC_ENCODING", string2);
        SybMultiLineLabel sybMultiLineLabel = new SybMultiLineLabel(string3);
        gridBagConstraints = new GridBagConstraints(1, 0, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0);
        jPanel.add((Component)sybMultiLineLabel, gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(this._encodings);
        jScrollPane.setAlignmentX(0.0f);
        gridBagConstraints = new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 10, 0), 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 21, 0, insets, 0, 0);
        jPanel.add((Component)this._showMoreEncodings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(3, 2, 1, 1, 1.0, 0.0, 21, 2, insets, 0, 0);
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints);
        this._ok = new SybButton(encodingDialogResourcesBase.getISQLString("OK"));
        this._cancel = new SybButton(encodingDialogResourcesBase.getISQLString("CANCEL"));
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._ok, this._cancel});
        gridBagConstraints = new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 5), 0, 0);
        jPanel.add((Component)this._ok, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 21, 2, insets, 0, 0);
        jPanel.add((Component)this._cancel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        this._ok.addActionListener((ActionListener)this);
        this._cancel.addActionListener((ActionListener)this);
        this.setTitle(string);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(jFrame);
    }

    boolean promptForEncoding() {
        this._retcode = false;
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this._retcode;
    }

    String getEncoding() {
        return this._encoding;
    }

    void destroy() {
        this._encodings = null;
        if (this._showMoreEncodings != null) {
            this._showMoreEncodings.removeActionListener((ActionListener)this);
            this._showMoreEncodings = null;
        }
        if (this._ok != null) {
            this.getRootPane().setDefaultButton(null);
            this._ok.removeActionListener((ActionListener)this);
            this._ok = null;
        }
        if (this._cancel != null) {
            this._cancel.removeActionListener((ActionListener)this);
            this._cancel = null;
        }
        DialogUtils.removeComponents((Container)this);
    }

    private Vector<String> getEncodingList() {
        Vector<String> vector = InputOutputOptions.getEncodingListForDisplay(this._showingAllEncodings, this._userSelectedEncoding);
        vector.remove(0);
        if (this._initialEncoding != null && this._initialEncoding.length() != 0 && !vector.contains(this._initialEncoding)) {
            vector.add(this._initialEncoding);
        }
        return vector;
    }

    private void handleShowMoreEncodings() {
        boolean bl = this._showingAllEncodings = !this._showingAllEncodings;
        if (this._showingAllEncodings) {
            this._showMoreEncodings.setText(ISQLResource.getISQLString(EncodingDialogResources.getName(), "ShowFewerEncodings"));
        } else {
            this._showMoreEncodings.setText(ISQLResource.getISQLString(EncodingDialogResources.getName(), "ShowMoreEncodings"));
        }
        Object e = this._encodings.getSelectedValue();
        this._encodings.setListData(this.getEncodingList());
        if (e != null) {
            this._encodings.setSelectedValue(e, true);
            this._encodings.requestFocusInWindow();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.setVisible(false);
            this._encoding = this._encodings.getSelectedValue().toString();
            this._retcode = true;
        } else if (object == this._cancel || actionEvent.getActionCommand().equals(ESCAPE_KEY_COMMAND)) {
            this.setVisible(false);
            this._retcode = false;
        } else if (object == this._showMoreEncodings) {
            this.handleShowMoreEncodings();
        }
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

