/*
 * Decompiled with CFR 0.152.
 */
package sybase.isql;

import com.ianywhere.errorreporting.ExceptionHandler;
import com.ianywhere.errorreporting.ExceptionHandlerClient;
import com.sybase.asa.logon.ASAConnectionInfo;
import com.sybase.asa.logon.GenericConnectionInfo;
import com.sybase.asa.logon.UltraLiteConnectionInfo;
import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.AppCounter;
import com.sybase.util.CommandLineOption;
import com.sybase.util.CommandLineOptionMetaData;
import com.sybase.util.CommandLineParser;
import com.sybase.util.Launcher;
import com.sybase.util.LineSplitter;
import com.sybase.util.Platform;
import com.sybase.util.UIUtils;
import java.awt.EventQueue;
import java.io.File;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import sybase.isql.CommandLineOptions;
import sybase.isql.Console;
import sybase.isql.ConsoleIO;
import sybase.isql.ErrorMessages;
import sybase.isql.FrontEnd;
import sybase.isql.GUIIO;
import sybase.isql.GeneralResources;
import sybase.isql.IO;
import sybase.isql.ISQLConnection;
import sybase.isql.ISQLConnectionImpl;
import sybase.isql.ISQLExceptionHandlerClient;
import sybase.isql.ISQLParser;
import sybase.isql.ISQLPlugin;
import sybase.isql.ISQLResource;
import sybase.isql.ParseException;
import sybase.isql.ParserStringReader;
import sybase.isql.ParserUtils;
import sybase.isql.PluginMgr;
import sybase.isql.Preferences;
import sybase.isql.ResultsPanel;
import sybase.isql.ResultsProcessor;
import sybase.isql.RunScriptDialog;
import sybase.isql.TokenMgrError;
import sybase.isql.UserAbortedParsingError;
import sybase.isql.WindowManager;

public class isql {
    static final String ON_ERROR_PROMPT = "Prompt";
    static final String ON_ERROR_CONTINUE = "Continue";
    static final String ON_ERROR_STOP = "Stop";
    static final String ON_ERROR_EXIT = "Exit";
    static final String ON_ERROR_NOTIFY_CONTINUE = "Notify_continue";
    static final String ON_ERROR_NOTIFY_STOP = "Notify_stop";
    static final String ON_ERROR_NOTIFY_EXIT = "Notify_exit";
    static final int EXIT_OK = 0;
    static final int EXIT_FAIL = 1;
    static final int EXIT_BAD_DATA = 2;
    static final int EXIT_FILE_ERROR = 3;
    static final int EXIT_OUT_OF_MEMORY = 4;
    static final int EXIT_BREAK = 5;
    static final int EXIT_COMMUNICATIONS_FAIL = 6;
    static final int EXIT_MISSING_DATABASE = 7;
    static final int EXIT_PROTOCOL_MISMATCH = 8;
    static final int EXIT_UNABLE_TO_CONNECT = 9;
    static final int EXIT_ENGINE_NOT_RUNNING = 10;
    static final int EXIT_SERVER_NOT_FOUND = 11;
    static final int EXIT_USAGE = 255;
    static CommandLineOptions options = new CommandLineOptions();
    static int returnCode = 0;
    static AppCounter _appCounter = null;
    static int applicationCount = 0;
    private static Hashtable<ISQLConnection, IO> _ioTable = new Hashtable();
    private static IO _defaultIO = null;
    static FrontEnd _frontEnd = null;
    static String currentlyExectuingStatments = null;
    private static ArrayList<String> _timingLog = null;
    private static long _lastTimingLogEntryTime = 0L;
    private static long _startupTime = 0L;

    public static void AppStarted() {
        if (_appCounter != null) {
            _appCounter.AppStarted();
        } else {
            ++applicationCount;
        }
    }

    public static void AppStopped() {
        if (_frontEnd != null) {
            _frontEnd.destroy();
            _frontEnd = null;
        }
        _defaultIO = null;
        if (_ioTable != null) {
            _ioTable.clear();
        }
        options = null;
        if (_appCounter != null) {
            _appCounter.AppStopped();
        } else if (--applicationCount < 1 && !Launcher.isFastLauncherRunningInProcess((int)Preferences.fastLauncherPort)) {
            System.exit(returnCode);
        }
    }

    static void logStartupProgress(String string) {
    }

    static void notifyDatabaseSelected(ISQLConnection iSQLConnection, String string) {
        isql.notifyCurrentUserChanged(iSQLConnection);
        if (_frontEnd != null) {
            _frontEnd.notifyDatabaseSelected(iSQLConnection, string);
        }
    }

    static void notifyDatabaseListChanged(ISQLConnection iSQLConnection) {
        if (_frontEnd != null) {
            _frontEnd.notifyDatabaseListChanged(iSQLConnection);
        }
    }

    static void notifyCurrentUserChanged(ISQLConnection iSQLConnection) {
        final ISQLConnectionImpl iSQLConnectionImpl = (ISQLConnectionImpl)iSQLConnection;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    String string = iSQLConnectionImpl.getJDBCConnection().getMetaData().getUserName();
                    iSQLConnectionImpl.setUserID(string);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
        try {
            iSQLConnectionImpl.callbackOnWorkerThread(runnable);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_frontEnd != null) {
            _frontEnd.notifyCurrentUserChanged(iSQLConnection);
        }
    }

    static ISQLConnection getUIActiveConnection() {
        ISQLConnection iSQLConnection = _frontEnd != null ? _frontEnd.getUIActiveConnection() : null;
        return iSQLConnection;
    }

    static int getUIActiveDatabaseType() {
        ISQLConnection iSQLConnection = isql.getUIActiveConnection();
        int n = iSQLConnection != null ? iSQLConnection.getDatabaseType() : -1;
        return n;
    }

    static boolean ensureConnected(ISQLConnection iSQLConnection) {
        boolean bl;
        if (iSQLConnection == null) {
            bl = false;
        } else {
            bl = iSQLConnection.isConnected();
            if (!bl) {
                block10: {
                    ISQLConnectionImpl iSQLConnectionImpl;
                    if (iSQLConnection instanceof ISQLConnectionImpl && (iSQLConnectionImpl = (ISQLConnectionImpl)iSQLConnection).canConnect()) {
                        try {
                            iSQLConnection.connect(null);
                        }
                        catch (Exception exception) {
                            if (!(exception instanceof RuntimeException)) break block10;
                            throw (RuntimeException)exception;
                        }
                    }
                }
                if (bl = iSQLConnection.isConnected()) {
                    isql.getIO(iSQLConnection).writeln(ISQLResource.getISQLString(GeneralResources.getName(), "Reconnected to database."), 0);
                    Preferences.load(iSQLConnection);
                    _frontEnd.notifyConnectionOpened(iSQLConnection);
                } else if (_frontEnd != null && _frontEnd.connect(iSQLConnection, ((ISQLConnectionImpl)iSQLConnection).getPlugin(), ((ISQLConnectionImpl)iSQLConnection).getConnectionInfo(), FrontEnd.PromptBehavior.ALWAYS, false, null)) {
                    bl = true;
                } else {
                    isql.getIO(iSQLConnection).writeln(ISQLResource.getISQLString(ErrorMessages.getName(), "You are not connected to a database."), 2);
                }
            }
        }
        return bl;
    }

    static void closeConnection(ISQLConnection iSQLConnection) {
        if (iSQLConnection != null && iSQLConnection.isConnected()) {
            iSQLConnection.disconnect();
            _frontEnd.notifyConnectionClosed(iSQLConnection);
        }
    }

    static ISQLConnection findNamedConnection(String string) {
        return _frontEnd.findConnectionByName(string);
    }

    static void closeNamedConnection(String string) {
        ISQLConnection iSQLConnection = _frontEnd.findConnectionByName(string);
        if (iSQLConnection != null) {
            iSQLConnection.disconnect();
            _frontEnd.notifyConnectionClosed(iSQLConnection);
        }
    }

    static boolean activateNamedConnection(String string) {
        boolean bl = false;
        bl = _frontEnd != null ? _frontEnd.activateNamedConnection(string) : false;
        return bl;
    }

    static void closeAllConnections() {
        if (_frontEnd != null) {
            _frontEnd.closeAllConnections();
        }
    }

    private static void uiIndependentInit() {
        Preferences.load(null);
        if (!PluginMgr.load()) {
            System.exit(1);
        }
    }

    static void uiIndependentFini() {
    }

    static void shutdown() {
        _frontEnd.requestShutdown();
    }

    static boolean isShutdownRequested() {
        return _frontEnd.isShutdownRequested();
    }

    static void log(ISQLConnection iSQLConnection, String string) {
        if (_frontEnd != null) {
            _frontEnd.log(iSQLConnection, string);
        }
    }

    public static void main(String[] stringArray) {
        Platform.installJREFixes();
        isql.AppStarted();
        ExceptionHandler.init((ExceptionHandlerClient)new ISQLExceptionHandlerClient());
        try {
            isql.uiIndependentInit();
            options = isql.parseCommandLine(stringArray);
            if (options != null) {
                if (isql.options.useGUI) {
                    _frontEnd = WindowManager.create();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            _frontEnd.run(options);
                        }
                    });
                } else {
                    _frontEnd = Console.create();
                    _frontEnd.run(options);
                }
            } else if (!Launcher.isFastLauncherRunningInProcess((int)Preferences.fastLauncherPort)) {
                System.exit(255);
            }
        }
        catch (Throwable throwable) {
            ExceptionHandler.handleException((Throwable)throwable);
        }
    }

    public static void openISQL(AppCounter appCounter, AbstractConnectionInfo abstractConnectionInfo, String string, boolean bl) {
        isql.openISQL(appCounter, abstractConnectionInfo, string, bl, 0);
    }

    public static void openISQL(AppCounter appCounter, AbstractConnectionInfo abstractConnectionInfo, String string, boolean bl, int n) {
        try {
            ISQLPlugin iSQLPlugin;
            options = new CommandLineOptions();
            if (abstractConnectionInfo == null) {
                switch (n) {
                    case 1: {
                        abstractConnectionInfo = new ASEConnectionInfo();
                        break;
                    }
                    case 3: {
                        abstractConnectionInfo = new UltraLiteConnectionInfo();
                        break;
                    }
                    case 99: {
                        abstractConnectionInfo = new GenericConnectionInfo();
                        break;
                    }
                    default: {
                        abstractConnectionInfo = new ASAConnectionInfo();
                    }
                }
            }
            isql.options.connectionInfo = abstractConnectionInfo;
            options.setPlugin(PluginMgr.getPluginForDatabaseType(n));
            isql.options.useGUI = true;
            isql.options.executeInitialSQL = bl;
            if (string != null) {
                isql.options.initialSQL = string;
                isql.options.commandLine.append(string);
            }
            if (_frontEnd == null) {
                _appCounter = appCounter;
                ExceptionHandler.init((ExceptionHandlerClient)new ISQLExceptionHandlerClient());
                isql.uiIndependentInit();
                _frontEnd = WindowManager.create();
                isql.AppStarted();
            }
            if (isql.options.connectionInfo != null && (iSQLPlugin = PluginMgr.getPluginForConnectionInfo(isql.options.connectionInfo)) != null) {
                options.setPlugin(iSQLPlugin);
            }
            _frontEnd.run(options);
        }
        catch (Throwable throwable) {
            ExceptionHandler.handleException((Throwable)throwable);
        }
    }

    public static void runScript(final Object object, AbstractConnectionInfo abstractConnectionInfo, final File file, final String string, final boolean bl) throws Exception {
        assert (abstractConnectionInfo != null);
        assert (file != null);
        try {
            isql.uiIndependentInit();
            options = new CommandLineOptions();
            System.setProperty("isql.splashPage", "0");
            _frontEnd = WindowManager.create();
            isql.setDefaultIO(new GUIIO(null));
            ISQLPlugin iSQLPlugin = PluginMgr.getPluginForConnectionInfo(abstractConnectionInfo);
            if (iSQLPlugin == null) {
                return;
            }
            final ISQLConnectionImpl iSQLConnectionImpl = new ISQLConnectionImpl(iSQLPlugin, abstractConnectionInfo);
            try {
                iSQLConnectionImpl.connect(null);
                if (iSQLConnectionImpl.isConnected()) {
                    isql.setIO(iSQLConnectionImpl, new ResultsPanel.SilentIO(isql.getDefaultIO()));
                    if (EventQueue.isDispatchThread()) {
                        RunScriptDialog.create((JFrame)object, iSQLConnectionImpl, file, string, bl);
                    } else {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    RunScriptDialog.create((JFrame)object, iSQLConnectionImpl, file, string, bl);
                                }
                            });
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            catch (Exception exception) {
                return;
            }
            _frontEnd.destroy();
            _frontEnd = null;
            isql.uiIndependentFini();
        }
        catch (Throwable throwable) {
            ExceptionHandler.handleException((Throwable)throwable);
        }
    }

    public static boolean closeAllIsqlWindows() {
        boolean bl;
        if (_frontEnd != null) {
            bl = _frontEnd.destroy();
            if (bl) {
                isql.uiIndependentFini();
                isql.AppStopped();
            }
        } else {
            bl = true;
        }
        return bl;
    }

    protected static CommandLineOptions parseCommandLine(String[] stringArray) {
        File file;
        int n;
        CommandLineOptions commandLineOptions = new CommandLineOptions();
        Object var21_2 = null;
        Object var22_3 = null;
        int n2 = -1;
        Object var24_5 = null;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl3 = false;
        CommandLineOptionMetaData[] commandLineOptionMetaDataArray = new CommandLineOptionMetaData[]{new CommandLineOptionMetaData("c", 1, 0), new CommandLineOptionMetaData("d1", 0, 2), new CommandLineOptionMetaData("f", 1, 12), new CommandLineOptionMetaData("gui", 0, 8), new CommandLineOptionMetaData("jconnect", 0, 3), new CommandLineOptionMetaData("locale", 1, 10), new CommandLineOptionMetaData("nogui", 0, 9), new CommandLineOptionMetaData("odbc", 0, 4), new CommandLineOptionMetaData("onerror", 1, 11), new CommandLineOptionMetaData("q", 0, 6), new CommandLineOptionMetaData("x", 0, 7), new CommandLineOptionMetaData("version", 0, 5), new CommandLineOptionMetaData("", 6, 14)};
        commandLineOptions.commandLine = new StringBuffer();
        for (n = 0; n < stringArray.length; ++n) {
            if (n > 0) {
                commandLineOptions.commandLine.append(' ');
            }
            commandLineOptions.commandLine.append(stringArray[n]);
        }
        bl = false;
        String string = System.getProperty("sybase.native.executable");
        if (string != null && !string.isEmpty() && string.length() > 4 && string.substring(string.length() - 4).equalsIgnoreCase(".exe") && stringArray.length == 1 && (file = new File(stringArray[0])).exists() && file.isFile()) {
            bl = true;
        }
        try {
            Object[] objectArray;
            CommandLineOption[] commandLineOptionArray = CommandLineParser.parse((String)"dbisql", (String[])stringArray, (CommandLineOptionMetaData[])commandLineOptionMetaDataArray);
            if (commandLineOptionArray != null) {
                block19: for (n = 0; n < commandLineOptionArray.length; ++n) {
                    switch (commandLineOptionArray[n].getID()) {
                        case 2: {
                            commandLineOptions.userDebuggingLevel = 1;
                            continue block19;
                        }
                        case 6: {
                            commandLineOptions.quiet = true;
                            continue block19;
                        }
                        case 7: {
                            commandLineOptions.checkSyntaxOnly = true;
                            continue block19;
                        }
                        case 8: {
                            commandLineOptions.useGUI = true;
                            bl = true;
                            continue block19;
                        }
                        case 9: {
                            commandLineOptions.useGUI = false;
                            bl = false;
                            continue block19;
                        }
                        case 10: {
                            bl2 = true;
                            isql.setLocale(commandLineOptionArray[n].getValue());
                            continue block19;
                        }
                        case 11: {
                            if (commandLineOptionArray[n].getValue().equalsIgnoreCase("exit")) {
                                commandLineOptions.defaultOnErrorAction = ON_ERROR_EXIT;
                                continue block19;
                            }
                            if (commandLineOptionArray[n].getValue().equalsIgnoreCase("continue")) {
                                commandLineOptions.defaultOnErrorAction = ON_ERROR_CONTINUE;
                                continue block19;
                            }
                            isql.printCommandLineSyntax(ISQLResource.getFormattedString(ErrorMessages.getName(), "BadOnErrorCmdLineArgument", commandLineOptionArray[n].getValue()));
                            return null;
                        }
                        case 12: {
                            commandLineOptions.file = new File(commandLineOptionArray[n].getValue());
                            if (!commandLineOptions.file.exists()) {
                                System.err.println(ISQLResource.getFormattedString(ErrorMessages.getName(), "FileDoesNotExist", commandLineOptionArray[n].getValue()));
                                return null;
                            }
                            if (commandLineOptions.file.isDirectory()) {
                                System.err.println(ISQLResource.getFormattedString(ErrorMessages.getName(), "NotAFile", commandLineOptionArray[n].getValue()));
                                return null;
                            }
                            commandLineOptions.connectOnStartup = false;
                            continue block19;
                        }
                        case 13: {
                            commandLineOptions.tail.append(commandLineOptionArray[n].getValue());
                            continue block19;
                        }
                        case 3: 
                        case 4: {
                            continue block19;
                        }
                        case 0: {
                            bl3 = true;
                            arrayList.add("-c");
                            arrayList.add(commandLineOptionArray[n].getValue());
                            continue block19;
                        }
                        case 14: {
                            arrayList.add(commandLineOptionArray[n].getValue());
                            continue block19;
                        }
                        case -1: {
                            isql.printCommandLineSyntax(null);
                            return null;
                        }
                        case 5: {
                            isql.printVersion();
                            return null;
                        }
                    }
                }
            }
            if (!bl2) {
                isql.setLocale(UIUtils.getLanguageCode((String)"SALANG", (String)("SOFTWARE\\Sybase\\SQL Anywhere\\" + Integer.toString(11) + "." + Integer.toString(0))));
            }
            commandLineOptions.connectionInfo = null;
            if (arrayList.size() > 0) {
                String[] stringArray2 = new String[arrayList.size()];
                arrayList.toArray(stringArray2);
                ISQLPlugin[] iSQLPluginArray = PluginMgr.getPluginList();
                objectArray = new ISQLPlugin.CommandLineOptionAffinity[]{ISQLPlugin.CommandLineOptionAffinity.STRONG, ISQLPlugin.CommandLineOptionAffinity.WEAK, ISQLPlugin.CommandLineOptionAffinity.NONE};
                block20: for (int i = 0; i < objectArray.length; ++i) {
                    for (n = 0; n < iSQLPluginArray.length; ++n) {
                        commandLineOptions.connectionInfo = iSQLPluginArray[n].getConnectionInfoFromCommandLineOptions(stringArray2, (ISQLPlugin.CommandLineOptionAffinity)((Object)objectArray[i]));
                        if (commandLineOptions.connectionInfo == null) continue;
                        commandLineOptions.setPlugin(iSQLPluginArray[n]);
                        break block20;
                    }
                }
                for (n = 0; n < iSQLPluginArray.length; ++n) {
                    stringArray2 = iSQLPluginArray[n].processCommandLineOptions(stringArray2);
                }
                for (n = 0; n < stringArray2.length; ++n) {
                    String string2 = stringArray2[n];
                    if ((string2.equalsIgnoreCase("-c") || string2.equalsIgnoreCase("/c") || string2.equalsIgnoreCase("-datasource") || string2.equalsIgnoreCase("/datasource") || string2.equalsIgnoreCase("-host") || string2.equalsIgnoreCase("/host") || string2.equalsIgnoreCase("-port") || string2.equalsIgnoreCase("/port")) && n < stringArray2.length - 1) {
                        ++n;
                        continue;
                    }
                    if (commandLineOptions.tail.length() > 0) {
                        commandLineOptions.tail.append(' ');
                    }
                    commandLineOptions.tail.append(string2);
                }
            }
            if (commandLineOptions.tail.length() > 0 && !bl) {
                commandLineOptions.useGUI = false;
            }
            if (bl && !bl3 && commandLineOptions.file == null && commandLineOptions.tail.length() != 0 && (file = new File(commandLineOptions.tail.toString())).exists() && file.isFile()) {
                commandLineOptions.file = file;
                commandLineOptions.tail.setLength(0);
                commandLineOptions.connectOnStartup = false;
            }
            if (commandLineOptions.getPlugin() == null && (objectArray = PluginMgr.getPluginList()) != null) {
                commandLineOptions.setPlugin(objectArray[0]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            isql.printCommandLineSyntax(illegalArgumentException.getMessage());
            commandLineOptions = null;
        }
        return commandLineOptions;
    }

    private static void setLocale(String string) {
        Locale locale;
        Locale locale2 = Locale.getDefault();
        String string2 = locale2.getLanguage();
        String string3 = locale2.getCountry();
        String string4 = locale2.getVariant();
        String[] stringArray = string.split("_");
        if (stringArray.length == 3) {
            string4 = stringArray[2];
        }
        if (stringArray.length >= 2) {
            string3 = stringArray[1];
        }
        if (stringArray.length >= 1) {
            string2 = stringArray[0];
        }
        if (!(locale = new Locale(string2, string3, string4)).equals(locale2)) {
            Locale.setDefault(locale);
            UIUtils.resetAWTToolkitResources();
        }
    }

    static String stripQuotes(String string) {
        String string2 = string;
        char c = string.charAt(0);
        if (c == '\"') {
            char c2 = string.charAt(string.length() - 1);
            string2 = c == c2 && string.length() > 1 ? string.substring(1, string.length() - 1) : "";
        }
        return string2;
    }

    static void execute(FrontEnd frontEnd, ISQLConnection iSQLConnection, String string, ResultsProcessor resultsProcessor) {
        ParserStringReader parserStringReader = new ParserStringReader(string);
        ISQLParser iSQLParser = ParserUtils.getParser(null, iSQLConnection, parserStringReader);
        iSQLParser.setResultsProcessor(resultsProcessor);
        currentlyExectuingStatments = string;
        try {
            iSQLParser.parse(iSQLConnection, isql.options.quiet);
        }
        catch (TokenMgrError tokenMgrError) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ISQLResource.getISQLString(ErrorMessages.getName(), "Could not execute statement."));
            stringBuffer.append("\n");
            stringBuffer.append(tokenMgrError.getMessage());
            isql.getIO(iSQLConnection).writeln(stringBuffer.toString(), 2);
        }
        catch (ParseException parseException) {
            isql.getIO(iSQLConnection).writeln(parseException.getMessage(), 2);
        }
        catch (UserAbortedParsingError userAbortedParsingError) {
            // empty catch block
        }
        currentlyExectuingStatments = null;
    }

    static boolean connect(ISQLConnection iSQLConnection, ISQLPlugin iSQLPlugin, AbstractConnectionInfo abstractConnectionInfo, boolean bl, boolean bl2, Vector<String> vector) {
        boolean bl3 = _frontEnd != null ? _frontEnd.connect(iSQLConnection, iSQLPlugin, abstractConnectionInfo, bl ? FrontEnd.PromptBehavior.IF_NEEDED : FrontEnd.PromptBehavior.NEVER, bl2, vector) : false;
        return bl3;
    }

    private static void printVersion() {
        String string = Integer.toString(11) + "." + Integer.toString(0) + "." + Integer.toString(1);
        System.out.println(ISQLResource.getFormattedString(GeneralResources.getName(), "Sybase Adaptive Server Anywhere ISQL Version {0}, build {1}", string, Integer.toString(2630)));
    }

    private static void printCommandLineSyntax(String string) {
        int n;
        String string2;
        String string3 = Integer.toString(11) + "." + Integer.toString(0) + "." + Integer.toString(1) + "." + 2630;
        String string4 = ISQLResource.getFormattedString(GeneralResources.getName(), "CommandLineHelp", string3);
        if (string != null) {
            string4 = string + "\n\n" + string4;
        }
        boolean bl = true;
        if (Platform.isWindows() && (string2 = System.getProperty("sybase.native.executable")) != null && string2.length() > 4 && (n = string2.lastIndexOf(46)) != -1 && string2.regionMatches(true, n + 1, "exe", 0, 3)) {
            bl = false;
        }
        if (bl) {
            System.err.println(string4);
        } else {
            System.setProperty("isql.splashPage", "0");
            try {
                Class<?> clazz = Class.forName("sybase.isql.WindowManager");
                Method method = clazz.getDeclaredMethod("displayCommandLineHelp", String.class);
                method.invoke(null, string4);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                System.err.println(string4);
            }
        }
    }

    static void help(ISQLConnection iSQLConnection, String string) {
        block3: {
            if (string != null && string.length() > 0) {
                try {
                    Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    String[] stringArray;
                    ISQLPlugin iSQLPlugin = ((ISQLConnectionImpl)iSQLConnection).getPlugin();
                    if (iSQLPlugin == null || (stringArray = iSQLPlugin.getHelpIDForSQL(string)) == null) break block3;
                    string = stringArray[0];
                }
            }
        }
        _frontEnd.openHelp(iSQLConnection, string);
    }

    static boolean startLogging(ISQLConnection iSQLConnection, String string) {
        boolean bl = isql.ensureConnected(iSQLConnection) ? _frontEnd.startLogging(iSQLConnection, string) : false;
        return bl;
    }

    static void stopLogging(ISQLConnection iSQLConnection) {
        if (_frontEnd != null && iSQLConnection != null && iSQLConnection.isConnected()) {
            _frontEnd.stopLogging(iSQLConnection);
        }
    }

    static IO getIO(ISQLConnection iSQLConnection) {
        IO iO = null;
        if (iSQLConnection != null) {
            iO = _ioTable.get(iSQLConnection);
        }
        if (iO == null && _frontEnd != null) {
            iO = _frontEnd.getIO();
        }
        if (iO == null) {
            iO = _defaultIO;
        }
        if (iO == null) {
            iO = new ConsoleIO();
        }
        return iO;
    }

    static IO getIO() {
        IO iO = _frontEnd != null ? isql.getIO(_frontEnd.getUIActiveConnection()) : _defaultIO;
        return iO;
    }

    static IO getDefaultIO() {
        return _defaultIO;
    }

    static void setDefaultIO(IO iO) {
        _defaultIO = iO;
    }

    static void discardFrameIO(ISQLConnection iSQLConnection) {
        _ioTable.remove(iSQLConnection);
    }

    static ISQLConnection getConnectionFromIO(IO iO) {
        ISQLConnection iSQLConnection = null;
        Enumeration<ISQLConnection> enumeration = _ioTable.keys();
        while (enumeration.hasMoreElements()) {
            ISQLConnection iSQLConnection2 = enumeration.nextElement();
            IO iO2 = _ioTable.get(iSQLConnection2);
            if (iO2 != iO) continue;
            iSQLConnection = iSQLConnection2;
            break;
        }
        return iSQLConnection;
    }

    static void setIO(ISQLConnection iSQLConnection, IO iO) {
        if (iSQLConnection != null) {
            _ioTable.remove(iSQLConnection);
            if (iO != null) {
                _ioTable.put(iSQLConnection, iO);
            }
        }
    }

    static void enableUIForConnection(ISQLConnection iSQLConnection, boolean bl) {
        if (_frontEnd != null) {
            _frontEnd.enableUIForConnection(iSQLConnection, bl);
        }
    }

    static void openPreferencesDialog(ISQLConnection iSQLConnection) {
        if (iSQLConnection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        _frontEnd.openPreferencesDialog(iSQLConnection);
    }

    static boolean useGUI() {
        return options != null && isql.options.useGUI;
    }

    static Object getJFrame() {
        Object object = _frontEnd != null ? _frontEnd.getActiveJFrame() : null;
        return object;
    }

    static Object getJFrame(ISQLConnection iSQLConnection) {
        Object object = _frontEnd != null ? _frontEnd.getJFrameForConnection(iSQLConnection) : null;
        return object;
    }

    static void clear(ISQLConnection iSQLConnection) {
        _frontEnd.clear(iSQLConnection);
    }

    static void changeWindowConnection(ISQLConnection iSQLConnection, ISQLConnection iSQLConnection2) {
        _frontEnd.changeWindowConnection(iSQLConnection, iSQLConnection2);
    }

    static void closeUIForConnection(ISQLConnection iSQLConnection) {
        if (_frontEnd != null) {
            _frontEnd.closeUIForConnection(iSQLConnection);
        }
    }

    static String formatSQLExceptionMessage(SQLException sQLException) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = sQLException.getLocalizedMessage();
        if (string2 != null && string2.length() > 0) {
            Pattern pattern = Pattern.compile("\\A(\\[[^\\]]+\\])+");
            Matcher matcher = pattern.matcher(string2);
            LineSplitter lineSplitter = matcher.find() ? new LineSplitter(string2.substring(matcher.end()), 72) : new LineSplitter(string2, 72);
            while (lineSplitter.hasMoreLines()) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(lineSplitter.nextLine());
            }
        }
        if ((string = sQLException.getSQLState()) == null) {
            string = ISQLResource.getISQLString(ErrorMessages.getName(), "NoSQLState");
        }
        String string3 = sQLException.getClass().getName();
        boolean bl = string3.endsWith(".SybSQLException");
        stringBuffer.append("\n");
        if (bl) {
            if (string == null || string.equals("ZZZZZ")) {
                stringBuffer.append(ISQLResource.getFormattedString(ErrorMessages.getName(), "SybaseErrorCode", Integer.toString(sQLException.getErrorCode())));
            } else {
                stringBuffer.append(ISQLResource.getFormattedString(ErrorMessages.getName(), "SybaseErrorCodeAndSQLState", Integer.toString(sQLException.getErrorCode()), string));
            }
        } else {
            stringBuffer.append(ISQLResource.getFormattedString(ErrorMessages.getName(), "SQLCodeAndODBC3State", Integer.toString(sQLException.getErrorCode()), string));
        }
        return stringBuffer.toString();
    }

    static boolean shouldUseQueryEditor(ISQLConnection iSQLConnection) {
        int n = iSQLConnection != null && iSQLConnection.isConnected() ? iSQLConnection.getDatabaseType() : options.getDefaultDatabaseType();
        boolean bl = n == 0 || n == 2 || n == 1;
        return bl;
    }
}

