/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua;

import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentInfo;
import com.sybase.ua.AgentURL;
import java.rmi.RemoteException;
import java.util.Map;

public class AgentConnectionFactory {
    public static final String PROTOCOL_RMI = "rmi";
    public static final String DEFAULT_RMI_PORT = "9999";

    public static AgentConnection createAgentConnection(AgentInfo agentInfo) throws RemoteException {
        return com.sybase.ua.connection.AgentConnectionFactory.createAgentConnection(agentInfo);
    }

    public static AgentConnection createAgentConnection(AgentURL url) throws RemoteException {
        return com.sybase.ua.connection.AgentConnectionFactory.createAgentConnection(url);
    }

    @Deprecated
    public static AgentConnection createAgentConnection(AgentInfo agentInfo, char[] authorizationKey, char[] signature) throws RemoteException {
        AgentConnection conn = AgentConnectionFactory.createAgentConnection(agentInfo);
        conn.connect(authorizationKey, signature);
        return conn;
    }

    @Deprecated
    public static AgentConnection createAgentConnection(AgentInfo agentInfo, String username, char[] password) throws RemoteException {
        AgentConnection conn = AgentConnectionFactory.createAgentConnection(agentInfo);
        conn.connect(username, password);
        return conn;
    }

    public static AgentConnection createAgentConnection(String url) throws RemoteException {
        return AgentConnectionFactory.createAgentConnection(AgentURL.createAgentURL(url));
    }

    @Deprecated
    public static AgentConnection createAgentConnection(String url, Map<String, Object> credentialMap) throws RemoteException {
        AgentConnection conn = AgentConnectionFactory.createAgentConnection(url);
        conn.connect(credentialMap);
        return conn;
    }

    public static AgentConnection createAgentConnection(String protocol, String host, int port) throws RemoteException {
        return AgentConnectionFactory.createAgentConnection(AgentURL.createAgentURL(protocol, host, port));
    }

    public static AgentConnection createAgentConnection(String protocol, String host, String port) throws RemoteException {
        return AgentConnectionFactory.createAgentConnection(AgentURL.createAgentURL(protocol, host, Integer.valueOf(port)));
    }

    @Deprecated
    public static AgentConnection createAgentConnection(String protocol, String host, String port, char[] authorizationKey, char[] signature) throws RemoteException {
        if (port == null || port.trim().equals("")) {
            port = DEFAULT_RMI_PORT;
        }
        AgentConnection conn = AgentConnectionFactory.createAgentConnection(protocol, host, port);
        conn.connect(authorizationKey, signature);
        return conn;
    }

    @Deprecated
    public static AgentConnection createAgentConnection(String protocol, String host, String port, String username, char[] password) throws RemoteException {
        if (port == null || port.trim().equals("")) {
            port = DEFAULT_RMI_PORT;
        }
        AgentConnection conn = AgentConnectionFactory.createAgentConnection(protocol, host, port);
        conn.connect(username, password);
        return conn;
    }

    private AgentConnectionFactory() {
    }
}

