/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua;

import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.AgentConnectionFactory;
import com.sybase.ua.AgentInfo;
import com.sybase.ua.DiscoveryFilter;
import com.sybase.ua.FastDiscoveryFilter;
import com.sybase.ua.PluginInfo;
import com.sybase.ua.ServiceInfo;
import com.sybase.ua.UDPFilteredDiscoveryThread;
import com.sybase.ua.discovery.AgentDiscoveryAdaptor;
import com.sybase.ua.discovery.AgentDiscoveryJiniAdaptor;
import com.sybase.ua.discovery.AgentDiscoveryLdapAdaptor;
import com.sybase.ua.discovery.AgentDiscoveryUDPAdaptor;
import com.sybase.ua.discovery.DiscoveryException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgentDiscovery {
    public static final String SERVICE_LDAP = "ldap";
    public static final String SERVICE_UDP = "udp";
    public static final String SERVICE_JINI = "jini";
    public static final String SERVICE_SLP = "slp";
    public static final String SERVICE_SNMP = "snmp";
    public static final String SUPPORTED_DISCOVERY_PROTOCOLS = "ldap, udp, jini";
    public static final String DEFAULT_SERVICE = "udp";
    private String discoverService;
    private final String host;
    private final String port;
    private List<AgentInfo> agentInfos = new ArrayList<AgentInfo>();
    private AgentDiscoveryAdaptor discoveryAdaptor;
    private static Log log = LogFactory.getLog(AgentDiscovery.class);
    private long timeOut;

    public AgentDiscovery(String discoveryService) throws DiscoveryException {
        this(discoveryService, null, null);
    }

    public AgentDiscovery(String discoveryService, String host) throws DiscoveryException {
        this(discoveryService, host, null);
    }

    public AgentDiscovery(String discoveryServiceName, String hostname, String port) throws DiscoveryException {
        this.discoverService = discoveryServiceName;
        this.host = hostname;
        this.port = port;
        if (this.discoverService == null) {
            this.discoverService = "udp";
        }
        if (this.discoverService.trim().equals("")) {
            this.discoverService = "udp";
        }
        if (this.discoverService.equalsIgnoreCase(SERVICE_LDAP)) {
            this.discoveryAdaptor = new AgentDiscoveryLdapAdaptor();
        } else if (this.discoverService.equalsIgnoreCase("udp")) {
            this.discoveryAdaptor = new AgentDiscoveryUDPAdaptor();
        } else if (this.discoverService.equalsIgnoreCase(SERVICE_JINI)) {
            this.discoveryAdaptor = new AgentDiscoveryJiniAdaptor();
        } else {
            String msg = "Unsupported discovery service protocol: " + this.discoverService + ". Currently supported discovery protocols are: " + SUPPORTED_DISCOVERY_PROTOCOLS;
            throw new DiscoveryException(msg);
        }
        this.discoveryAdaptor.setHost(this.host);
        this.discoveryAdaptor.setPort(this.port);
    }

    public void discover() throws DiscoveryException {
        this.discover(new Properties());
    }

    public void discover(DiscoveryFilter filter) throws DiscoveryException {
        log.debug((Object)"Discovering agents...");
        List<AgentInfo> agentInfos = this.discoveryAdaptor.discover();
        this.agentInfos.clear();
        if (filter == null) {
            if (agentInfos != null) {
                this.agentInfos.addAll(agentInfos);
            }
        } else if (agentInfos != null) {
            List<AgentInfo> filteredConnections = null;
            filteredConnections = filter instanceof FastDiscoveryFilter ? (this.getDiscoverService().equalsIgnoreCase("udp") ? this.doFastFilterUDP(agentInfos, (FastDiscoveryFilter)filter) : this.doFastFilter(agentInfos, (FastDiscoveryFilter)filter)) : this.doAdvancedFilter(agentInfos, filter);
            if (filteredConnections != null) {
                this.agentInfos.addAll(filteredConnections);
            }
        }
    }

    public void discover(Properties discoveryProperties) throws DiscoveryException {
        log.debug((Object)"Discovering agents...");
        List<AgentInfo> agentInfoList = this.discoveryAdaptor.discover(discoveryProperties);
        this.agentInfos.clear();
        this.agentInfos.addAll(agentInfoList);
    }

    public void dispose() {
        if (this.discoveryAdaptor != null) {
            this.discoveryAdaptor.dispose();
            this.discoveryAdaptor = null;
        }
        if (this.agentInfos != null) {
            this.agentInfos.clear();
            this.agentInfos = null;
        }
    }

    public List<AgentConnection> getAgentConnections() throws AgentConnectionException {
        ArrayList<AgentConnection> agentConns = new ArrayList<AgentConnection>();
        for (AgentInfo agentInfo : this.agentInfos) {
            AgentConnection agentConn = null;
            try {
                agentConn = AgentConnectionFactory.createAgentConnection(agentInfo);
            }
            catch (RemoteException e) {
                log.debug((Object)e.toString());
                continue;
            }
            agentConns.add(agentConn);
        }
        return agentConns;
    }

    public List<AgentInfo> getAgentInfos() {
        return this.agentInfos;
    }

    public String getDiscoverService() {
        return this.discoverService;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public long getTimeElapsed() throws DiscoveryException {
        if (this.discoveryAdaptor == null) {
            throw new DiscoveryException("Discovery adaptor is null.");
        }
        return this.discoveryAdaptor.getTimeElapsed();
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(long timeout) {
        this.timeOut = timeout;
        if (this.discoveryAdaptor != null) {
            this.discoveryAdaptor.setTimeOut(timeout);
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private List<AgentInfo> doAdvancedFilter(List<AgentInfo> agentInfoList, DiscoveryFilter filter) {
        ArrayList<AgentInfo> result = new ArrayList<AgentInfo>();
        for (AgentInfo agentInfo : agentInfoList) {
            try {
                AgentConnection agentConn = AgentConnectionFactory.createAgentConnection(agentInfo);
                agentConn.connect();
                boolean acceptAgent = false;
                if (filter.acceptAgent(agentInfo, agentConn)) {
                    boolean acceptService = false;
                    for (String serviceMBeanName : agentConn.getAgentServiceMBeanNames()) {
                        String serviceName = (String)agentConn.getAgentServicePropertyByMBeanName(serviceMBeanName, "Name");
                        if (!filter.acceptAgentService(serviceName, serviceMBeanName, agentConn)) continue;
                        acceptService = true;
                        break;
                    }
                    if (acceptService) {
                        boolean acceptPlugin = false;
                        for (String mbeanName : agentConn.getAgentPluginMBeanNames()) {
                            String version;
                            String id;
                            String name = (String)agentConn.getAgentPluginProperty(mbeanName, "Name");
                            if (!filter.acceptAgentPlugin(name, id = (String)agentConn.getAgentPluginProperty(mbeanName, "Id"), version = (String)agentConn.getAgentPluginProperty(mbeanName, "Version"), mbeanName, agentConn)) continue;
                            acceptPlugin = true;
                            break;
                        }
                        acceptAgent = acceptPlugin;
                    }
                } else {
                    acceptAgent = false;
                }
                if (acceptAgent) {
                    result.add(agentInfo);
                }
                agentConn.disconnect();
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage());
            }
        }
        return result;
    }

    private List<AgentInfo> doFastFilter(List<AgentInfo> agentInfoList, FastDiscoveryFilter filter) {
        ArrayList<AgentInfo> result = new ArrayList<AgentInfo>();
        for (AgentInfo agentInfo : agentInfoList) {
            try {
                boolean acceptAgent = false;
                if (filter.acceptAgent(agentInfo)) {
                    boolean acceptService = false;
                    for (ServiceInfo serviceInfo : agentInfo.getServiceInfos()) {
                        if (!filter.acceptAgentService(serviceInfo)) continue;
                        acceptService = true;
                        break;
                    }
                    if (acceptService) {
                        boolean acceptPlugin = false;
                        for (PluginInfo pluginInfo : agentInfo.getPluginInfos()) {
                            if (!filter.acceptAgentPlugin(pluginInfo)) continue;
                            acceptPlugin = true;
                            break;
                        }
                        acceptAgent = acceptPlugin;
                    }
                }
                if (!acceptAgent) continue;
                result.add(agentInfo);
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AgentInfo> doFastFilterUDP(List<AgentInfo> agentInfoList, FastDiscoveryFilter filter) {
        UDPFilteredDiscoveryThread thread = new UDPFilteredDiscoveryThread(agentInfoList, this.getTimeOut());
        thread.start();
        Object object = thread.getMonitor();
        synchronized (object) {
            try {
                log.debug((Object)("wait for " + this.getTimeOut() + " milliseconds..."));
                thread.getMonitor().wait(this.getTimeOut());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        List<AgentInfo> completeAgentInfoList = thread.getFinalAgentInfoList();
        List<AgentInfo> result = this.doFastFilter(completeAgentInfoList, filter);
        return result;
    }
}

