/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua;

import com.sybase.ua.PluginInfo;
import com.sybase.ua.ServiceInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;

public class AgentInfo
implements Serializable {
    static final long serialVersionUID = -1488760995754176613L;
    private String version = "";
    private String buildNumber = "";
    private String host;
    private String agentHome = "";
    private String rMIPort;
    private Date timeStarted;
    private String oSName = "";
    private String oSVersion = "";
    private String oSArchitecture = "";
    private List<PluginInfo> pluginInfos = new ArrayList<PluginInfo>(1);
    private List<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>(1);
    private boolean securityAgent = true;
    private Date timeUpdated;
    private Date timeChecked;
    private String status = "UNKNOWN";

    public AgentInfo() {
        this.timeUpdated = this.timeChecked = new Date();
    }

    public AgentInfo(String host, String version, String buildNumber, Date timeStarted, String rmiPort, String agentHome, String osName, String osVersion, String osArch, List<PluginInfo> pluginInfos, List<ServiceInfo> serviceInfos) {
        this.setHost(host);
        this.setVersion(version);
        this.setBuildNumber(buildNumber);
        this.setTimeStarted(timeStarted);
        this.setRMIPort(rmiPort);
        this.setAgentHome(agentHome);
        this.setOSName(osName);
        this.setOSVersion(osVersion);
        this.setOSArchitecture(osArch);
        this.pluginInfos = pluginInfos;
        this.serviceInfos = serviceInfos;
        this.timeUpdated = new Date();
    }

    public String getAgentHome() {
        return this.agentHome;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public String getConnectionURL() {
        return this.getRMIConnectionURL();
    }

    public String getHost() {
        return this.host;
    }

    public String getOSArchitecture() {
        return this.oSArchitecture;
    }

    public String getOSName() {
        return this.oSName;
    }

    public String getOSVersion() {
        return this.oSVersion;
    }

    public PluginInfo getPluginInfo(String pluginId, String pluginVersion, String pluginIntanceNumber) {
        PluginInfo result = null;
        for (PluginInfo pluginInfo : this.getPluginInfos()) {
            if (!pluginId.equals(pluginInfo.getId()) || !pluginVersion.equals(pluginInfo.getVersion()) || !pluginIntanceNumber.equals(pluginInfo.getInstanceNumberAsString())) continue;
            result = pluginInfo;
            break;
        }
        return result;
    }

    public List<PluginInfo> getPluginInfos() {
        return this.pluginInfos;
    }

    public List<PluginInfo> getPluginInfos(String pluginId) {
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>(1);
        for (PluginInfo pluginInfo : this.getPluginInfos()) {
            if (!pluginId.equals(pluginInfo.getId())) continue;
            result.add(pluginInfo);
        }
        return result;
    }

    public List<PluginInfo> getPluginInfos(String pluginId, String pluginVersion) {
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>(1);
        for (PluginInfo pluginInfo : this.getPluginInfos()) {
            if (!pluginId.equals(pluginInfo.getId()) || !pluginVersion.equals(pluginInfo.getVersion())) continue;
            result.add(pluginInfo);
        }
        return result;
    }

    public List<PluginInfo> getPluginInfosWithLatestVersion(String pluginId) throws Exception {
        String latestVersion = this.getPluginLatestVersion(pluginId);
        return this.getPluginInfos(pluginId, latestVersion);
    }

    public String getPluginLatestVersion(String pluginId) throws Exception {
        List<String> versions = this.getPluginVersions(pluginId);
        if (versions.isEmpty()) {
            throw new Exception("No versions are found with plugin id " + pluginId);
        }
        String latestVersion = versions.get(versions.size() - 1);
        return latestVersion;
    }

    public List<String> getPluginVersions(String pluginId) {
        TreeMap<String, String> versionsTreeMap = new TreeMap<String, String>();
        for (PluginInfo pluginInfo : this.getPluginInfos()) {
            if (!pluginId.equals(pluginInfo.getId())) continue;
            String version = pluginInfo.getVersion();
            versionsTreeMap.put(version, version);
        }
        ArrayList<String> versionList = new ArrayList<String>(1);
        versionList.addAll(versionsTreeMap.keySet());
        return versionList;
    }

    public String getRMIConnectionURL() {
        String protocol = "rmi";
        String url = "service:jmx:" + "rmi".toLowerCase() + ":///jndi/" + "rmi".toLowerCase() + "://" + this.getHost() + ":" + this.getRMIPort() + "/agent";
        return url;
    }

    @Deprecated
    public String getRMIPort() {
        return this.rMIPort;
    }

    public ServiceInfo getServiceInfo(String serviceId) {
        ServiceInfo result = null;
        for (ServiceInfo serviceInfo : this.getServiceInfos()) {
            if (!serviceInfo.getId().equals(serviceId)) continue;
            result = serviceInfo;
            break;
        }
        return result;
    }

    public List<ServiceInfo> getServiceInfos() {
        return this.serviceInfos;
    }

    public String getStatus() {
        return this.status;
    }

    public Date getTimeChecked() {
        return this.timeChecked;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isSecurityAgent() {
        if (this.serviceInfos == null || this.serviceInfos.isEmpty()) {
            return this.securityAgent;
        }
        boolean securityAgent = false;
        for (ServiceInfo serviceInfo : this.serviceInfos) {
            if (serviceInfo == null || !"SecurityService".equals(serviceInfo.getId()) || !serviceInfo.isStarted()) continue;
            Object secuityDelegate = serviceInfo.getDiscoveryProperty("securityDelegate");
            if (secuityDelegate != null) {
                if ("true".equalsIgnoreCase(secuityDelegate.toString())) continue;
                securityAgent = true;
                break;
            }
            securityAgent = true;
            break;
        }
        return securityAgent;
    }

    public boolean isSecurityDelegate() {
        if (this.serviceInfos == null || this.serviceInfos.isEmpty()) {
            return false;
        }
        boolean securityDelegate = false;
        for (ServiceInfo serviceInfo : this.serviceInfos) {
            Object secuityDelegate;
            if (serviceInfo == null || !"SecurityService".equals(serviceInfo.getId()) || !serviceInfo.isStarted() || (secuityDelegate = serviceInfo.getDiscoveryProperty("securityDelegate")) == null || !"true".equalsIgnoreCase(secuityDelegate.toString())) continue;
            securityDelegate = true;
            break;
        }
        return securityDelegate;
    }

    public void setAgentHome(String agentHome) {
        this.agentHome = agentHome;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setOSArchitecture(String oSArchitecture) {
        this.oSArchitecture = oSArchitecture;
    }

    public void setOSName(String oSName) {
        this.oSName = oSName;
    }

    public void setOSVersion(String oSVersion) {
        this.oSVersion = oSVersion;
    }

    public void setPluginInfos(List<PluginInfo> pluginInfos) {
        this.pluginInfos = pluginInfos;
    }

    public void setRMIPort(String rMIPort) {
        this.rMIPort = rMIPort;
    }

    public void setSecurityAgent(boolean securityAgent) {
        this.securityAgent = securityAgent;
    }

    public void setServiceInfos(List<ServiceInfo> serviceInfos) {
        this.serviceInfos = serviceInfos;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setTimeChecked(Date timeChecked) {
        this.timeChecked = timeChecked;
    }

    public void setTimeStarted(Date timeStarted) {
        this.timeStarted = timeStarted;
    }

    public void setTimeUpdated(Date timeUpdated) {
        this.timeUpdated = timeUpdated;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return this.host;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

