/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua;

import java.net.MalformedURLException;
import javax.management.remote.JMXServiceURL;

public class AgentURL {
    public static final String FULL_URL_PREFIX = "service:jmx:";
    public static final String SHORT_URL_SYNTAX = "[<protocol>://]<host>[:<port>]";
    public static final String FULL_URL_SYNTAX = "service:jmx:<protocol>:///jndi/<protocol>://<host>:<port>/agent";
    public static final String SUPPORTED_PROTOCOLS = "rmi";
    public static final String PROTOCOL_RMI = "rmi";
    public static final String DEFAULT_PROTOCOL = "rmi";
    public static final String DEFAULT_RMI_PORT = "9999";
    private String protocol;
    private String host;
    private String port;
    private final JMXServiceURL jmxServiceURL;
    private final String uRLShortFormat;
    private String uRLLongFormat;

    public static AgentURL createAgentURL(String agentURL) throws IllegalArgumentException {
        try {
            return new AgentURL(agentURL);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static AgentURL createAgentURL(String protocol, String host, Integer port) throws IllegalArgumentException {
        try {
            return new AgentURL(protocol, host, port.toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static final String getAgentURLLongFormat(String protocol, String host, Integer port) {
        return String.format("service:jmx:%s:///jndi/%s://%s:%d/agent", protocol.toLowerCase(), protocol.toLowerCase(), AgentURL.bracketAnIvp6Host(host), port);
    }

    public static final String getAgentURLLongFormat(String protocol, String host, String port) {
        return AgentURL.getAgentURLLongFormat(protocol, host, Integer.valueOf(port));
    }

    public static final String getAgentURLShortFormat(String protocol, String host, Integer port) {
        return String.format("%s://%s:%d", protocol.toLowerCase(), AgentURL.bracketAnIvp6Host(host), port);
    }

    public static final String getAgentURLShortFormat(String protocol, String host, String port) {
        return AgentURL.getAgentURLShortFormat(protocol, host, Integer.valueOf(port));
    }

    protected static boolean isIpv6(String url) {
        int x0 = url.indexOf(91);
        return x0 >= 0 && url.indexOf(93) > x0;
    }

    private static String bracketAnIvp6Host(String host) {
        if (host.indexOf(58) != -1 && !host.startsWith("[") && !host.endsWith("]")) {
            host = String.format("[%s]", host);
        }
        return host;
    }

    public AgentURL(String agentURL) throws MalformedURLException {
        this.parseURL(agentURL);
        this.uRLShortFormat = AgentURL.getAgentURLShortFormat(this.getProtocol(), this.getHost(), this.getPort());
        this.uRLLongFormat = AgentURL.getAgentURLLongFormat(this.getProtocol(), this.getHost(), this.getPort());
        this.jmxServiceURL = new JMXServiceURL(this.getURLLongFormat());
    }

    public AgentURL(String protocol, String host, String port) throws MalformedURLException {
        this(AgentURL.getAgentURLShortFormat(protocol, host, port));
    }

    public String getHost() {
        return this.host;
    }

    public JMXServiceURL getJmxServiceURL() {
        return this.jmxServiceURL;
    }

    public String getPort() {
        return this.port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getURLLongFormat() {
        return this.uRLLongFormat;
    }

    public String getURLShortFormat() {
        return this.uRLShortFormat;
    }

    public String toString() {
        return this.getURLLongFormat();
    }

    private void parseFullURL(String url) throws MalformedURLException {
        JMXServiceURL jmxURL = new JMXServiceURL(url);
        this.protocol = jmxURL.getProtocol();
        if (this.protocol == null || this.protocol.trim().equals("")) {
            throw new MalformedURLException("Invalid agent long URL: protocol is not specified. Agent long URL syntax: service:jmx:<protocol>:///jndi/<protocol>://<host>:<port>/agent");
        }
        this.protocol = this.protocol.trim().toLowerCase();
        if ("rmi".indexOf(this.protocol) < 0) {
            throw new MalformedURLException("Unsupported protocol: " + this.protocol + ". Currently supported protocols are " + "rmi");
        }
        int idx = url.lastIndexOf("/agent");
        if (idx < 0) {
            throw new MalformedURLException("Invalid long URL: It must end with /agent. Agent long URL syntax: service:jmx:<protocol>:///jndi/<protocol>://<host>:<port>/agent");
        }
        int idx3 = url.lastIndexOf("://");
        if (idx3 < 0) {
            throw new MalformedURLException("Invalid long URL: Host not specified. Agent long URL syntax: service:jmx:<protocol>:///jndi/<protocol>://<host>:<port>/agent");
        }
        this.setHostPort(url.substring(idx3 + 3, idx));
        if (this.host == null || this.host.trim().equals("")) {
            throw new MalformedURLException("Invalid long URL: Host not specified. Agent long URL syntax: service:jmx:<protocol>:///jndi/<protocol>://<host>:<port>/agent");
        }
    }

    private void parseShortURL(String url) throws MalformedURLException {
        int idx = url.indexOf("://");
        if (idx <= 0) {
            this.protocol = "rmi";
            this.setHostPort(url);
        } else {
            this.protocol = url.substring(0, idx).toLowerCase();
            if ("rmi".indexOf(this.protocol) < 0) {
                throw new MalformedURLException("Unsupported protocol: " + this.protocol + ". Currently supported protocols are " + "rmi");
            }
            this.setHostPort(url.substring(idx + 3));
            if (this.host == null || this.host.trim().equals("")) {
                throw new MalformedURLException("Invalid short URL: Host not specified. Agent short URL syntax: [<protocol>://]<host>[:<port>]");
            }
        }
    }

    private void parseURL(String url) throws MalformedURLException {
        if (url == null) {
            return;
        }
        if ((url = url.trim()).toLowerCase().startsWith(FULL_URL_PREFIX)) {
            this.parseFullURL(url);
            this.uRLLongFormat = url;
        } else {
            this.parseShortURL(url);
            this.uRLLongFormat = AgentURL.getAgentURLLongFormat(this.getProtocol(), this.getHost(), this.getPort());
        }
    }

    private void setHostPort(String HostPort) {
        if (AgentURL.isIpv6(HostPort)) {
            int idx = HostPort.lastIndexOf("]:");
            if (idx < 0) {
                this.host = HostPort;
                this.setPortAsDefault();
            } else {
                this.host = HostPort.substring(0, idx + 1);
                this.port = HostPort.substring(idx + 2);
            }
        } else {
            int idx = HostPort.indexOf(":");
            if (idx < 0) {
                this.host = HostPort;
                this.setPortAsDefault();
            } else {
                this.host = HostPort.substring(0, idx);
                this.port = HostPort.substring(idx + 1);
            }
        }
        if (this.host.startsWith("//")) {
            this.host = this.host.substring(2);
        }
        try {
            Integer.parseInt(this.port);
        }
        catch (NumberFormatException e) {
            this.setPortAsDefault();
        }
    }

    private void setPortAsDefault() {
        if (this.protocol.equalsIgnoreCase("rmi")) {
            this.port = DEFAULT_RMI_PORT;
        }
    }
}

