/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua;

import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;

public class PluginInfo
implements Serializable {
    static final long serialVersionUID = -1863596380656426480L;
    private final String name;
    private final String id;
    private final String version;
    private final int instanceNumber;
    private final String providerName;
    private boolean loaded = false;
    private boolean enabled = true;
    private boolean registerOnStartup = true;
    private final String pluginHome;
    private final Map<String, Object> discoveryProperties = new TreeMap<String, Object>();

    public PluginInfo(String name, String id, String version, int instanceNumber, String providerName, boolean loaded, boolean enabled, boolean registerOnStartup, String pluginHome, Map<String, Object> discoveryProperties) {
        this.name = name;
        this.id = id;
        this.version = version;
        this.instanceNumber = instanceNumber;
        this.providerName = providerName;
        this.loaded = loaded;
        this.enabled = enabled;
        this.registerOnStartup = registerOnStartup;
        this.pluginHome = pluginHome;
        this.discoveryProperties.putAll(discoveryProperties);
    }

    public Map<String, Object> getDiscoveryProperties() {
        return this.discoveryProperties;
    }

    public Object getDiscoveryProperty(String key) {
        Object value = null;
        if (this.discoveryProperties != null) {
            value = this.discoveryProperties.get(key);
        }
        return value;
    }

    public String getId() {
        return this.id;
    }

    public int getInstanceNumber() {
        return this.instanceNumber;
    }

    public String getInstanceNumberAsString() {
        return new Integer(this.instanceNumber).toString();
    }

    public String getName() {
        return this.name;
    }

    public String getPluginHome() {
        return this.pluginHome;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isRegisterOnStartup() {
        return this.registerOnStartup;
    }

    public String toString() {
        String s = "id=" + this.id + "&version=" + this.version + "&instance=" + this.instanceNumber;
        return s;
    }

    protected void finalize() throws Throwable {
        if (this.discoveryProperties != null) {
            this.discoveryProperties.clear();
        }
        super.finalize();
    }
}

