/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua;

import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentConnectionFactory;
import com.sybase.ua.AgentInfo;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class UDPFilteredDiscoveryThread
extends Thread {
    private final List<AgentInfo> originalAgentInfoList;
    private List<AgentInfo> finalAgentInfoList;
    private final long timeout;
    private final Object monitor;
    private static final Log log = LogFactory.getLog(UDPFilteredDiscoveryThread.class);

    public UDPFilteredDiscoveryThread(List<AgentInfo> originalAgentInfoList, long timeout) {
        this.originalAgentInfoList = originalAgentInfoList;
        this.timeout = timeout;
        this.monitor = new Object();
    }

    public List<AgentInfo> getFinalAgentInfoList() {
        return this.finalAgentInfoList;
    }

    public Object getMonitor() {
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.finalAgentInfoList = new ArrayList<AgentInfo>(this.originalAgentInfoList.size());
        for (AgentInfo agentInfo : this.originalAgentInfoList) {
            AgentConnection agentConn = null;
            try {
                agentConn = AgentConnectionFactory.createAgentConnection(agentInfo);
                agentConn.setClientConnectionTimeout(this.timeout);
                agentConn.connect();
                AgentInfo completeAgentInfo = agentConn.getAgentInfo();
                this.finalAgentInfoList.add(completeAgentInfo);
                agentConn.disconnect();
            }
            catch (Exception e) {
                log.debug((Object)e.getMessage());
            }
            finally {
                if (agentConn == null) continue;
                try {
                    agentConn.disconnect();
                }
                catch (Exception e) {}
            }
        }
        log.debug((Object)"Notifying all waiting threads...");
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }
}

