/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.config;

import com.sybase.ua.security.ac.ARL;
import com.sybase.ua.util.FileUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ARLWriter {
    public static final String DEFAULT_BACKUP_EXTENSION = "bak";
    private final ARL arl;
    private final File arlXml;
    private static final Log log = LogFactory.getLog(ARLWriter.class);

    public ARLWriter(ARL arl, File arlXml) {
        this.arl = arl;
        this.arlXml = arlXml;
    }

    public String getArlAsXML() throws IOException {
        String xml = "";
        if (this.arl != null) {
            xml = this.arl.toXML();
        }
        return xml;
    }

    public void saveConfig() throws IOException {
        this.saveConfig(DEFAULT_BACKUP_EXTENSION);
    }

    public void saveConfig(String backupExtension) throws IOException {
        FileUtil.versionedBackup(this.arlXml, backupExtension);
        log.debug((Object)("ARL XML successfuly backed up: " + this.arlXml.getAbsolutePath()));
        String xmlString = this.getArlAsXML();
        try {
            FileUtil.writeFile(xmlString, this.arlXml, false);
            log.debug((Object)("Updated ARL XML: " + this.arlXml.getAbsolutePath()));
        }
        catch (IOException e) {
            if (e.toString().toLowerCase().indexOf("permission denied") >= 0) {
                log.warn((Object)("Unable to write to the read-only ARL XML file: " + this.arlXml.getAbsolutePath()));
            }
            log.error((Object)e.toString());
        }
    }
}

