/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.config;

import com.sybase.ua.config.AgentConfig;
import com.sybase.ua.util.FileUtil;
import com.sybase.ua.util.jdom.JDomUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class AgentConfigWriter {
    private final AgentConfig agentConfig;
    private final File serviceHome;
    private static final Log log = LogFactory.getLog(AgentConfigWriter.class);

    public AgentConfigWriter(AgentConfig agentConfig, File serviceHome) {
        this.agentConfig = agentConfig;
        this.serviceHome = serviceHome;
    }

    public String getConfigAsXML() throws IOException {
        Document doc = new Document();
        Element root = new Element("agent-config");
        doc.addContent((Content)root);
        String xmlVersion = this.agentConfig.getXmlVersion();
        root.setAttribute("version", xmlVersion);
        String xml = JDomUtil.toString(doc, "ISO-8859-1");
        return xml;
    }

    public void saveConfig(String backupExtension) throws IOException {
        File configDir = new File(this.serviceHome, "conf");
        File configFile = new File(configDir, "agent-config.xml");
        FileUtil.versionedBackup(configFile, backupExtension);
        log.debug((Object)("Config file successfuly backed up: " + configFile.getAbsolutePath()));
        String xmlString = this.getConfigAsXML();
        try {
            FileUtil.writeFile(xmlString, configFile, false);
            log.debug((Object)("Saved agent config: " + configFile.getAbsolutePath()));
        }
        catch (IOException e) {
            if (e.toString().toLowerCase().indexOf("permission denied") >= 0) {
                log.warn((Object)("Unable to write to the read-only config file: " + configFile.getAbsolutePath()));
            }
            log.error((Object)e.toString());
        }
    }
}

