/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.config;

import com.sybase.ua.config.ArchiveConfig;
import com.sybase.ua.config.DependencyConfig;
import com.sybase.ua.config.LoggerConfig;
import com.sybase.ua.config.PropertiesConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AgentPluginConfig
implements Serializable {
    static final long serialVersionUID = -37591155100296753L;
    public static final int DEFAULT_AUTO_UNREGISTER_GRACE_PERIOD = 5;
    private String name;
    private String className;
    private String version;
    private String id;
    private String providerName;
    private PropertiesConfig properties;
    private boolean registerOnStartup = true;
    private boolean enabled = true;
    private String arlConfig = "arl.xml";
    private String mbeanType = "Standard MBean";
    private String mbeanDescriptor;
    private List<DependencyConfig> dependencies = new ArrayList<DependencyConfig>(1);
    private boolean autoUnregister = false;
    private int autoUnregisterGracePeriod = 5;
    private boolean autoRegister = true;
    private boolean offline = false;
    private Map<String, LoggerConfig> loggers = new TreeMap<String, LoggerConfig>();
    private List<String> externalArchives = new ArrayList<String>(1);

    public void addArchive(ArchiveConfig archiveConfig) {
        if (!this.externalArchives.contains(archiveConfig.getPath())) {
            this.externalArchives.add(archiveConfig.getPath());
        }
    }

    public void addDependency(DependencyConfig dependency) {
        this.addDependency(dependency.getType(), dependency.getId(), dependency.getVersion(), dependency.getDirectory());
    }

    public void addDependency(String type, String id, String version) {
        this.addDependency(type, id, version, null);
    }

    public void addDependency(String type, String id, String version, String directory) {
        DependencyConfig dep = this.getDependency(type, id, version, directory);
        if (dep == null) {
            dep = new DependencyConfig();
            dep.setType(type);
            dep.setId(id);
            dep.setVersion(version);
            dep.setDirectory(directory);
            this.dependencies.add(dep);
        }
    }

    public void addLogger(LoggerConfig loggerConfig) {
        this.loggers.put(loggerConfig.getName(), loggerConfig);
    }

    public String getArlConfig() {
        return this.arlConfig;
    }

    public int getAutoUnregisterGracePeriod() {
        return this.autoUnregisterGracePeriod;
    }

    public String getClassName() {
        return this.className;
    }

    public List<DependencyConfig> getDependencies() {
        return this.dependencies;
    }

    public DependencyConfig getDependency(String type, String id, String version, String directory) {
        DependencyConfig result = null;
        for (DependencyConfig dep : this.dependencies) {
            if (!dep.getType().equalsIgnoreCase(type) || !dep.getId().equals(id) || !dep.getVersion().equals(version) || (dep.getDirectory() != null || directory != null) && (dep.getDirectory() == null || directory == null || !dep.getDirectory().equals(directory))) continue;
            result = dep;
            break;
        }
        return result;
    }

    public List<String> getExternalArchives() {
        return this.externalArchives;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, LoggerConfig> getLoggers() {
        return this.loggers;
    }

    public String getMbeanDescriptor() {
        return this.mbeanDescriptor;
    }

    public String getMbeanType() {
        return this.mbeanType;
    }

    public String getName() {
        return this.name;
    }

    public PropertiesConfig getProperties() {
        return this.properties;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isAutoRegister() {
        return this.autoRegister;
    }

    public boolean isAutoUnregister() {
        return this.autoUnregister;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public boolean isRegisterOnStartup() {
        return this.registerOnStartup;
    }

    public void removeDependency(DependencyConfig dependency) {
        this.removeDependency(dependency.getType(), dependency.getId(), dependency.getVersion(), dependency.getDirectory());
    }

    public void removeDependency(String type, String id, String version, String directory) {
        DependencyConfig dep = this.getDependency(type, id, version, directory);
        if (dep != null) {
            this.dependencies.remove(dep);
        }
    }

    public void setArlConfig(String arlConfig) {
        this.arlConfig = arlConfig;
    }

    public void setAutoRegister(boolean autoRegister) {
        this.autoRegister = autoRegister;
    }

    public void setAutoUnregister(boolean autoUnregister) {
        this.autoUnregister = autoUnregister;
    }

    public void setAutoUnregisterGracePeriod(int autoUnregisterGracePeriod) {
        this.autoUnregisterGracePeriod = autoUnregisterGracePeriod;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setDependencies(List<DependencyConfig> dependencies) {
        this.dependencies = dependencies;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setExternalArchives(List<String> externalArchives) {
        this.externalArchives = externalArchives;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLoggers(Map<String, LoggerConfig> loggerMap) {
        this.loggers = loggerMap;
    }

    public void setMbeanDescriptor(String mbeanDescriptor) {
        this.mbeanDescriptor = mbeanDescriptor;
    }

    public void setMbeanType(String mbeanType) {
        this.mbeanType = mbeanType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOffline(boolean offline) {
        this.offline = offline;
    }

    public void setProperties(PropertiesConfig properties) {
        this.properties = properties;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public void setRegisterOnStartup(boolean registerOnStartup) {
        this.registerOnStartup = registerOnStartup;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return new String(this.getId() + "_" + this.getVersion());
    }

    protected void finalize() throws Throwable {
        this.dependencies.clear();
        super.finalize();
    }
}

