/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.config;

import com.sybase.ua.config.AgentPluginConfig;
import com.sybase.ua.config.AgentPluginConfigRuleSet;
import com.sybase.ua.util.DigesterUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.RuleSet;

public class AgentPluginConfigReader {
    public static AgentPluginConfig read(File configXml) throws Exception {
        AgentPluginConfig config = new AgentPluginConfig();
        if (!configXml.exists()) {
            throw new IOException("Configuration file does not exist: " + configXml.getAbsolutePath());
        }
        if (!configXml.isFile()) {
            throw new IOException(configXml.getAbsolutePath() + " is not a file.");
        }
        if (!configXml.canRead()) {
            throw new IOException("Do not have read access to file " + configXml.getAbsolutePath());
        }
        Digester digester = new Digester();
        digester.addRuleSet((RuleSet)new AgentPluginConfigRuleSet());
        try {
            config = (AgentPluginConfig)DigesterUtil.parse(digester, configXml);
        }
        catch (Throwable t) {
            throw new Exception("Failed to parse XML: " + configXml.getAbsolutePath(), t);
        }
        finally {
            digester.clear();
        }
        return config;
    }
}

