/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.config;

import com.sybase.ua.config.AgentPluginConfig;
import com.sybase.ua.config.AgentServiceConfigWriter;
import com.sybase.ua.config.DependencyConfig;
import com.sybase.ua.config.LoggerConfig;
import com.sybase.ua.util.FileUtil;
import com.sybase.ua.util.jdom.JDomUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class AgentPluginConfigWriter {
    private final AgentPluginConfig pluginConfig;
    private final File pluginHome;

    public AgentPluginConfigWriter(AgentPluginConfig pluginConfig, File pluginHome) {
        this.pluginConfig = pluginConfig;
        this.pluginHome = pluginHome;
    }

    public String getConfigAsXML() throws IOException {
        List<String> externalArchives;
        Element archivesEle;
        Map<String, LoggerConfig> loggers;
        Element loggersEle;
        Document doc = new Document();
        Element root = new Element("agent-plugin");
        doc.addContent((Content)root);
        root.setAttribute("name", this.pluginConfig.getName());
        root.setAttribute("version", this.pluginConfig.getVersion());
        root.setAttribute("id", this.pluginConfig.getId());
        root.setAttribute("class", this.pluginConfig.getClassName());
        root.setAttribute("provider-name", this.pluginConfig.getProviderName());
        root.setAttribute("register-on-startup", this.pluginConfig.isRegisterOnStartup() ? "true" : "false");
        root.setAttribute("enabled", this.pluginConfig.isEnabled() ? "true" : "false");
        if (this.pluginConfig.getMbeanType() != null) {
            root.setAttribute("mbean-type", this.pluginConfig.getMbeanType());
        }
        if (this.pluginConfig.getMbeanDescriptor() != null) {
            root.setAttribute("mbean-descriptor", this.pluginConfig.getMbeanDescriptor());
        }
        if (this.pluginConfig.getArlConfig() != null) {
            root.setAttribute("arl-config", this.pluginConfig.getArlConfig());
        }
        root.setAttribute("auto-register", this.pluginConfig.isAutoRegister() ? "true" : "false");
        root.setAttribute("auto-unregister", this.pluginConfig.isAutoUnregister() ? "true" : "false");
        root.setAttribute("auto-unregister-grace-period", Integer.valueOf(this.pluginConfig.getAutoUnregisterGracePeriod()).toString());
        root.setAttribute("offline", this.pluginConfig.isOffline() ? "true" : "false");
        Element dependenciesEle = new Element("dependencies");
        root.addContent((Content)dependenciesEle);
        List<DependencyConfig> dependencies = this.pluginConfig.getDependencies();
        if (dependencies != null) {
            for (DependencyConfig dependencyConfig : dependencies) {
                Element dependencyEle = new Element("dependency");
                dependenciesEle.addContent((Content)dependencyEle);
                String type = dependencyConfig.getType();
                String id = dependencyConfig.getId();
                String ver = dependencyConfig.getVersion();
                String dir = dependencyConfig.getDirectory();
                dependencyEle.setAttribute("type", type);
                dependencyEle.setAttribute("id", id);
                dependencyEle.setAttribute("version", ver);
                if (dir == null || dir.trim().equals("")) continue;
                dependencyEle.setAttribute("directory", dir);
            }
        }
        Element properties = new Element("properties");
        root.addContent((Content)properties);
        Map<String, Object> persistentProps = this.pluginConfig.getProperties().getProperties();
        if (persistentProps != null && !persistentProps.isEmpty()) {
            for (Map.Entry<String, Object> prop : persistentProps.entrySet()) {
                Object value = prop.getValue();
                if (value == null) continue;
                String stringValue = null;
                stringValue = value.getClass().getName().equals("[C") ? new String((char[])value) : value.toString();
                Element setProp = new Element("set-property");
                properties.addContent((Content)setProp);
                setProp.setAttribute("property", prop.getKey());
                setProp.setAttribute("value", stringValue);
            }
        }
        if (this.pluginConfig != null && (loggersEle = AgentServiceConfigWriter.createLoggersDom(loggers = this.pluginConfig.getLoggers())) != null) {
            root.addContent((Content)loggersEle);
        }
        if (this.pluginConfig != null && (archivesEle = this.createExternalArchivesDom(externalArchives = this.pluginConfig.getExternalArchives())) != null) {
            root.addContent((Content)archivesEle);
        }
        String xml = JDomUtil.toString(doc, "ISO-8859-1");
        return xml;
    }

    public void saveConfig(File configFile) throws IOException {
        FileUtil.writeFile(this.getConfigAsXML(), configFile, false);
    }

    public void saveConfig(String backupExtension) throws IOException {
        File configFile = new File(this.pluginHome, "agent-plugin.xml");
        FileUtil.versionedBackup(configFile, backupExtension);
        String xmlString = this.getConfigAsXML();
        FileUtil.writeFile(xmlString, configFile, false);
    }

    private Element createExternalArchivesDom(List<String> externalArchivesList) {
        if (externalArchivesList == null || externalArchivesList.isEmpty()) {
            return null;
        }
        Element archivesEle = new Element("archives");
        for (String archive : externalArchivesList) {
            Element archiveEle = new Element("archive");
            archiveEle.setAttribute("path", archive);
            archivesEle.addContent((Content)archiveEle);
        }
        return archivesEle;
    }
}

