/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.config;

import com.sybase.ua.config.AdaptorConfig;
import com.sybase.ua.config.ArchiveConfig;
import com.sybase.ua.config.DependencyConfig;
import com.sybase.ua.config.LoggerConfig;
import com.sybase.ua.config.PropertiesConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AgentServiceConfig
implements Serializable {
    static final long serialVersionUID = -2829202211583958526L;
    private String name;
    private String version;
    private String id;
    private String providerName;
    private boolean registerOnStartup = true;
    private String className;
    private String mbeanType = "Standard MBean";
    private String mbeanDescriptor = "mbean-descriptor.xml";
    private PropertiesConfig properties = new PropertiesConfig();
    private String arlConfig = "arl.xml";
    private List<AdaptorConfig> adaptors = new ArrayList<AdaptorConfig>(1);
    private List<DependencyConfig> dependencies = new ArrayList<DependencyConfig>(1);
    private String serviceDirectory;
    private Map<String, LoggerConfig> loggers = new TreeMap<String, LoggerConfig>();
    private List<String> externalArchives = new ArrayList<String>(1);

    public void addAdaptor(AdaptorConfig adaptor) {
        this.adaptors.add(adaptor);
    }

    public void addArchive(ArchiveConfig archiveConfig) {
        if (!this.externalArchives.contains(archiveConfig.getPath())) {
            this.externalArchives.add(archiveConfig.getPath());
        }
    }

    public void addDependency(DependencyConfig dependency) {
        this.dependencies.add(dependency);
    }

    public void addLogger(LoggerConfig loggerConfig) {
        this.loggers.put(loggerConfig.getName(), loggerConfig);
    }

    public void addProperty(String key, String value) {
        this.properties.addProperty(key, value);
    }

    public List<AdaptorConfig> getAdaptors() {
        return this.adaptors;
    }

    public String getArlConfig() {
        return this.arlConfig;
    }

    public String getClassName() {
        return this.className;
    }

    public List<DependencyConfig> getDependencies() {
        return this.dependencies;
    }

    public List<String> getExternalArchives() {
        return this.externalArchives;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, LoggerConfig> getLoggers() {
        return this.loggers;
    }

    public String getMbeanDescriptor() {
        return this.mbeanDescriptor;
    }

    public String getMbeanType() {
        return this.mbeanType;
    }

    public String getName() {
        return this.name;
    }

    public PropertiesConfig getProperties() {
        return this.properties;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getServiceDirectory() {
        return this.serviceDirectory;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isRegisterOnStartup() {
        return this.registerOnStartup;
    }

    public void removeDependency(DependencyConfig dependency) {
        this.dependencies.remove(dependency);
    }

    public void setAdaptors(List<AdaptorConfig> adaptors) {
        this.adaptors = adaptors;
    }

    public void setArlConfig(String arlConfig) {
        this.arlConfig = arlConfig;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setDependencies(List<DependencyConfig> dependencies) {
        this.dependencies = dependencies;
    }

    public void setExternalArchives(List<String> externalArchives) {
        this.externalArchives = externalArchives;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLoggers(Map<String, LoggerConfig> loggerMap) {
        this.loggers = loggerMap;
    }

    public void setMbeanDescriptor(String mbeanDescriptor) {
        this.mbeanDescriptor = mbeanDescriptor;
    }

    public void setMbeanType(String mbeanType) {
        this.mbeanType = mbeanType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(PropertiesConfig properties) {
        this.properties = properties;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public void setRegisterOnStartup(boolean registerOnStartup) {
        this.registerOnStartup = registerOnStartup;
    }

    public void setServiceDirectory(String serviceDirectory) {
        this.serviceDirectory = serviceDirectory;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toString() {
        return new String(this.getId() + "_" + this.getVersion());
    }
}

