/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.config;

import com.sybase.ua.config.AgentServiceConfig;
import com.sybase.ua.config.AgentServiceConfigRuleSet;
import com.sybase.ua.util.DigesterUtil;
import java.io.File;
import java.io.IOException;
import org.apache.commons.digester.Digester;

public class AgentServiceConfigReader {
    public static AgentServiceConfig read(File configXml) throws Exception {
        AgentServiceConfig config = new AgentServiceConfig();
        if (!configXml.exists()) {
            throw new IOException("Configuration file does not exist: " + configXml.getAbsolutePath());
        }
        if (!configXml.isFile()) {
            throw new IOException(configXml.getAbsolutePath() + " is not a file.");
        }
        if (!configXml.canRead()) {
            throw new IOException("Do not have read access to file " + configXml.getAbsolutePath());
        }
        Digester configDigester = null;
        File dtd = new File(configXml.getParentFile(), "agent-config.dtd");
        String dtdPublicId = "-//simon.sybase.com//DTD UnifiedAgent Configuration 1.0//EN";
        try {
            configDigester = DigesterUtil.initDigester(dtd, "-//simon.sybase.com//DTD UnifiedAgent Configuration 1.0//EN", new AgentServiceConfigRuleSet());
        }
        catch (Exception e) {
            throw new Exception("Failed to initialize digester: " + dtd.getAbsolutePath(), e);
        }
        try {
            config = (AgentServiceConfig)DigesterUtil.parse(configDigester, configXml);
        }
        catch (Throwable t) {
            throw new Exception("Failed to parse XML: " + configXml.getAbsolutePath(), t);
        }
        finally {
            configDigester.clear();
        }
        return config;
    }
}

