/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.config;

import com.sybase.ua.config.AdaptorConfig;
import com.sybase.ua.config.AgentServiceConfig;
import com.sybase.ua.config.AppenderConfig;
import com.sybase.ua.config.DependencyConfig;
import com.sybase.ua.config.LoggerConfig;
import com.sybase.ua.config.PropertyConfig;
import com.sybase.ua.util.FileUtil;
import com.sybase.ua.util.jdom.JDomUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class AgentServiceConfigWriter {
    private final AgentServiceConfig serviceConfig;
    private final File serviceHome;

    public static Element createLoggersDom(Map<String, LoggerConfig> loggers) {
        if (loggers == null || loggers.isEmpty()) {
            return null;
        }
        Element loggersEle = new Element("loggers");
        for (Map.Entry<String, LoggerConfig> entry : loggers.entrySet()) {
            LoggerConfig loggerConfig = entry.getValue();
            String loggerName = loggerConfig.getName();
            String loggerLevel = loggerConfig.getLevel();
            if (loggerName == null) continue;
            Element loggerEle = new Element("logger");
            loggerEle.setAttribute("name", loggerName);
            if (loggerLevel != null) {
                loggerEle.setAttribute("level", loggerLevel);
            } else if (!loggerConfig.isAdditivity()) {
                loggerEle.setAttribute("level", "OFF");
            }
            loggerEle.setAttribute("additivity", Boolean.toString(loggerConfig.isAdditivity()));
            loggersEle.addContent((Content)loggerEle);
            List<AppenderConfig> appenders = loggerConfig.getAppenders();
            if (appenders == null || appenders.isEmpty()) continue;
            for (AppenderConfig appender : appenders) {
                String classname = appender.getClassname();
                Element appenderEle = new Element("appender");
                if (classname != null) {
                    appenderEle.setAttribute("class", classname);
                }
                loggerEle.addContent((Content)appenderEle);
                List<PropertyConfig> props = appender.getProperties();
                for (PropertyConfig prop : props) {
                    String propName = prop.getName();
                    String propValue = prop.getValue();
                    String propType = prop.getType();
                    Element propEle = new Element("set-property");
                    appenderEle.addContent((Content)propEle);
                    if (propName != null) {
                        propEle.setAttribute("property", propName);
                    }
                    if (propValue != null) {
                        propEle.setAttribute("value", propValue);
                    }
                    if (propType == null) continue;
                    propEle.setAttribute("type", propType);
                }
            }
        }
        return loggersEle;
    }

    public AgentServiceConfigWriter(AgentServiceConfig serviceConfig, File serviceHome) {
        this.serviceConfig = serviceConfig;
        this.serviceHome = serviceHome;
    }

    public String getConfigAsXML() throws IOException {
        List<String> externalArchives;
        Element archivesEle;
        Map<String, LoggerConfig> loggers;
        Element loggersEle;
        Document doc = new Document();
        Element root = new Element("service-config");
        doc.addContent((Content)root);
        root.setAttribute("id", this.serviceConfig.getId());
        String version = this.serviceConfig.getVersion();
        if (version == null || version.trim().equals("")) {
            version = "1.5.0";
        }
        root.setAttribute("version", version);
        root.setAttribute("name", this.serviceConfig.getName());
        root.setAttribute("class", this.serviceConfig.getClassName());
        String provider = this.serviceConfig.getProviderName();
        if (provider == null || provider.trim().equals("")) {
            provider = "Sybase, Inc.";
        }
        root.setAttribute("provider-name", provider);
        String registerOnStartupStr = new Boolean(this.serviceConfig.isRegisterOnStartup()).toString();
        root.setAttribute("register-on-startup", registerOnStartupStr);
        root.setAttribute("mbean-type", this.serviceConfig.getMbeanType());
        if (this.serviceConfig.getMbeanDescriptor() != null) {
            root.setAttribute("mbean-descriptor", this.serviceConfig.getMbeanDescriptor());
        }
        if (this.serviceConfig.getArlConfig() != null) {
            root.setAttribute("arl-config", this.serviceConfig.getArlConfig());
        }
        Element dependenciesEle = new Element("dependencies");
        root.addContent((Content)dependenciesEle);
        List<DependencyConfig> dependencies = this.serviceConfig.getDependencies();
        if (dependencies != null) {
            for (DependencyConfig dependencyConfig : dependencies) {
                Element dependencyEle = new Element("dependency");
                dependenciesEle.addContent((Content)dependencyEle);
                String type = dependencyConfig.getType();
                String id = dependencyConfig.getId();
                String ver = dependencyConfig.getVersion();
                boolean autoUnregisterWhenNotReferenced = dependencyConfig.isAutoUnregisterWhenNotReferenced();
                int gracePeriod = dependencyConfig.getAutoUnregisterGracePeriod();
                dependencyEle.setAttribute("type", type);
                dependencyEle.setAttribute("id", id);
                dependencyEle.setAttribute("version", ver);
                dependencyEle.setAttribute("auto-unregister-when-not-referenced", new Boolean(autoUnregisterWhenNotReferenced).toString());
                dependencyEle.setAttribute("auto-unregister-grace-period", new Integer(gracePeriod).toString());
            }
        }
        Element propertiesEle = new Element("properties");
        root.addContent((Content)propertiesEle);
        for (String prop : this.serviceConfig.getProperties().getProperties().keySet()) {
            Object value = this.serviceConfig.getProperties().getProperties().get(prop);
            if (value == null) continue;
            String stringValue = null;
            stringValue = value.getClass().getName().equals("[C") ? new String((char[])value) : value.toString();
            Element setPropEle = new Element("set-property");
            propertiesEle.addContent((Content)setPropEle);
            setPropEle.setAttribute("property", prop);
            setPropEle.setAttribute("value", stringValue);
        }
        List<AdaptorConfig> adaptorConfigs = this.serviceConfig.getAdaptors();
        if (adaptorConfigs != null && !adaptorConfigs.isEmpty()) {
            for (AdaptorConfig adaptorConfig : adaptorConfigs) {
                String adaptorid = adaptorConfig.getId();
                String classname = adaptorConfig.getClassname();
                Element adaptorEle = new Element("adaptor");
                adaptorEle.setAttribute("id", adaptorid);
                adaptorEle.setAttribute("class", classname);
                root.addContent((Content)adaptorEle);
                Properties adaptorProps = adaptorConfig.getProperties();
                Set<Object> adaptorPropKeys = adaptorProps.keySet();
                for (Object element : adaptorPropKeys) {
                    String propName = (String)element;
                    String propValue = (String)adaptorProps.get(propName);
                    Element setPropEle = new Element("set-property");
                    adaptorEle.addContent((Content)setPropEle);
                    setPropEle.setAttribute("property", propName);
                    setPropEle.setAttribute("value", propValue);
                }
            }
        }
        if (this.serviceConfig != null && (loggersEle = AgentServiceConfigWriter.createLoggersDom(loggers = this.serviceConfig.getLoggers())) != null) {
            root.addContent((Content)loggersEle);
        }
        if (this.serviceConfig != null && (archivesEle = this.createExternalArchivesDom(externalArchives = this.serviceConfig.getExternalArchives())) != null) {
            root.addContent((Content)archivesEle);
        }
        String xml = JDomUtil.toString(doc, "ISO-8859-1");
        return xml;
    }

    public void saveConfig(File configFile) throws IOException {
        FileUtil.writeFile(this.getConfigAsXML(), configFile, false);
    }

    public void saveConfig(String backupExtension) throws IOException {
        File configFile = new File(this.serviceHome, "service-config.xml");
        FileUtil.versionedBackup(configFile, backupExtension);
        String xmlString = this.getConfigAsXML();
        FileUtil.writeFile(xmlString, configFile, false);
    }

    private Element createExternalArchivesDom(List<String> externalArchivesList) {
        if (externalArchivesList == null || externalArchivesList.isEmpty()) {
            return null;
        }
        Element archivesEle = new Element("archives");
        for (String archive : externalArchivesList) {
            Element archiveEle = new Element("archive");
            archiveEle.setAttribute("path", archive);
            archivesEle.addContent((Content)archiveEle);
        }
        return archivesEle;
    }
}

