/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.config;

import com.sybase.ua.config.AgentServiceConfig;
import com.sybase.ua.config.AgentServiceConfigReader;
import com.sybase.ua.config.AgentServiceConfigWriter;
import com.sybase.ua.config.PropertiesConfig;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgentServicePropertyWriter {
    private final File serviceHome;
    private final String propKey;
    private final String propValue;
    private final String backupExtension = "bak";
    private static final Log log = LogFactory.getLog(AgentServicePropertyWriter.class);

    public static final void main(String[] args) {
        if (args.length < 3) {
            log.error((Object)"Usage: java AgentServicePropertyWriter <serviceHome> <propertyKey> <propertyValue>");
            return;
        }
        File serviceHome = new File(args[0]);
        String propKey = args[1];
        String propValue = args[2];
        AgentServicePropertyWriter propWriter = new AgentServicePropertyWriter(serviceHome, propKey, propValue);
        try {
            propWriter.update();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error((Object)e.toString(), (Throwable)e);
            }
            log.error((Object)e.toString());
        }
    }

    public AgentServicePropertyWriter(File serviceHome, String propKey, String propValue) {
        this.serviceHome = serviceHome;
        this.propKey = propKey;
        this.propValue = propValue;
    }

    public void update() throws Exception {
        File configXml = new File(this.serviceHome, "service-config.xml");
        AgentServiceConfig config = AgentServiceConfigReader.read(configXml);
        PropertiesConfig props = config.getProperties();
        props.addProperty(this.propKey, this.propValue);
        log.debug((Object)("Updated property " + this.propKey + ", new value: " + this.propValue));
        AgentServiceConfigWriter configWriter = new AgentServiceConfigWriter(config, configXml.getParentFile());
        configWriter.saveConfig("bak");
    }
}

