/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.config;

import com.sybase.ua.config.AgentPluginConfig;
import com.sybase.ua.config.AgentPluginConfigReader;
import com.sybase.ua.config.AgentPluginConfigWriter;
import com.sybase.ua.config.AgentServiceConfig;
import com.sybase.ua.config.AgentServiceConfigReader;
import com.sybase.ua.config.AgentServiceConfigWriter;
import com.sybase.ua.config.PropertiesConfig;
import java.io.File;

public class ConfigManager {
    public static void mergeAgentPluginXML(File oldConfigFile, File newConfigFile, File mergedConfigFile) {
        try {
            AgentPluginConfig oldConfig = AgentPluginConfigReader.read(oldConfigFile);
            AgentPluginConfig newConfig = AgentPluginConfigReader.read(newConfigFile);
            PropertiesConfig oldProps = oldConfig.getProperties();
            PropertiesConfig newProps = newConfig.getProperties();
            newProps.getProperties().putAll(oldProps.getProperties());
            newConfig.setRegisterOnStartup(oldConfig.isRegisterOnStartup());
            newConfig.setEnabled(oldConfig.isEnabled());
            newConfig.setOffline(oldConfig.isOffline());
            AgentPluginConfigWriter writer = new AgentPluginConfigWriter(newConfig, null);
            writer.saveConfig(mergedConfigFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Error merging agent configuration", e);
        }
    }

    public static void mergeServiceConfigXML(File oldConfigFile, File newConfigFile, File mergedConfigFile) {
        try {
            AgentServiceConfig oldConfig = AgentServiceConfigReader.read(oldConfigFile);
            AgentServiceConfig newConfig = AgentServiceConfigReader.read(newConfigFile);
            PropertiesConfig oldProps = oldConfig.getProperties();
            PropertiesConfig newProps = newConfig.getProperties();
            newProps.getProperties().putAll(oldProps.getProperties());
            newConfig.setRegisterOnStartup(oldConfig.isRegisterOnStartup());
            AgentServiceConfigWriter writer = new AgentServiceConfigWriter(newConfig, null);
            writer.saveConfig(mergedConfigFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Error merging service configuration", e);
        }
    }
}

