/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.connection;

import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.AgentInfo;
import com.sybase.ua.AgentURL;
import com.sybase.ua.AuthenticationException;
import com.sybase.ua.connection.ClientManagedSessionAgentConnection;
import com.sybase.ua.connection.ConnectionInfo;
import com.sybase.ua.connection.JmxConnectionException;
import com.sybase.ua.connection.ServerManagedSessionAgentConnection;
import com.sybase.ua.migration.MalformatVersionException;
import com.sybase.ua.migration.Version;
import java.rmi.RemoteException;
import javax.management.remote.JMXServiceURL;

public class AgentConnectionFactory {
    public static AgentConnection createAgentConnection(JMXServiceURL url) throws RemoteException {
        try {
            ConnectionInfo ci = ConnectionInfo.getConnectionInfoPrototype(url);
            return AgentConnectionFactory.createAgentConnection(ci.getAgentInfo());
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (JmxConnectionException jce) {
            throw new AgentConnectionException(jce.getCause());
        }
        catch (SecurityException se) {
            throw new AuthenticationException(se.getMessage());
        }
        catch (IllegalStateException ise) {
            throw new AgentConnectionException("Please check that the server is a valid SCC Agent", ise.getCause());
        }
        catch (Exception e) {
            throw new AgentConnectionException(e);
        }
    }

    public static AgentConnection createAgentConnection(AgentURL url) throws RemoteException {
        try {
            ConnectionInfo ci = ConnectionInfo.getConnectionInfoPrototype(url.getJmxServiceURL());
            return AgentConnectionFactory.createAgentConnection(ci.getAgentInfo());
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (JmxConnectionException jce) {
            throw new AgentConnectionException(jce.getCause());
        }
        catch (SecurityException se) {
            throw new AuthenticationException(se.getMessage());
        }
        catch (IllegalStateException ise) {
            throw new AgentConnectionException("Please check that the server is a valid SCC Agent", ise.getCause());
        }
        catch (Exception e) {
            throw new AgentConnectionException(e);
        }
    }

    public static AgentConnection createAgentConnection(AgentInfo agentInfo) throws RemoteException {
        if (agentInfo == null) {
            throw new IllegalArgumentException("AgentInfo must be provided");
        }
        try {
            String versionString = agentInfo.getVersion();
            Version version = null;
            Version cmpVersion = null;
            try {
                version = Version.createVersion(versionString);
                cmpVersion = Version.createVersion("3.1.1");
            }
            catch (MalformatVersionException e) {
                throw new IllegalStateException(e.getMessage());
            }
            if (version.compare(cmpVersion) >= 0) {
                return new ServerManagedSessionAgentConnection(agentInfo.getConnectionURL());
            }
            return new ClientManagedSessionAgentConnection(agentInfo.getConnectionURL());
        }
        catch (Exception re) {
            AgentConnectionException ace = new AgentConnectionException("Connection failed", re);
            throw ace;
        }
    }

    private AgentConnectionFactory() {
    }
}

