/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.connection;

import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentConnectionException;
import com.sybase.ua.AgentConnectionFactory;
import com.sybase.ua.AgentInfo;
import com.sybase.ua.AgentURL;
import com.sybase.ua.AuthenticationException;
import com.sybase.ua.AuthorizationException;
import com.sybase.ua.ConnectionListener;
import com.sybase.ua.InvalidAgentURLException;
import com.sybase.ua.JMXException;
import com.sybase.ua.LoginModuleNotFoundException;
import com.sybase.ua.PluginInfo;
import com.sybase.ua.ServiceInfo;
import com.sybase.ua.connection.AgentConnectionListener;
import com.sybase.ua.connection.AgentConnectionListenerImpl;
import com.sybase.ua.connection.ConnectionCleanupHook;
import com.sybase.ua.connection.ConnectionWorkingThread;
import com.sybase.ua.migration.MalformatVersionException;
import com.sybase.ua.migration.Version;
import com.sybase.ua.plugin.AgentPluginException;
import com.sybase.ua.security.Pre30ResourceURL;
import com.sybase.ua.security.ResourceURL;
import com.sybase.ua.security.crypto.SecureObject;
import com.sybase.ua.services.security.tool.CipherTool;
import com.sybase.ua.util.AgentClientUtil;
import com.sybase.ua.util.ReflectionUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgentConnectionImpl
implements AgentConnection {
    public static final String RMI_SERVICE_ID = "RMIService";
    private static Log log = LogFactory.getLog(AgentConnection.class);
    private AgentURL agentURL;
    private boolean connected = false;
    private String sessionID;
    private AgentInfo agentInfo;
    protected JMXConnector jmxConn;
    private String username;
    protected long serverTimeDiff;
    protected long timeCreated;
    protected long lastActivityTime;
    private final AgentConnectionListener connectionListenerHook;
    private ConnectionCleanupHook connectionCleanupHook = null;
    private boolean timedOut = false;
    private boolean secureConnection = false;
    private String encryptionAlgorithm = "DES";
    private String cipherProviderClass = "com.sun.crypto.provider.SunJCE";
    private static final ResourceURL[] PRIMORDIAL_RESOURCES = new ResourceURL[]{ResourceURL.createServiceAttributeResourceURL("Agent", "started"), ResourceURL.createServiceAttributeResourceURL("Agent", "loaded"), ResourceURL.createServiceAttributeResourceURL("BootstrapService", "started"), ResourceURL.createServiceAttributeResourceURL("SecurityService", "started"), ResourceURL.createServiceAttributeResourceURL("SecurityService", "inited"), ResourceURL.createServiceOperationResourceURL("SecurityService", "hasAccess", "java.lang.String,java.lang.String,java.lang.String"), ResourceURL.createServiceOperationResourceURL("SecurityService", "hasRole", "java.lang.String,java.lang.String"), ResourceURL.createServiceOperationResourceURL("SecurityService", "createSession", "java.lang.String,[C,java.util.Map"), ResourceURL.createServiceOperationResourceURL("SecurityService", "createSession", "java.lang.String,com.sybase.ua.security.crypto.SecureObject,java.util.Map"), ResourceURL.createServiceOperationResourceURL("SecurityService", "createSession", "[C,[C,java.util.Map"), ResourceURL.createServiceOperationResourceURL("SecurityService", "login", "java.lang.String,java.lang.String,[C"), ResourceURL.createServiceOperationResourceURL("SecurityService", "login", "java.lang.String,java.lang.String,com.sybase.ua.security.crypto.SecureObject"), ResourceURL.createServiceOperationResourceURL("SecurityService", "login", "java.lang.String,[C,[C"), ResourceURL.createServiceOperationResourceURL("SecurityService", "getUsername", "java.lang.String"), ResourceURL.createServiceAttributeResourceURL("SessionService", "started"), ResourceURL.createServiceAttributeResourceURL("SessionService", "inited"), ResourceURL.createServiceOperationResourceURL("SessionService", "createSession", "")};
    private long clientConnectionTimeout = 0L;
    private static final String INVALID_PLUGIN_OBJECT_NAME_FORMAT_MSG = "Complete plugin object name specification is invalid: {0}The plugin id specification format is: pluginId_pluginVersion_pluginInstance.";

    public AgentConnectionImpl(AgentURL agentURL) throws AgentConnectionException {
        this.agentURL = agentURL;
        this.connectionListenerHook = new AgentConnectionListenerImpl();
    }

    public AgentConnectionImpl(String agentURL) throws AgentConnectionException {
        try {
            this.agentURL = new AgentURL(agentURL);
        }
        catch (MalformedURLException e) {
            throw new AgentConnectionException(e.getMessage());
        }
        this.connectionListenerHook = new AgentConnectionListenerImpl();
    }

    public AgentConnectionImpl(String protocol, String host, int port) throws AgentConnectionException {
        this(protocol, host, new Integer(port).toString());
    }

    public AgentConnectionImpl(String protocol, String host, String port) throws AgentConnectionException {
        try {
            this.agentURL = new AgentURL(protocol, host, port);
        }
        catch (MalformedURLException e) {
            throw new AgentConnectionException(e.getMessage());
        }
        this.connectionListenerHook = new AgentConnectionListenerImpl();
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        if (this.connectionListenerHook != null) {
            try {
                if (!this.isServerVersionOlderThan("1.5.0")) {
                    AgentConnectionListenerImpl connectionListenerHookImpl = (AgentConnectionListenerImpl)this.connectionListenerHook;
                    connectionListenerHookImpl.addConnectionListener(listener);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void connect() throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException, InvalidAgentURLException {
        this.connect("anonymous", new String("").toCharArray());
    }

    @Override
    @Deprecated
    public void connect(char[] authorizationKey, char[] signature) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException, InvalidAgentURLException {
        this.connect(authorizationKey, signature, null);
    }

    @Override
    @Deprecated
    public void connect(char[] authorizationKey, char[] signature, Map<String, Object> jmxConnectorMap) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException, InvalidAgentURLException {
        if (this.isConnected()) {
            return;
        }
        if (this.agentURL == null) {
            throw new InvalidAgentURLException("Agent URL is null.");
        }
        JMXServiceURL jmxURL = this.agentURL.getJmxServiceURL();
        String protocol = jmxURL.getProtocol();
        if ("rmi".indexOf(protocol) < 0) {
            throw new InvalidAgentURLException("Unsupported protocol: " + protocol + ". Currently supported protocols are " + "rmi");
        }
        Map<String, Object> credentialMap = this.createCredentialMap(authorizationKey, signature);
        if (jmxConnectorMap == null) {
            jmxConnectorMap = new HashMap<String, Object>(1);
            jmxConnectorMap.put("jmx.remote.x.client.connection.check.period", new Long(0L));
        } else if (!jmxConnectorMap.containsKey("jmx.remote.x.client.connection.check.period")) {
            jmxConnectorMap.put("jmx.remote.x.client.connection.check.period", new Long(0L));
        }
        jmxConnectorMap.put("jmx.remote.credentials", credentialMap);
        try {
            this.jmxConn = JMXConnectorFactory.connect(jmxURL, jmxConnectorMap);
        }
        catch (IOException e) {
            throw new JMXException("Failed to connect to the agent server", "Failed to connect to " + this.getAgentURLAsString() + ". " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new AuthenticationException("Failed to connect to " + this.getAgentURLAsString() + ", probably because the agent is protected and requires credentials. " + e.getMessage());
        }
        this.createSession(authorizationKey, signature);
        this.setConnected(true);
        this.createAgentInfo();
    }

    @Override
    public void connect(long clientHeartbeatPeriod) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException, InvalidAgentURLException {
        HashMap<String, Object> jmxConnectorMap = new HashMap<String, Object>(1);
        jmxConnectorMap.put("jmx.remote.x.client.connection.check.period", new Long(clientHeartbeatPeriod));
        this.connect("anonymous", null, jmxConnectorMap);
    }

    @Override
    public void connect(Map<String, Object> credentialMap) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException, InvalidAgentURLException {
        this.connect(credentialMap, null);
    }

    @Override
    public void connect(Map<String, Object> credentialMap, Map<String, Object> jmxConnectorMap) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException, InvalidAgentURLException {
        if (credentialMap == null) {
            this.connect("anonymous", null, jmxConnectorMap);
            return;
        }
        String username = (String)credentialMap.get("username");
        char[] password = (char[])credentialMap.get("password");
        char[] authorizationKey = (char[])credentialMap.get("authorizationkey");
        char[] signature = (char[])credentialMap.get("signature");
        String secureConnecitonProp = (String)credentialMap.get("secure.connection");
        if (secureConnecitonProp != null && secureConnecitonProp.trim().equalsIgnoreCase("true")) {
            this.handShake();
            this.setSecureConnection(true);
        } else {
            this.setSecureConnection(false);
        }
        if (username != null) {
            this.connect(username, password, jmxConnectorMap);
        } else if (authorizationKey != null) {
            this.connect(authorizationKey, signature, jmxConnectorMap);
        }
    }

    @Override
    public void connect(String username, char[] password) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException, InvalidAgentURLException {
        this.connect(username, password, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(String username, char[] passwd, Map<String, Object> jmxConnectorMap) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException, InvalidAgentURLException {
        if (this.isConnected()) {
            return;
        }
        if (this.agentURL == null) {
            throw new InvalidAgentURLException("Agent URL is null.");
        }
        JMXServiceURL jmxURL = this.agentURL.getJmxServiceURL();
        String protocol = jmxURL.getProtocol();
        if ("rmi".indexOf(protocol) < 0) {
            throw new InvalidAgentURLException("Unsupported protocol: " + protocol + ". Currently supported protocols are " + "rmi");
        }
        this.username = username;
        Object password = null;
        if (this.isAnonymousUser()) {
            password = passwd;
        } else if (this.isSecureConnection() && !this.isServerVersionOlderThan("1.5.0")) {
            try {
                password = new SecureObject((Serializable)passwd, this.getEncryptionAlgorithm(), this.getCipherProviderClass());
            }
            catch (Exception e) {
                throw new AuthenticationException("Failed to encrypt password. " + e.getMessage());
            }
        } else {
            password = passwd;
        }
        Map<String, Object> credentialMap = this.createCredentialMap(username, password);
        ConnectionWorkingThread workingThread = new ConnectionWorkingThread(this, jmxConnectorMap, credentialMap, password);
        workingThread.start();
        Object object = workingThread.getMonitor();
        synchronized (object) {
            try {
                log.debug((Object)("Wait for " + this.getClientConnectionTimeout() + " milliseconds..."));
                workingThread.getMonitor().wait(this.getClientConnectionTimeout());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        int status = workingThread.getStatus();
        if (status == 1) {
            Throwable ex = workingThread.getException();
            if (ex != null) {
                if (ex instanceof UndeclaredThrowableException) {
                    ex = this.extractUndeclaredCause((UndeclaredThrowableException)ex);
                }
                if (ex instanceof JMXException) {
                    throw (JMXException)ex;
                }
                if (ex instanceof AuthenticationException) {
                    throw (AuthenticationException)ex;
                }
                if (ex instanceof AuthorizationException) {
                    throw (AuthorizationException)ex;
                }
                if (ex instanceof InvalidAgentURLException) {
                    throw (InvalidAgentURLException)ex;
                }
                if (ex instanceof LoginModuleNotFoundException) {
                    throw (LoginModuleNotFoundException)ex;
                }
                throw new JMXException("Other MBean exception", ex.getMessage(), ex);
            }
        } else if (status != 0) {
            throw new JMXException("Connection timed out due to slow response.", "Connection timed out due to slow response. Timeout is currently set as " + this.getClientConnectionTimeout() + " milliseconds.");
        }
    }

    @Override
    public void disconnect() throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        if (!this.isConnected()) {
            return;
        }
        if (this.sessionID != null && !this.sessionID.trim().equals("")) {
            try {
                this.destroySession();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.closeJMXConnector();
        if (this.connectionListenerHook != null && !this.isServerVersionOlderThan("1.5.0")) {
            try {
                ((AgentConnectionListenerImpl)this.connectionListenerHook).destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.connectionCleanupHook != null) {
            Runtime.getRuntime().removeShutdownHook(this.connectionCleanupHook);
            this.connectionCleanupHook = null;
        }
        this.setConnected(false);
    }

    @Override
    public AgentInfo getAgentInfo() throws AuthenticationException, AuthorizationException, JMXException {
        return this.getAgentInfo(false);
    }

    @Override
    public AgentInfo getAgentInfo(boolean cached) throws AuthenticationException, AuthorizationException, JMXException {
        if (!cached) {
            try {
                this.createAgentInfo();
            }
            catch (LoginModuleNotFoundException e) {
                throw new AuthenticationException(e.getMessage());
            }
        }
        return this.agentInfo;
    }

    public String getAgentPluginIdFromObjectNameString(String id_version_instance) throws AgentPluginException {
        return this.splitPluginObjectNameString(id_version_instance)[0];
    }

    @Override
    public List<String> getAgentPluginIds() throws AuthenticationException, AuthorizationException, JMXException {
        if (this.isTimedOut()) {
            throw new JMXException("Connection timed out", "Agent connection is timed out.");
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        ArrayList<String> pluginIds = new ArrayList<String>(3);
        ObjectName objNamePattern = null;
        try {
            objNamePattern = new ObjectName("AgentPlugin:*");
        }
        catch (MalformedObjectNameException e) {
            throw new JMXException("Malformed MBean name", e.getMessage());
        }
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return pluginIds;
        }
        try {
            for (ObjectName objName : mbeanServerConn.queryNames(objNamePattern, null)) {
                String id_version = (String)ReflectionUtil.invoke(objName, "getKeyProperty", new Class[]{String.class}, new Object[]{"name"});
                String pluginId = this.getAgentPluginIdFromObjectNameString(id_version);
                if (pluginIds.contains(pluginId)) continue;
                pluginIds.add(pluginId);
            }
        }
        catch (IOException e) {
            throw new JMXException("IO Exception", e.getMessage());
        }
        catch (Exception e) {
            throw new JMXException("Reflection Exception", e.getMessage());
        }
        Collections.sort(pluginIds);
        return pluginIds;
    }

    public String getAgentPluginInstanceFromObjectNameString(String id_version_instance) throws AgentPluginException {
        return this.splitPluginObjectNameString(id_version_instance)[2];
    }

    @Override
    public int[] getAgentPluginInstanceNumbers(String pluginId, String pluginVersion) throws AuthenticationException, AuthorizationException, JMXException {
        if (this.isTimedOut()) {
            throw new JMXException("Connection timed out", "Agent connection is timed out.");
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        ArrayList<String> pluginInstanceNumberStrings = new ArrayList<String>(1);
        ObjectName objNamePattern = null;
        try {
            objNamePattern = new ObjectName("AgentPlugin:*");
        }
        catch (MalformedObjectNameException e) {
            throw new JMXException("Malformed MBean name", e.getMessage());
        }
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return new int[0];
        }
        try {
            for (ObjectName objName : mbeanServerConn.queryNames(objNamePattern, null)) {
                String instanceNumberString;
                String prefix;
                String id_version_instance = (String)ReflectionUtil.invoke(objName, "getKeyProperty", new Class[]{String.class}, new Object[]{"name"});
                if (!id_version_instance.startsWith(prefix = pluginId + "_" + pluginVersion + "_") || pluginInstanceNumberStrings.contains(instanceNumberString = this.getAgentPluginInstanceFromObjectNameString(id_version_instance))) continue;
                pluginInstanceNumberStrings.add(instanceNumberString);
            }
        }
        catch (Exception e) {
            throw new JMXException("Reflection Exception", e.getMessage());
        }
        Collections.sort(pluginInstanceNumberStrings);
        int[] pluginInstanceNumberInts = new int[pluginInstanceNumberStrings.size()];
        for (int i = 0; i < pluginInstanceNumberStrings.size(); ++i) {
            pluginInstanceNumberInts[i] = new Integer((String)pluginInstanceNumberStrings.get(i));
        }
        return pluginInstanceNumberInts;
    }

    @Override
    public String getAgentPluginLatestVersion(String pluginId) throws AuthenticationException, AuthorizationException, JMXException {
        List<String> versions = this.getAgentPluginVersions(pluginId);
        if (versions.isEmpty()) {
            throw new JMXException("Plugin version not found", "No versions are found with plugin id " + pluginId);
        }
        String latestVersion = versions.get(versions.size() - 1);
        return latestVersion;
    }

    @Override
    public List<String> getAgentPluginMBeanNames() throws AuthenticationException, AuthorizationException, JMXException {
        if (this.isTimedOut()) {
            throw new JMXException("Connection timed out", "Agent connection is timed out.");
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        ArrayList<String> mbeanNames = new ArrayList<String>(3);
        ObjectName objNamePattern = null;
        try {
            objNamePattern = new ObjectName("AgentPlugin:*");
        }
        catch (MalformedObjectNameException e) {
            throw new JMXException("Malformed MBean name", e.getMessage());
        }
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return mbeanNames;
        }
        try {
            for (ObjectName objName : mbeanServerConn.queryNames(objNamePattern, null)) {
                String mbeanName = ((Object)objName).toString();
                mbeanNames.add(mbeanName);
            }
        }
        catch (IOException e) {
            throw new JMXException("IO Exception", e.getMessage());
        }
        Collections.sort(mbeanNames);
        return mbeanNames;
    }

    @Override
    public Map<String, Object> getAgentPluginProperties(String mbeanName) throws AuthenticationException, AuthorizationException, JMXException {
        MBeanAttributeInfo[] attributeInfos;
        TreeMap<String, Object> properties = new TreeMap<String, Object>();
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return properties;
        }
        ObjectName objName = null;
        try {
            objName = new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new JMXException("Malformed MBean name", e.getMessage());
        }
        MBeanInfo mbeanInfo = null;
        try {
            mbeanInfo = mbeanServerConn.getMBeanInfo(objName);
        }
        catch (InstanceNotFoundException e) {
            throw new JMXException("MBean instance not found", e.getMessage());
        }
        catch (IntrospectionException e) {
            throw new JMXException("Introspection Exception", e.getMessage());
        }
        catch (ReflectionException e) {
            throw new JMXException("Reflection Exception", e.getMessage());
        }
        catch (IOException e) {
            throw new JMXException("IO Exception", e.getMessage());
        }
        for (MBeanAttributeInfo attributeInfo : attributeInfos = mbeanInfo.getAttributes()) {
            String name = attributeInfo.getName();
            Object value = null;
            try {
                value = mbeanServerConn.getAttribute(objName, name);
            }
            catch (Throwable t) {
                String error = t.toString();
                if (error.indexOf("java.io.NotSerializableException") >= 0) {
                    log.warn((Object)("Not serializable property: " + name));
                    continue;
                }
                log.error((Object)t.toString());
                continue;
            }
            if (value == null) {
                value = new String("");
            }
            properties.put(name, value);
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        return properties;
    }

    @Override
    public Map<String, Object> getAgentPluginProperties(String pluginId, String pluginVersion, int instanceNumber) throws AuthenticationException, AuthorizationException, JMXException {
        String mbeanName = AgentClientUtil.getPluginMBeanName(pluginId, pluginVersion, instanceNumber);
        return this.getAgentPluginProperties(mbeanName);
    }

    @Override
    public Object getAgentPluginProperty(String mbeanName, String propertyName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = null;
        try {
            objName = new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            JMXException jmxException = new JMXException("Malformed MBean name", e.getMessage(), e);
            throw jmxException;
        }
        return this.getMBeanAttribute(objName, propertyName);
    }

    @Override
    public Object getAgentPluginProperty(String pluginId, String pluginVersion, int instanceNumber, String propertyName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = null;
        try {
            objName = AgentClientUtil.getPluginObjectName(pluginId, pluginVersion, instanceNumber);
        }
        catch (MalformedObjectNameException e) {
            JMXException jmxException = new JMXException("Malformed MBean name", e.getMessage(), e);
            throw jmxException;
        }
        return this.getMBeanAttribute(objName, propertyName);
    }

    @Override
    public List<String> getAgentPluginPropertyNames(String mbeanName) throws AuthenticationException, AuthorizationException, JMXException {
        MBeanAttributeInfo[] attributeInfos;
        if (this.isTimedOut()) {
            throw new JMXException("Connection timed out", "Agent connection is timed out.");
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        ArrayList<String> propertyNames = new ArrayList<String>();
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return propertyNames;
        }
        ObjectName objName = null;
        try {
            objName = new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new JMXException("Malformed MBean name", e.getMessage());
        }
        MBeanInfo mbeanInfo = null;
        try {
            mbeanInfo = mbeanServerConn.getMBeanInfo(objName);
        }
        catch (InstanceNotFoundException e) {
            throw new JMXException("MBean instance not found", e.getMessage());
        }
        catch (IntrospectionException e) {
            throw new JMXException("Introspection Exception", e.getMessage());
        }
        catch (ReflectionException e) {
            throw new JMXException("Reflection Exception", e.getMessage());
        }
        catch (IOException e) {
            throw new JMXException("IO Exception", e.getMessage());
        }
        for (MBeanAttributeInfo attributeInfo : attributeInfos = mbeanInfo.getAttributes()) {
            String name = attributeInfo.getName();
            if (propertyNames.contains(name)) continue;
            propertyNames.add(name);
        }
        Collections.sort(propertyNames);
        return propertyNames;
    }

    @Override
    public List<String> getAgentPluginPropertyNames(String pluginId, String pluginVersion, int instanceNumber) throws AuthenticationException, AuthorizationException, JMXException {
        String mbeanName = AgentClientUtil.getPluginMBeanName(pluginId, pluginVersion, instanceNumber);
        return this.getAgentPluginPropertyNames(mbeanName);
    }

    public String getAgentPluginVersionFromObjectNameString(String id_version_instance) throws AgentPluginException {
        return this.splitPluginObjectNameString(id_version_instance)[1];
    }

    @Override
    public List<String> getAgentPluginVersions(String pluginId) throws AuthenticationException, AuthorizationException, JMXException {
        if (this.isTimedOut()) {
            throw new JMXException("Connection timed out", "Agent connection is timed out.");
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        ArrayList<String> pluginVersions = new ArrayList<String>(1);
        ObjectName objNamePattern = null;
        try {
            objNamePattern = new ObjectName("AgentPlugin:*");
        }
        catch (MalformedObjectNameException e) {
            throw new JMXException("Malformed MBean name", e.getMessage());
        }
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return pluginVersions;
        }
        try {
            for (ObjectName objName : mbeanServerConn.queryNames(objNamePattern, null)) {
                String version;
                String prefix;
                String id_version_instance = (String)ReflectionUtil.invoke(objName, "getKeyProperty", new Class[]{String.class}, new Object[]{"name"});
                if (!id_version_instance.startsWith(prefix = pluginId + "_") || pluginVersions.contains(version = this.getAgentPluginVersionFromObjectNameString(id_version_instance))) continue;
                pluginVersions.add(version);
            }
        }
        catch (Exception e) {
            throw new JMXException("Reflection Exception", e.getMessage());
        }
        Collections.sort(pluginVersions);
        return pluginVersions;
    }

    @Override
    public List<String> getAgentServiceIds() throws AuthenticationException, AuthorizationException, JMXException {
        if (this.isTimedOut()) {
            throw new JMXException("Connection timed out", "Agent connection is timed out.");
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        ArrayList<String> serviceNames = new ArrayList<String>(3);
        ObjectName objNamePattern = null;
        try {
            objNamePattern = new ObjectName("AgentService:*");
        }
        catch (MalformedObjectNameException e) {
            throw new JMXException("Malformed MBean name", e.getMessage());
        }
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return serviceNames;
        }
        try {
            Set<ObjectName> mbeans = mbeanServerConn.queryNames(objNamePattern, null);
            for (ObjectName objName : mbeans) {
                String serviceId = (String)ReflectionUtil.invoke(objName, "getKeyProperty", new Class[]{String.class}, new Object[]{"name"});
                serviceNames.add(serviceId);
            }
        }
        catch (Exception e) {
            throw new JMXException("Reflection Exception", e.getMessage());
        }
        Collections.sort(serviceNames);
        return serviceNames;
    }

    @Override
    public List<String> getAgentServiceMBeanNames() throws AuthenticationException, AuthorizationException, JMXException {
        if (this.isTimedOut()) {
            throw new JMXException("Connection timed out", "Agent connection is timed out.");
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        ArrayList<String> mbeanNames = new ArrayList<String>(3);
        ObjectName objNamePattern = null;
        try {
            objNamePattern = new ObjectName("AgentService:*");
        }
        catch (MalformedObjectNameException e) {
            throw new JMXException("Malformed MBean name", e.getMessage());
        }
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return mbeanNames;
        }
        try {
            Set<ObjectName> mbeans = mbeanServerConn.queryNames(objNamePattern, null);
            for (ObjectName objName : mbeans) {
                String mbeanName = ((Object)objName).toString();
                mbeanNames.add(mbeanName);
            }
        }
        catch (IOException e) {
            throw new JMXException("IO Exception", e.getMessage());
        }
        Collections.sort(mbeanNames);
        return mbeanNames;
    }

    @Override
    public Object getAgentServiceProperty(String serviceId, String propertyName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = null;
        try {
            objName = AgentClientUtil.getServiceObjectName(serviceId);
        }
        catch (MalformedObjectNameException e) {
            JMXException jmxException = new JMXException("Malformed MBean name", e.getMessage(), e);
            throw jmxException;
        }
        return this.getMBeanAttribute(objName, propertyName);
    }

    @Override
    public Object getAgentServicePropertyByMBeanName(String mbeanName, String propertyName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = null;
        try {
            objName = new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            JMXException jmxException = new JMXException("Malformed MBean name", e.getMessage(), e);
            throw jmxException;
        }
        return this.getMBeanAttribute(objName, propertyName);
    }

    @Override
    public AgentURL getAgentURL() {
        return this.agentURL;
    }

    @Override
    public String getAgentURLAsString() {
        return this.getAgentURLLongFormatAsString();
    }

    @Override
    public String getAgentURLLongFormatAsString() {
        return this.agentURL.getURLLongFormat();
    }

    @Override
    public String getAgentURLShortFormatAsString() {
        return this.agentURL.getURLShortFormat();
    }

    @Override
    public String getCipherProviderClass() {
        return this.cipherProviderClass;
    }

    @Override
    public long getClientConnectionTimeout() {
        return this.clientConnectionTimeout;
    }

    public ConnectionCleanupHook getConnectionCleanupHook() {
        return this.connectionCleanupHook;
    }

    @Override
    public String getCurrentSecurityModule() throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        String moduleName = (String)this.invokeAgentServiceMethod("SecurityService", "getCurrentSecurityModule", new Object[]{this.getSessionID()}, new String[]{"java.lang.String"});
        return moduleName;
    }

    @Override
    public String[] getDomains() throws JMXException {
        String[] domains = null;
        try {
            MBeanServerConnection mbsc = this.getMBeanServerConnection();
            domains = mbsc.getDomains();
            this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        }
        catch (IOException e) {
            log.error((Object)e.toString(), (Throwable)e);
            throw new JMXException("IO Exception", e.getMessage());
        }
        return domains;
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @Override
    public JMXServiceURL getJMXServiceURL() throws AgentConnectionException {
        return this.agentURL.getJmxServiceURL();
    }

    @Override
    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    @Override
    public Object getMBeanAttribute(ObjectName objName, String attributeName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        boolean isStandardMBean = true;
        MBeanInfo mbeanInfo = this.getMBeanInfo(objName);
        if (mbeanInfo instanceof ModelMBeanInfoSupport) {
            isStandardMBean = false;
        }
        this.checkObjectName(objName);
        String attribNameFirstLetterLowerCase = attributeName.substring(0, 1).toLowerCase() + attributeName.substring(1);
        String attribNameFirstLetterUpperCase = attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1);
        String permission = "read";
        ResourceURL resURL = ResourceURL.createResourceURL(objName, attributeName);
        if (!this.hasAccess(resURL.toString(), "read") && !this.hasAccess(Pre30ResourceURL.convertResourceURL(resURL), "read")) {
            throw new AuthorizationException("User " + this.getUsername() + " does not have " + "read" + " access to resource " + resURL.getResourcePath());
        }
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return null;
        }
        Object value = null;
        try {
            try {
                value = isStandardMBean ? mbeanServerConn.getAttribute(objName, attribNameFirstLetterUpperCase) : mbeanServerConn.getAttribute(objName, attribNameFirstLetterLowerCase);
            }
            catch (UndeclaredThrowableException ute) {
                throw this.extractUndeclaredCause(ute);
            }
        }
        catch (MBeanException e) {
            JMXException jmxException = new JMXException("Other MBean exception", e.getMessage(), e);
            throw jmxException;
        }
        catch (AttributeNotFoundException e) {
            JMXException jmxException = new JMXException("Attribute not found", e.getMessage(), e);
            throw jmxException;
        }
        catch (InstanceNotFoundException e) {
            JMXException jmxException = new JMXException("MBean instance not found", e.getMessage(), e);
            throw jmxException;
        }
        catch (ReflectionException e) {
            JMXException jmxException = new JMXException("Reflection Exception", e.getMessage(), e);
            throw jmxException;
        }
        catch (IOException e) {
            JMXException jmxException = new JMXException("IO Exception", e.getMessage(), e);
            throw jmxException;
        }
        catch (Throwable t) {
            JMXException jmxException = new JMXException("Other MBean exception", t.getMessage(), t);
            throw jmxException;
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        return value;
    }

    @Override
    public Object getMBeanAttribute(String mbeanName, String attributeName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = null;
        try {
            objName = new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            JMXException jmxException = new JMXException("Malformed MBean name", e.getMessage(), e);
            throw jmxException;
        }
        return this.getMBeanAttribute(objName, attributeName);
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objName) throws JMXException {
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return null;
        }
        MBeanInfo mbeanInfo = null;
        try {
            mbeanInfo = mbeanServerConn.getMBeanInfo(objName);
        }
        catch (IOException e) {
            JMXException jmxException = new JMXException("IO Exception", e.getMessage(), e);
            throw jmxException;
        }
        catch (InstanceNotFoundException e) {
            JMXException jmxException = new JMXException("MBean instance not found", e.getMessage(), e);
            throw jmxException;
        }
        catch (IntrospectionException e) {
            JMXException jmxException = new JMXException("Introspection Exception", e.getMessage(), e);
            throw jmxException;
        }
        catch (ReflectionException e) {
            JMXException jmxException = new JMXException("Reflection Exception", e.getMessage(), e);
            throw jmxException;
        }
        catch (Exception e) {
            JMXException jmxException = new JMXException("Other MBean exception", e.getMessage(), e);
            throw jmxException;
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        return mbeanInfo;
    }

    @Override
    public MBeanInfo getMBeanInfo(String mbeanName) throws JMXException {
        ObjectName objName = null;
        try {
            objName = new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            JMXException jmxException = new JMXException("Malformed MBean name", e.getMessage(), e);
            throw jmxException;
        }
        return this.getMBeanInfo(objName);
    }

    @Override
    public String getProtocol() {
        return this.agentURL.getProtocol();
    }

    @Override
    public String getSessionID() {
        return this.sessionID;
    }

    @Override
    public String[] getSessionSecurityModules() throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        String[] moduleNames = (String[])this.invokeAgentServiceMethod("SecurityService", "getSessionSecurityModules", new Object[]{this.getSessionID()}, new String[]{"java.lang.String"});
        return moduleNames;
    }

    @Override
    public long getTimeCreated() {
        return this.timeCreated;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean hasAccess(String resourceURL, String permission) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        if (this.isPrimordialResource(resourceURL)) {
            return true;
        }
        if (!this.isAgentServiceAvailable("SecurityService")) {
            String msg = "Agent's security service not available. Access denied.";
            log.warn((Object)"Agent's security service not available. Access denied.");
            return false;
        }
        if (!this.isAgentServiceStarted("SecurityService")) {
            String msg = "Agent's security service installed but stopped. Deny all kinds of access.";
            throw new AuthorizationException("Agent's security service installed but stopped. Deny all kinds of access.");
        }
        Boolean hasAccess = (Boolean)this.invokeAgentServiceMethod("SecurityService", "hasAccess", new Object[]{this.getSessionID(), resourceURL, permission}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String"});
        return hasAccess;
    }

    @Override
    public Object invokeAgentPluginMethod(String mbeanName, String methodName, Object[] paramValues, String[] paramTypes) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException {
        ObjectName objName = null;
        try {
            objName = new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            JMXException jmxException = new JMXException("Malformed MBean name", e.getMessage(), e);
            throw jmxException;
        }
        return this.invokeMBeanOperation(objName, methodName, paramValues, paramTypes);
    }

    @Override
    public Object invokeAgentPluginMethod(String pluginId, String pluginVersion, int instanceNumber, String methodName, Object[] paramValues, String[] paramTypes) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException {
        ObjectName objName = null;
        try {
            objName = AgentClientUtil.getPluginObjectName(pluginId, pluginVersion, instanceNumber);
        }
        catch (MalformedObjectNameException e) {
            JMXException jmxException = new JMXException("Malformed MBean name", e.getMessage(), e);
            throw jmxException;
        }
        return this.invokeMBeanOperation(objName, methodName, paramValues, paramTypes);
    }

    @Override
    public Object invokeAgentServiceMethod(String serviceId, String methodName, Object[] paramValues, String[] paramTypes) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException {
        ObjectName objName = null;
        try {
            objName = AgentClientUtil.getServiceObjectName(serviceId);
        }
        catch (MalformedObjectNameException e) {
            JMXException jmxException = new JMXException("Malformed MBean name", e.getMessage(), e);
            throw jmxException;
        }
        return this.invokeMBeanOperation(objName, methodName, paramValues, paramTypes);
    }

    @Override
    public Object invokeMBeanOperation(ObjectName objName, String operationName, Object[] paramValues, String[] paramTypes) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException {
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return null;
        }
        if (!this.isMBeanAvailable(objName.toString())) {
            throw new JMXException("MBean instance not found", "MBean not found: " + objName.toString());
        }
        if (!this.isMBeanMethodAvailable(objName.toString(), operationName)) {
            throw new JMXException("Method not found", "Method not found: " + operationName);
        }
        this.checkObjectName(objName);
        ResourceURL resURL = ResourceURL.createResourceURL(ResourceURL.ResourceFieldType.METHOD, objName, operationName, paramTypes);
        String permission = "execute";
        if (!this.hasAccess(resURL.toString(), "execute") && !this.hasAccess(Pre30ResourceURL.convertResourceURL(resURL), "execute")) {
            throw new AuthorizationException("User " + this.getUsername() + " does not have " + "execute" + " access to resource " + resURL.getResourcePath());
        }
        Object returnObject = null;
        try {
            try {
                returnObject = mbeanServerConn.invoke(objName, operationName, paramValues, paramTypes);
            }
            catch (UndeclaredThrowableException ute) {
                throw this.extractUndeclaredCause(ute);
            }
        }
        catch (MBeanException e) {
            Exception targetException = e.getTargetException();
            if (targetException instanceof AuthenticationException) {
                throw (AuthenticationException)targetException;
            }
            if (targetException instanceof LoginModuleNotFoundException) {
                throw (LoginModuleNotFoundException)targetException;
            }
            throw new JMXException("Other MBean exception", targetException.getMessage());
        }
        catch (InstanceNotFoundException e) {
            JMXException jmxException = new JMXException("MBean instance not found", e.getMessage(), e);
            throw jmxException;
        }
        catch (ReflectionException e) {
            JMXException jmxException = new JMXException("Reflection Exception", e.getMessage(), e);
            throw jmxException;
        }
        catch (IOException e) {
            JMXException jmxException = new JMXException("IO Exception", e.getMessage(), e);
            throw jmxException;
        }
        catch (Throwable t) {
            JMXException jmxException = new JMXException("Other MBean exception", t.getMessage(), t);
            throw jmxException;
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        return returnObject;
    }

    @Override
    public Object invokeMBeanOperation(String mbeanName, String operationName, Object[] paramValues, String[] paramTypes) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = null;
        try {
            objName = new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new JMXException("Malformed MBean name", e.getMessage());
        }
        return this.invokeMBeanOperation(objName, operationName, paramValues, paramTypes);
    }

    @Override
    public boolean isAgentPluginAvailable(String pluginId, String pluginVersion, int instanceNumber) throws AuthenticationException, AuthorizationException, JMXException {
        String mbeanName = AgentClientUtil.getPluginMBeanName(pluginId, pluginVersion, instanceNumber);
        return this.isMBeanAvailable(mbeanName);
    }

    public boolean isAgentPluginLoaded(String mbeanName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        Boolean pluginLoaded;
        return this.isMBeanAvailable(mbeanName) && (pluginLoaded = (Boolean)this.getAgentPluginProperty(mbeanName, "loaded")) != false;
    }

    @Override
    public boolean isAgentPluginLoaded(String pluginId, String pluginVersion, int instanceNumber) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        String mbeanName = AgentClientUtil.getPluginMBeanName(pluginId, pluginVersion, instanceNumber);
        return this.isAgentPluginLoaded(mbeanName);
    }

    @Override
    public boolean isAgentPluginMethodAvailable(String pluginId, String pluginVersion, int instanceNumber, String method) throws AuthenticationException, AuthorizationException, JMXException {
        String mbeanName = AgentClientUtil.getPluginMBeanName(pluginId, pluginVersion, instanceNumber);
        return this.isMBeanMethodAvailable(mbeanName, method);
    }

    @Override
    public boolean isAgentServiceAvailable(String serviceId) throws JMXException {
        String mbeanName = AgentClientUtil.getServiceMBeanName(serviceId);
        return this.isMBeanAvailable(mbeanName);
    }

    @Override
    public boolean isAgentServiceMethodAvailable(String serviceId, String method) throws AuthenticationException, AuthorizationException, JMXException {
        String mbeanName = AgentClientUtil.getServiceMBeanName(serviceId);
        return this.isMBeanMethodAvailable(mbeanName, method);
    }

    @Override
    public boolean isAgentServiceStarted(String serviceId) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        Boolean serivceStarted;
        String mbeanName = AgentClientUtil.getServiceMBeanName(serviceId);
        return this.isMBeanAvailable(mbeanName) && (serivceStarted = (Boolean)this.getAgentServiceProperty(serviceId, "started")) != false;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isSecureConnection() {
        return this.secureConnection;
    }

    @Override
    public boolean isTimedOut() {
        return this.timedOut;
    }

    @Override
    @Deprecated
    public void login(char[] authorizationKey, char[] signature) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        this.invokeAgentServiceMethod("SecurityService", "login", new Object[]{this.getSessionID(), authorizationKey, signature}, new String[]{"java.lang.String", "[C", "[C"});
        this.retrieveUsername();
    }

    @Override
    public void login(Map<String, Object> credentialMap) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        if (credentialMap == null) {
            this.login("anonymous", null);
            return;
        }
        String username = (String)credentialMap.get("username");
        char[] password = (char[])credentialMap.get("password");
        char[] authorizationKey = (char[])credentialMap.get("authorizationkey");
        char[] signature = (char[])credentialMap.get("signature");
        if (username != null) {
            this.login(username, password);
        } else if (authorizationKey != null) {
            this.login(authorizationKey, signature);
        }
    }

    @Override
    public void login(String username, char[] password) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        Object passwd = null;
        if ("anonymous".equals(username)) {
            passwd = password;
        } else if (this.isSecureConnection() && !this.isServerVersionOlderThan("1.5.0")) {
            try {
                passwd = new SecureObject((Serializable)password, this.getEncryptionAlgorithm(), this.getCipherProviderClass());
            }
            catch (Exception e) {
                throw new AuthenticationException("Failed to encrypt password. " + e.getMessage());
            }
        } else {
            passwd = password;
        }
        String passwordType = "[C";
        if (passwd != null) {
            passwordType = passwd.getClass().getName();
        }
        this.invokeAgentServiceMethod("SecurityService", "login", new Object[]{this.getSessionID(), username, passwd}, new String[]{"java.lang.String", "java.lang.String", passwordType});
        this.retrieveUsername();
    }

    @Override
    public void logout() {
        try {
            this.invokeAgentServiceMethod("SecurityService", "logout", new Object[]{this.getSessionID()}, new String[]{"java.lang.String"});
            this.retrieveUsername();
        }
        catch (AgentConnectionException e) {
            log.error((Object)e.toString());
        }
    }

    @Override
    public Set<ObjectName> queryMBeans(ObjectName objNamePattern, QueryExp query) throws JMXException {
        if (this.isTimedOut()) {
            throw new JMXException("Connection timed out", "Agent connection is timed out.");
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return null;
        }
        Set<ObjectName> result = null;
        try {
            result = mbeanServerConn.queryNames(objNamePattern, query);
        }
        catch (IOException e) {
            JMXException jmxException = new JMXException("IO Exception", e.getMessage(), e);
            throw jmxException;
        }
        return result;
    }

    @Override
    public Set<ObjectName> queryMBeans(String mbeanNamePattern, QueryExp query) throws JMXException {
        ObjectName objNamePattern = null;
        try {
            objNamePattern = new ObjectName(mbeanNamePattern);
        }
        catch (MalformedObjectNameException e) {
            JMXException jmxException = new JMXException("Malformed MBean name", e.getMessage(), e);
            throw jmxException;
        }
        return this.queryMBeans(objNamePattern, query);
    }

    @Override
    public void reloadACLCache() throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        this.invokeAgentServiceMethod("SecurityService", "reloadACLCache", new Object[]{this.getSessionID()}, new String[]{"java.lang.String"});
    }

    @Override
    public void removeConnectionListener(ConnectionListener listener) {
        if (this.connectionListenerHook != null) {
            try {
                if (!this.isServerVersionOlderThan("1.5.0")) {
                    AgentConnectionListenerImpl connectionListenerHookImpl = (AgentConnectionListenerImpl)this.connectionListenerHook;
                    connectionListenerHookImpl.removeConnectionListener(listener);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void retrieveUsername() throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        this.username = (String)this.invokeAgentServiceMethod("SecurityService", "getUsername", new Object[]{this.getSessionID()}, new String[]{"java.lang.String"});
    }

    @Override
    public void setAgentPluginProperty(String pluginId, String pluginVersion, int instanceNumber, String propertyName, Object propertyValue) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = null;
        try {
            objName = AgentClientUtil.getPluginObjectName(pluginId, pluginVersion, instanceNumber);
        }
        catch (MalformedObjectNameException e) {
            JMXException jmxException = new JMXException("Malformed MBean name", e.getMessage(), e);
            throw jmxException;
        }
        this.setMBeanAttribute(objName, propertyName, propertyValue);
    }

    @Override
    public void setAgentServiceProperty(String serviceId, String propertyName, Object propertyValue) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = null;
        try {
            objName = AgentClientUtil.getServiceObjectName(serviceId);
        }
        catch (MalformedObjectNameException e) {
            JMXException jmxException = new JMXException("Malformed MBean name", e.getMessage(), e);
            throw jmxException;
        }
        this.setMBeanAttribute(objName, propertyName, propertyValue);
    }

    @Override
    public void setCipherProviderClass(String cipherProviderClass) {
        this.cipherProviderClass = cipherProviderClass;
    }

    @Override
    public void setClientConnectionTimeout(long clientConnectionTimeout) {
        this.clientConnectionTimeout = clientConnectionTimeout;
    }

    @Override
    public synchronized void setConnected(boolean connected) {
        this.connected = connected;
    }

    public void setConnectionCleanupHook(ConnectionCleanupHook connectionCleanupHook) {
        this.connectionCleanupHook = connectionCleanupHook;
    }

    @Override
    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
    }

    @Override
    public void setMBeanAttribute(ObjectName objName, String attributeName, Object attributeValue) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        if (this.isTimedOut()) {
            throw new JMXException("Connection timed out", "Agent connection is timed out.");
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        boolean isStandardMBean = true;
        MBeanInfo mbeanInfo = this.getMBeanInfo(objName);
        if (mbeanInfo instanceof ModelMBeanInfoSupport) {
            isStandardMBean = false;
        }
        this.checkObjectName(objName);
        String attribNameFirstLetterLowerCase = attributeName.substring(0, 1).toLowerCase() + attributeName.substring(1);
        String attribNameFirstLetterUpperCase = attributeName.substring(0, 1).toUpperCase() + attributeName.substring(1);
        String permission = "write";
        ResourceURL resURL = ResourceURL.createResourceURL(objName, attributeName);
        if (!this.hasAccess(resURL.toString(), "write") && !this.hasAccess(Pre30ResourceURL.convertResourceURL(resURL), "write")) {
            throw new AuthorizationException("User " + this.getUsername() + " does not have " + "write" + " access to resource " + resURL.getResourcePath());
        }
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return;
        }
        Attribute attribute = null;
        attribute = isStandardMBean ? new Attribute(attribNameFirstLetterUpperCase, attributeValue) : new Attribute(attribNameFirstLetterLowerCase, attributeValue);
        try {
            try {
                mbeanServerConn.setAttribute(objName, attribute);
            }
            catch (UndeclaredThrowableException ute) {
                throw this.extractUndeclaredCause(ute);
            }
        }
        catch (InvalidAttributeValueException e) {
            JMXException jmxException = new JMXException("Invalid attribute value", e.getMessage(), e);
            throw jmxException;
        }
        catch (MBeanException e) {
            JMXException jmxException = new JMXException("Other MBean exception", e.getMessage(), e);
            throw jmxException;
        }
        catch (AttributeNotFoundException e) {
            JMXException jmxException = new JMXException("Attribute not found", e.getMessage(), e);
            throw jmxException;
        }
        catch (InstanceNotFoundException e) {
            JMXException jmxException = new JMXException("MBean instance not found", e.getMessage(), e);
            throw jmxException;
        }
        catch (ReflectionException e) {
            JMXException jmxException = new JMXException("Reflection Exception", e.getMessage(), e);
            throw jmxException;
        }
        catch (IOException e) {
            JMXException jmxException = new JMXException("IO Exception", e.getMessage(), e);
            throw jmxException;
        }
        catch (Throwable t) {
            JMXException jmxException = new JMXException("Other MBean exception", t.getMessage(), t);
            throw jmxException;
        }
    }

    @Override
    public void setMBeanAttribute(String mbeanName, String attributeName, Object attributeValue) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = null;
        try {
            objName = new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            JMXException jmxException = new JMXException("Malformed MBean name", e.getMessage(), e);
            throw jmxException;
        }
        this.setMBeanAttribute(objName, attributeName, attributeValue);
    }

    @Override
    public void setSecureConnection(boolean secureConnection) {
        this.secureConnection = secureConnection;
    }

    @Override
    public void setTimedOut(boolean timedOut) {
        this.timedOut = timedOut;
    }

    protected synchronized void createAgentInfo() throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        try {
            this.agentInfo = (AgentInfo)this.getAgentServiceProperty("Agent", "agentInfo");
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            this.createAgentInfoV0_6_1_20();
        }
    }

    protected synchronized void createSession(char[] authorizationKey, char[] signature) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        if (!this.isAgentServiceAvailable("SecurityService")) {
            log.debug((Object)"Agent's security service not installed. Allow all connections to pass through.");
            this.username = "anonymous";
            return;
        }
        if (!this.isAgentServiceStarted("SecurityService")) {
            String msg = "Agent's security service installed but stopped. Deny all connections.";
            throw new AuthenticationException("Agent's security service installed but stopped. Deny all connections.");
        }
        Map<String, Object> clientEnv = this.getClientEnv();
        this.sessionID = (String)this.invokeAgentServiceMethod("SecurityService", "createSession", new Object[]{authorizationKey, signature, clientEnv}, new String[]{"[C", "[C", "java.util.Map"});
        this.retrieveUsername();
    }

    protected synchronized void createSession(String username, Object password) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException {
        if (!this.isAgentServiceAvailable("SecurityService")) {
            log.debug((Object)"Agent's security service not installed. Allow all connections to pass through.");
            this.username = "anonymous";
            return;
        }
        if (!this.isAgentServiceStarted("SecurityService")) {
            String msg = "Agent's security service installed but stopped. Deny all connections.";
            throw new AuthenticationException("Agent's security service installed but stopped. Deny all connections.");
        }
        Map<String, Object> clientEnv = this.getClientEnv();
        String method = "createSession";
        String passwordType = "[C";
        if (password != null) {
            passwordType = password.getClass().getName();
        }
        this.sessionID = (String)this.invokeAgentServiceMethod("SecurityService", "createSession", new Object[]{username, password, clientEnv}, new String[]{"java.lang.String", passwordType, "java.util.Map"});
        this.retrieveUsername();
    }

    protected boolean isMBeanAvailable(String mbeanName) throws JMXException {
        ObjectName objNamePattern = null;
        try {
            objNamePattern = new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new JMXException("Malformed MBean name", e.getMessage());
        }
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return false;
        }
        Set<ObjectName> namesset = null;
        try {
            namesset = mbeanServerConn.queryNames(objNamePattern, null);
        }
        catch (IOException e) {
            throw new JMXException("IO Exception", e.getMessage());
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        return namesset != null && !namesset.isEmpty();
    }

    protected boolean isMBeanMethodAvailable(String mbeanName, String method) throws JMXException {
        ObjectName objName = null;
        try {
            objName = new ObjectName(mbeanName);
        }
        catch (MalformedObjectNameException e) {
            throw new JMXException("Malformed MBean name", e.getMessage());
        }
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return false;
        }
        MBeanInfo mbeanInfo = null;
        boolean methodAvailable = false;
        try {
            MBeanOperationInfo[] operationInfos;
            mbeanInfo = mbeanServerConn.getMBeanInfo(objName);
            for (MBeanOperationInfo operationInfo : operationInfos = mbeanInfo.getOperations()) {
                if (!method.equals(operationInfo.getName())) continue;
                methodAvailable = true;
                break;
            }
        }
        catch (InstanceNotFoundException e) {
            throw new JMXException("MBean instance not found", e.getMessage());
        }
        catch (IntrospectionException e) {
            throw new JMXException("Introspection Exception", e.getMessage());
        }
        catch (ReflectionException e) {
            throw new JMXException("Reflection Exception", e.getMessage());
        }
        catch (IOException e) {
            throw new JMXException("IO Exception", e.getMessage());
        }
        this.lastActivityTime = new Date().getTime() + this.serverTimeDiff;
        return methodAvailable;
    }

    protected boolean isServerVersionOlderThan(String version) throws AuthenticationException, AuthorizationException, JMXException {
        boolean older = true;
        AgentInfo agentServerInfo = null;
        if (this.agentInfo != null) {
            agentServerInfo = this.agentInfo;
        } else {
            try {
                if (this.isConnected() && !this.isTimedOut()) {
                    agentServerInfo = this.getAgentInfo();
                }
            }
            catch (Exception ex1) {
                // empty catch block
            }
        }
        if (agentServerInfo == null) {
            try {
                AgentConnection aconn = AgentConnectionFactory.createAgentConnection(this.getAgentURLAsString());
                aconn.setClientConnectionTimeout(this.getClientConnectionTimeout());
                aconn.connect();
                agentServerInfo = aconn.getAgentInfo();
                aconn.disconnect();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (agentServerInfo != null) {
            int versionDiff = -1;
            try {
                Version agentVersion = Version.createVersion(agentServerInfo.getVersion());
                Version givenVersion = Version.createVersion(version);
                versionDiff = agentVersion.compare(givenVersion);
            }
            catch (MalformatVersionException ex) {
                log.error((Object)ex.getCause());
            }
            older = versionDiff < 0;
        }
        return older;
    }

    protected synchronized void setupConnectionListenerHook() throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException {
        if (this.agentURL == null) {
            return;
        }
        String protocol = this.agentURL.getProtocol();
        if (this.connectionListenerHook == null) {
            return;
        }
        ((AgentConnectionListenerImpl)this.connectionListenerHook).init(this);
        if (protocol.equals("rmi")) {
            if (!this.isAgentServiceAvailable(RMI_SERVICE_ID)) {
                throw new JMXException("Service is not started", "RMI Service not available. ");
            }
            this.invokeAgentServiceMethod(RMI_SERVICE_ID, "addConnectionListener", new Object[]{this.connectionListenerHook}, new String[]{AgentConnectionListener.class.getName()});
        }
    }

    protected String[] splitPluginObjectNameString(String objectNameString) throws AgentPluginException {
        if (objectNameString == null) {
            throw new AgentPluginException(MessageFormat.format(INVALID_PLUGIN_OBJECT_NAME_FORMAT_MSG, objectNameString));
        }
        String[] splitOName = objectNameString.split("_");
        if (splitOName.length != 3) {
            throw new AgentPluginException(MessageFormat.format(INVALID_PLUGIN_OBJECT_NAME_FORMAT_MSG, objectNameString));
        }
        if (!splitOName[0].matches("[\\w\\.\\-]+")) {
            throw new AgentPluginException(MessageFormat.format(INVALID_PLUGIN_OBJECT_NAME_FORMAT_MSG, objectNameString) + "Plugin ID portion of name is invalid.  It must be of the form \"[\\w\\.\\-]+\"");
        }
        if (!splitOName[1].matches("\\d+[\\.\\d]+")) {
            throw new AgentPluginException(MessageFormat.format(INVALID_PLUGIN_OBJECT_NAME_FORMAT_MSG, objectNameString) + "Version portion of name is invalid.  It must be of the form \"\\d+[\\.\\d]+\"");
        }
        if (!splitOName[2].matches("\\d+")) {
            throw new AgentPluginException(MessageFormat.format(INVALID_PLUGIN_OBJECT_NAME_FORMAT_MSG, objectNameString) + "Instance portion of name is invalid.  It must be numeric.");
        }
        return splitOName;
    }

    private void checkObjectName(ObjectName objName) throws JMXException {
        if (objName.getDomain().equals("AgentService")) {
            String serviceId = objName.getKeyProperty("name");
            if (serviceId == null || serviceId.trim().equals("")) {
                throw new JMXException("Malformed MBean name", "Invalid service MBean name: " + objName.toString() + ". It must conform to the format " + "AgentService" + ":" + "name" + "=<serviceId>");
            }
        } else if (objName.getDomain().equals("AgentPlugin")) {
            String id_version_instance = objName.getKeyProperty("name");
            if (id_version_instance == null || id_version_instance.trim().equals("")) {
                throw new JMXException("Malformed MBean name", "Invalid plugin MBean name: " + objName.toString() + ". It must conform to the format " + "AgentPlugin" + ":" + "name" + "=<id>_<version>_<instance>");
            }
            int idx1 = id_version_instance.indexOf("_");
            if (idx1 <= 0) {
                throw new JMXException("Malformed MBean name", "Invalid plugin MBean name field: " + id_version_instance + ". It must have the format of id_version_instance");
            }
            int idx2 = id_version_instance.lastIndexOf("_");
            if (idx2 <= 0 || idx2 <= idx1) {
                throw new JMXException("Malformed MBean name", "Invalid plugin MBean name field: " + id_version_instance + ". It must have the format of id_version_instance");
            }
        } else {
            throw new JMXException("Access denied", "Permission denied to access MBean domain " + objName.getDomain());
        }
    }

    private void closeJMXConnector() {
        if (this.jmxConn != null) {
            try {
                this.jmxConn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.jmxConn = null;
        }
    }

    private void createAgentInfoV0_6_1_20() throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        String agentServiceId = "Agent";
        String rmiServiceId = RMI_SERVICE_ID;
        String version = (String)this.getAgentServiceProperty("Agent", "Version");
        String buildNumber = (String)this.getAgentServiceProperty("Agent", "BuildNumber");
        String host = (String)this.getAgentServiceProperty("Agent", "Host");
        String agentHome = (String)this.getAgentServiceProperty("Agent", "AgentHome");
        Date timeStarted = null;
        try {
            timeStarted = (Date)this.getAgentServiceProperty("Agent", "TimeStarted");
        }
        catch (Exception e) {
            // empty catch block
        }
        String rmiPort = (String)this.getAgentServiceProperty(RMI_SERVICE_ID, "Port");
        String osName = null;
        String osVersion = null;
        String osArch = null;
        ArrayList<PluginInfo> pluginInfos = new ArrayList<PluginInfo>(1);
        ArrayList<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>(1);
        try {
            osName = (String)this.getAgentServiceProperty("Agent", "OSName");
            osVersion = (String)this.getAgentServiceProperty("Agent", "OSVersion");
            osArch = (String)this.getAgentServiceProperty("Agent", "OSArchitecture");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.agentInfo = new AgentInfo(host, version, buildNumber, timeStarted, rmiPort, agentHome, osName, osVersion, osArch, pluginInfos, serviceInfos);
    }

    private Map<String, Object> createCredentialMap(char[] authorizationKey, char[] signature) {
        HashMap<String, Object> credentials = new HashMap<String, Object>();
        if (authorizationKey != null) {
            credentials.put("com.sybase.ua.security.authorization.key", authorizationKey);
        }
        if (signature != null) {
            credentials.put("com.sybase.ua.security.signature", signature);
        }
        return credentials;
    }

    private Map<String, Object> createCredentialMap(String username, Object password) {
        HashMap<String, Object> credentials = new HashMap<String, Object>();
        if (username != null) {
            credentials.put("com.sybase.ua.security.username", username);
        }
        if (password != null) {
            credentials.put("com.sybase.ua.security.password", password);
        }
        return credentials;
    }

    private void destroySession() throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        if (this.isAgentServiceAvailable("SecurityService")) {
            this.invokeAgentServiceMethod("SecurityService", "destroySession", new Object[]{this.sessionID}, new String[]{"java.lang.String"});
            this.sessionID = null;
            this.username = null;
        }
    }

    private Throwable extractUndeclaredCause(UndeclaredThrowableException ute) {
        Throwable te;
        Throwable t = ute.getUndeclaredThrowable();
        while (t != null && t instanceof UndeclaredThrowableException && (te = ((UndeclaredThrowableException)t).getUndeclaredThrowable()) != null) {
            t = te;
        }
        return t;
    }

    private Map<String, Object> getClientEnv() {
        HashMap<String, Object> clientEnv = new HashMap<String, Object>();
        try {
            String localhost = InetAddress.getLocalHost().getCanonicalHostName();
            clientEnv.put("com.sybase.ua.client.address", localhost);
        }
        catch (Exception e) {
            // empty catch block
        }
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String osVer = System.getProperty("os.version");
        clientEnv.put("com.sybase.ua.client.os", osName + " " + osVer + " " + osArch);
        String osUser = System.getProperty("user.name");
        clientEnv.put("com.sybase.ua.client.os.username", osUser);
        if (!this.isAnonymousUser()) {
            try {
                if (!this.isServerVersionOlderThan("1.5.0")) {
                    clientEnv.put("secure.connection", new Boolean(this.isSecureConnection()));
                    if (this.isSecureConnection()) {
                        clientEnv.put("encryption.algorithm", this.getEncryptionAlgorithm());
                        clientEnv.put("cipher.provider.class", this.getCipherProviderClass());
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
        }
        return clientEnv;
    }

    private MBeanServerConnection getMBeanServerConnection() throws JMXException {
        if (this.isTimedOut()) {
            throw new JMXException("Connection timed out", "Agent connection is timed out.");
        }
        if (this.jmxConn == null) {
            throw new JMXException("Connection lost", "JMX Connector is lost.");
        }
        try {
            return this.jmxConn.getMBeanServerConnection();
        }
        catch (IOException e) {
            throw new JMXException("Failed to connect to the agent server", "Failed to get MBeanServerConnection. " + e.getMessage());
        }
    }

    private void handShake() throws JMXException {
        AgentInfo agentServerInfo = null;
        try {
            AgentConnection aconn = AgentConnectionFactory.createAgentConnection(this.getAgentURLAsString());
            aconn.connect();
            agentServerInfo = aconn.getAgentInfo();
            aconn.disconnect();
        }
        catch (Exception e) {
            log.warn((Object)("Failed to obtain an anonymous connection: " + e.getMessage()), (Throwable)e);
        }
        if (agentServerInfo == null) {
            throw new JMXException("Cannot create secure connection.", "Handshake failed: Unable to retrieve AgentInfo anonymously");
        }
        ServiceInfo securityServiceInfo = agentServerInfo.getServiceInfo("SecurityService");
        if (securityServiceInfo == null) {
            throw new JMXException("Cannot create secure connection.", "Agent server does not have security service installed. Cannot make secure connection.");
        }
        String algorithm = (String)securityServiceInfo.getDiscoveryProperty("encryptionAlgorithm");
        String provider = (String)securityServiceInfo.getDiscoveryProperty("cipherProviderClass");
        try {
            CipherTool.validateAlgorithm(algorithm);
            CipherTool.validateProviderClass(provider);
        }
        catch (Exception e) {
            throw new JMXException("Cannot create secure connection.", e.getMessage());
        }
        this.setEncryptionAlgorithm(algorithm);
        this.setCipherProviderClass(provider);
    }

    private boolean isAnonymousUser() {
        return "anonymous".equals(this.getUsername());
    }

    private boolean isPrimordialResource(String resourceURLString) {
        boolean result = false;
        for (ResourceURL primordialRes : PRIMORDIAL_RESOURCES) {
            if (!resourceURLString.equals(primordialRes.getURL())) continue;
            result = true;
            break;
        }
        return result;
    }
}

