/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.connection;

import com.sybase.ua.AgentConnection;
import com.sybase.ua.ConnectionListener;
import com.sybase.ua.connection.AgentConnectionListener;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgentConnectionListenerImpl
implements AgentConnectionListener {
    private static Log log = LogFactory.getLog(AgentConnectionListenerImpl.class);
    private String sessionId;
    private long timeCreated;
    private long lastActivityTime;
    private transient AgentConnection agentConn;
    private final transient List<ConnectionListener> connectionListeners = new ArrayList<ConnectionListener>(1);

    public synchronized void addConnectionListener(ConnectionListener listener) {
        if (!this.connectionListeners.contains(listener)) {
            this.connectionListeners.add(listener);
        }
    }

    public void destroy() {
        try {
            UnicastRemoteObject.unexportObject(this, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public long getConnectionCreatedTime() throws RemoteException {
        return this.timeCreated;
    }

    @Override
    public long getConnectionLastActivityTime() throws RemoteException {
        if (this.agentConn != null) {
            this.lastActivityTime = this.agentConn.getLastActivityTime();
        }
        return this.lastActivityTime;
    }

    @Override
    public String getSessionId() throws RemoteException {
        return this.sessionId;
    }

    public void init(AgentConnection agentConn) {
        this.agentConn = agentConn;
        if (this.agentConn != null) {
            String sid = this.agentConn.getSessionID();
            if (sid != null) {
                this.sessionId = sid;
            }
            this.timeCreated = this.agentConn.getTimeCreated();
            this.lastActivityTime = this.agentConn.getLastActivityTime();
        }
        try {
            UnicastRemoteObject.exportObject(this);
        }
        catch (RemoteException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            } else {
                log.error((Object)e.getMessage());
            }
            throw new IllegalStateException("Failed to export AgentConnectionListener.  This typically indicates a build/packaging problem because the required RMI stub can not be found.", e);
        }
    }

    @Override
    public void onConnectionTimedOut() throws RemoteException {
        log.debug((Object)"Connection timed out.");
        if (this.agentConn != null) {
            this.agentConn.setTimedOut(true);
            this.agentConn.setConnected(false);
        }
        ArrayList<ConnectionListener> clonedListeners = new ArrayList<ConnectionListener>(1);
        clonedListeners.addAll(this.connectionListeners);
        for (ConnectionListener listener : clonedListeners) {
            listener.onConnectionTimedOut(this.agentConn);
        }
        this.destroy();
    }

    public synchronized void removeConnectionListener(ConnectionListener listener) {
        if (this.connectionListeners.contains(listener)) {
            this.connectionListeners.remove(listener);
        }
    }
}

