/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.connection;

import com.sybase.ua.security.crypto.SecureObject;
import java.io.Serializable;
import java.security.Principal;
import javax.management.remote.JMXPrincipal;

class AgentCredentials
implements Serializable {
    private static final long serialVersionUID = 5651416766598010925L;
    private final Principal _username;
    private final SecureObject _password;

    public static AgentCredentials createCredentials(String username, Serializable pwdObj, String encryptionAlgorithm, String cipherProviderClass) throws IllegalStateException {
        try {
            SecureObject securePwd = new SecureObject(pwdObj, encryptionAlgorithm, cipherProviderClass);
            return new AgentCredentials(new JMXPrincipal(username), securePwd);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create secure agent credentials.");
        }
    }

    public AgentCredentials(Principal username, SecureObject password) {
        this._username = username;
        this._password = password;
    }

    public Principal getUsername() {
        return this._username;
    }

    public SecureObject getPassword() {
        return this._password;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._username == null ? 0 : ((Object)this._username).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgentCredentials other = (AgentCredentials)obj;
        return !(this._username == null ? other._username != null : !((Object)this._username).equals(other._username));
    }

    public String toString() {
        return String.format("AgentCredentials [_username=%s]", this._username);
    }
}

