/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.connection;

import com.sybase.ua.AgentURL;
import com.sybase.ua.AuthenticationException;
import com.sybase.ua.AuthorizationException;
import com.sybase.ua.JMXException;
import com.sybase.ua.LoginModuleNotFoundException;
import com.sybase.ua.connection.ServerManagedSessionAgentConnection;
import com.sybase.ua.security.Pre30ResourceURL;
import com.sybase.ua.security.ResourceURL;
import javax.management.ObjectName;

class ClientManagedSessionAgentConnection
extends ServerManagedSessionAgentConnection {
    public ClientManagedSessionAgentConnection(AgentURL agentURL) {
        super(agentURL);
    }

    public ClientManagedSessionAgentConnection(String agentURL) {
        super(agentURL);
    }

    public ClientManagedSessionAgentConnection(String protocol, String host, int port) {
        super(protocol, host, port);
    }

    public ClientManagedSessionAgentConnection(String protocol, String host, String port) {
        super(protocol, host, port);
    }

    @Override
    protected Object doGetMBeanAttribute(ObjectName objName, String attributeName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        String normalizedAttributeName = this.normalizeAttributeName(objName, attributeName);
        ResourceURL resURL = ResourceURL.createResourceURL(objName, normalizedAttributeName);
        this.checkAccess(resURL, "read");
        return super.doGetMBeanAttribute(objName, normalizedAttributeName);
    }

    @Override
    protected Object doInvokeMBeanOperation(ObjectName objName, String operationName, Object[] paramValues, String[] paramTypes) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException {
        ResourceURL resURL = ResourceURL.createResourceURL(ResourceURL.ResourceFieldType.METHOD, objName, operationName, paramTypes);
        this.checkAccess(resURL, "execute");
        return super.doInvokeMBeanOperation(objName, operationName, paramValues, paramTypes);
    }

    @Override
    protected void doSetMBeanAttribute(ObjectName objName, String attributeName, Object attributeValue) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        String normalizedAttributeName = this.normalizeAttributeName(objName, attributeName);
        ResourceURL resURL = ResourceURL.createResourceURL(objName, normalizedAttributeName);
        this.checkAccess(resURL, "write");
        super.doSetMBeanAttribute(objName, normalizedAttributeName, attributeValue);
    }

    private void checkAccess(ResourceURL resource, String permission) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        String vresURL = resource.toString();
        if (this.getConnectionInfo().compareVersion(3, 0, 0) < 0) {
            vresURL = Pre30ResourceURL.convertResourceURL(resource);
        }
        if (!this.hasAccess(vresURL, permission)) {
            throw new AuthorizationException("User " + this.getUsername() + " does not have " + permission + " access to resource " + resource.getResourcePath());
        }
    }
}

