/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.connection;

import com.sybase.ua.AgentInfo;
import com.sybase.ua.ServiceInfo;
import com.sybase.ua.connection.JmxAgentConnection;
import com.sybase.ua.connection.JmxUtil;
import com.sybase.ua.migration.MalformatVersionException;
import com.sybase.ua.migration.Version;
import com.sybase.ua.services.security.tool.CipherTool;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;

class ConnectionInfo {
    private static final Map<JMXServiceURL, ConnectionInfo> AGENT_CONNECTION_INFO_CACHE = new HashMap<JMXServiceURL, ConnectionInfo>();
    private final JMXServiceURL _agentUrl;
    private AgentInfo _agentInfo;
    private boolean _supportsSSL = false;
    private boolean _supportsX509 = false;
    private boolean _supportsPKI = false;
    private boolean _requireSecureConnectionPassword = true;
    private String _encryptionAlgorithm = "DES";
    private String _cipherProviderClass = "com.sun.crypto.provider.SunJCE";
    private Map<String, Object> _clientEnvironmentMap;
    private final String _clientOSUsername = System.getProperty("user.name");
    private final String _clientOSName = System.getProperty("os.name");
    private final String _clientAddress = ConnectionInfo.getLocalHostName();
    private Long _clientHearbeatPeriod = 0L;
    private Long _clientConnectionTimeout = 0L;
    private long _serverTimeDiff = 0L;
    private final long _timeCreated = System.currentTimeMillis();
    private volatile long _lastActivityTime;
    private Version _agentVersion;

    public static ConnectionInfo getConnectionInfoPrototype(JMXServiceURL url) {
        ConnectionInfo info = AGENT_CONNECTION_INFO_CACHE.get(url);
        if (info == null) {
            info = ConnectionInfo.buildConnectionInfo(url);
            AGENT_CONNECTION_INFO_CACHE.put(url, info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ConnectionInfo buildConnectionInfo(JMXServiceURL url) {
        JMXConnector connector = null;
        try {
            connector = JmxAgentConnection.doAnonymousConnection(url);
            ConnectionInfo connectionInfo = ConnectionInfo.buildConnectionInfo(url, connector);
            return connectionInfo;
        }
        finally {
            if (connector != null) {
                try {
                    connector.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    static Long calculateServerTimeDiff(MBeanServerConnection mbsc) {
        Long serverTime = null;
        try {
            long start = System.currentTimeMillis();
            serverTime = (Long)mbsc.invoke(JmxUtil.getServiceObjectName("EnvironmentDiscoveryService"), "retrieveServerTime", null, null);
            long finish = System.currentTimeMillis();
            long elapsed = finish - start;
            return serverTime - elapsed / 2L;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    static String getLocalHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    private static ConnectionInfo buildConnectionInfo(JMXServiceURL url, JMXConnector connector) {
        try {
            MBeanServerConnection mbsc = connector.getMBeanServerConnection();
            ObjectName agentObjectName = JmxUtil.getServiceObjectName("Agent");
            AgentInfo agentInfo = (AgentInfo)mbsc.getAttribute(agentObjectName, "agentInfo");
            boolean supportsSecureConnectionPassword = true;
            ServiceInfo securityServiceInfo = agentInfo.getServiceInfo("SecurityService");
            String algorithm = null;
            String provider = null;
            if (securityServiceInfo == null) {
                supportsSecureConnectionPassword = false;
            } else {
                algorithm = (String)securityServiceInfo.getDiscoveryProperty("encryptionAlgorithm");
                provider = (String)securityServiceInfo.getDiscoveryProperty("cipherProviderClass");
                try {
                    CipherTool.validateAlgorithm(algorithm);
                    CipherTool.validateProviderClass(provider);
                }
                catch (Exception e) {
                    supportsSecureConnectionPassword = false;
                    algorithm = null;
                    provider = null;
                }
            }
            ConnectionInfo connInfo = new ConnectionInfo(url).setAgentInfo(agentInfo).setEncryptionAlgorithm(algorithm).setCipherProviderClass(provider).setRequireSecureConnectionPassword(supportsSecureConnectionPassword).setClientHearbeatPeriod(0L).setClientConnectionTimeout(0L).setSupportsSSL(false).setSupportsPKI(false).setSupportsX509(false).setServerTimeDiff(ConnectionInfo.calculateServerTimeDiff(mbsc)).updateLastActivityTime();
            return connInfo;
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
        catch (AttributeNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (MBeanException e) {
            throw new IllegalStateException(e);
        }
        catch (ReflectionException e) {
            throw new IllegalStateException(e);
        }
    }

    protected ConnectionInfo(ConnectionInfo prototype) {
        this._agentUrl = prototype.getAgentUrl();
        this.setAgentInfo(prototype.getAgentInfo()).setEncryptionAlgorithm(prototype.getEncryptionAlgorithm()).setCipherProviderClass(prototype.getCipherProviderClass()).setRequireSecureConnectionPassword(prototype.isRequireSecureConnectionPassword()).setClientHearbeatPeriod(prototype.getClientHearbeatPeriod()).setClientConnectionTimeout(prototype.getClientConnectionTimeout()).setClientEnvironmentMap(prototype.getClientEnvironmentMap()).setSupportsSSL(prototype.isSupportsSSL()).setSupportsPKI(prototype.isSupportsPKI()).setSupportsX509(prototype.isSupportsX509()).setServerTimeDiff(prototype.getServerTimeDiff()).updateLastActivityTime();
    }

    protected ConnectionInfo(JMXServiceURL url) {
        this._agentUrl = url;
    }

    public int compareVersion(int major, int minor, int micro) {
        Version cmpVersion = Version.createVersion(major, minor, micro);
        return this.getAgentVersion().compare(cmpVersion);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionInfo other = (ConnectionInfo)obj;
        return !(this._agentUrl == null ? other._agentUrl != null : !this._agentUrl.equals(other._agentUrl));
    }

    public AgentInfo getAgentInfo() {
        return this._agentInfo;
    }

    public JMXServiceURL getAgentUrl() {
        return this._agentUrl;
    }

    public Version getAgentVersion() {
        try {
            if (this._agentVersion == null) {
                this._agentVersion = Version.createVersion(this.getAgentInfo().getVersion());
            }
            return this._agentVersion;
        }
        catch (MalformatVersionException mfe) {
            throw new IllegalStateException(mfe);
        }
    }

    public String getCipherProviderClass() {
        return this._cipherProviderClass;
    }

    public String getClientAddress() {
        return this._clientAddress;
    }

    public Long getClientConnectionTimeout() {
        return this._clientConnectionTimeout;
    }

    public Long getClientHearbeatPeriod() {
        return this._clientHearbeatPeriod;
    }

    public String getClientOSName() {
        return this._clientOSName;
    }

    public String getClientOSUsername() {
        return this._clientOSUsername;
    }

    public String getEncryptionAlgorithm() {
        return this._encryptionAlgorithm;
    }

    public JMXServiceURL getJmxServiceUrl() {
        return this._agentUrl;
    }

    public long getLastActivityTime() {
        return this._lastActivityTime;
    }

    public long getServerTimeDiff() {
        return this._serverTimeDiff;
    }

    public long getTimeCreated() {
        return this._timeCreated;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._agentUrl == null ? 0 : this._agentUrl.hashCode());
        return result;
    }

    public boolean isRequireSecureConnectionPassword() {
        return this._requireSecureConnectionPassword;
    }

    public boolean isSupportsPKI() {
        return this._supportsPKI;
    }

    public boolean isSupportsSSL() {
        return this._supportsSSL;
    }

    public boolean isSupportsX509() {
        return this._supportsX509;
    }

    Map<String, Object> getClientEnvironmentMap() {
        if (this._clientEnvironmentMap == null || this._clientEnvironmentMap.isEmpty()) {
            this._clientEnvironmentMap = new HashMap<String, Object>();
            this._clientEnvironmentMap.put("com.sybase.ua.client.address", this.getClientAddress());
            this._clientEnvironmentMap.put("com.sybase.ua.client.os", this.getClientOSName());
            this._clientEnvironmentMap.put("com.sybase.ua.client.os.username", this.getClientOSUsername());
            this._clientEnvironmentMap.put("jmx.remote.x.client.connection.check.period", this.getClientHearbeatPeriod());
            this._clientEnvironmentMap.put("secure.connection", this.isRequireSecureConnectionPassword());
            if (this.isRequireSecureConnectionPassword()) {
                this._clientEnvironmentMap.put("encryption.algorithm", this.getEncryptionAlgorithm());
                this._clientEnvironmentMap.put("cipher.provider.class", this.getCipherProviderClass());
            }
        }
        return new HashMap<String, Object>(this._clientEnvironmentMap);
    }

    ConnectionInfo setAgentInfo(AgentInfo agentInfo) {
        this._agentInfo = agentInfo;
        return this;
    }

    ConnectionInfo setCipherProviderClass(String cipherProviderClass) {
        this._cipherProviderClass = cipherProviderClass;
        return this;
    }

    ConnectionInfo setClientConnectionTimeout(Long clientConnectionTimeout) {
        this._clientConnectionTimeout = clientConnectionTimeout;
        return this;
    }

    ConnectionInfo setClientEnvironmentMap(Map<String, Object> clientEnvironmentMap) {
        this._clientEnvironmentMap = clientEnvironmentMap;
        return this;
    }

    ConnectionInfo setClientHearbeatPeriod(Long clientHearbeatPeriod) {
        this._clientHearbeatPeriod = clientHearbeatPeriod;
        return this;
    }

    ConnectionInfo setEncryptionAlgorithm(String encryptionAlgorithm) {
        this._encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    ConnectionInfo setRequireSecureConnectionPassword(boolean requireSecureConnectionPassword) {
        this._requireSecureConnectionPassword = requireSecureConnectionPassword;
        return this;
    }

    ConnectionInfo setServerTimeDiff(long serverTimeDiff) {
        this._serverTimeDiff = serverTimeDiff;
        return this;
    }

    ConnectionInfo setSupportsPKI(boolean supportsPKI) {
        this._supportsPKI = supportsPKI;
        return this;
    }

    ConnectionInfo setSupportsSSL(boolean supportsSSL) {
        this._supportsSSL = supportsSSL;
        return this;
    }

    ConnectionInfo setSupportsX509(boolean supportsX509) {
        this._supportsX509 = supportsX509;
        return this;
    }

    ConnectionInfo updateClientEnvironmentMap(String key, Object value) {
        if (value != null) {
            this.getClientEnvironmentMap().put(key, value);
        } else {
            this.getClientEnvironmentMap().remove(key);
        }
        return this;
    }

    ConnectionInfo updateLastActivityTime() {
        this._lastActivityTime = System.currentTimeMillis();
        return this;
    }
}

