/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.connection;

import com.sybase.ua.AuthenticationException;
import com.sybase.ua.JMXException;
import com.sybase.ua.connection.AgentConnectionImpl;
import com.sybase.ua.connection.ConnectionCleanupHook;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.management.remote.JMXConnectorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ConnectionWorkingThread
extends Thread {
    public static final int STATUS_COMPLETED_SUCCESSFULLY = 0;
    public static final int STATUS_EXCEPTION_OCCURRED = 1;
    private static final Log log = LogFactory.getLog(ConnectionWorkingThread.class);
    private final AgentConnectionImpl agentConnection;
    private Map<String, Object> jmxConnectorMap;
    private final Map<String, Object> credentialMap;
    private final Object password;
    private int status = -1;
    private Exception exception;
    private final Object monitor;

    public ConnectionWorkingThread(AgentConnectionImpl agentConnection, Map<String, Object> jmxConnectorMap, Map<String, Object> credentialMap, Object password) {
        super("ConnectionWorkingThread");
        this.agentConnection = agentConnection;
        this.jmxConnectorMap = jmxConnectorMap;
        this.credentialMap = credentialMap;
        this.password = password;
        this.monitor = new Object();
    }

    public Exception getException() {
        return this.exception;
    }

    public Object getMonitor() {
        return this.monitor;
    }

    public int getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block24: {
            if (this.jmxConnectorMap == null) {
                this.jmxConnectorMap = new HashMap<String, Object>(1);
                this.jmxConnectorMap.put("jmx.remote.x.client.connection.check.period", new Long(0L));
            } else if (!this.jmxConnectorMap.containsKey("jmx.remote.x.client.connection.check.period")) {
                this.jmxConnectorMap.put("jmx.remote.x.client.connection.check.period", new Long(0L));
            }
            this.jmxConnectorMap.put("jmx.remote.credentials", this.credentialMap);
            try {
                this.agentConnection.jmxConn = JMXConnectorFactory.connect(this.agentConnection.getAgentURL().getJmxServiceURL(), this.jmxConnectorMap);
            }
            catch (IOException e) {
                this.status = 1;
                this.exception = new JMXException("Failed to connect to the agent server", "Failed to connect to " + this.agentConnection.getAgentURLAsString() + ". " + e.getMessage(), e);
                Object object = this.monitor;
                synchronized (object) {
                    this.monitor.notifyAll();
                }
                return;
            }
            catch (SecurityException e) {
                this.status = 1;
                this.exception = new AuthenticationException("Failed to connect to " + this.agentConnection.getAgentURLAsString() + ", probably because the agent is protected and requires credentials." + e.getMessage());
                Object object = this.monitor;
                synchronized (object) {
                    this.monitor.notifyAll();
                }
                return;
            }
            try {
                this.agentConnection.createSession(this.agentConnection.getUsername(), this.password);
                this.agentConnection.setConnected(true);
                this.agentConnection.createAgentInfo();
                if (this.agentConnection.isServerVersionOlderThan("1.5.0")) break block24;
                Long serverTime = null;
                try {
                    serverTime = (Long)this.agentConnection.invokeAgentServiceMethod("EnvironmentDiscoveryService", "retrieveServerTime", null, null);
                }
                catch (Exception ex) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Failed to retrieve the server time.  Using client time. " + ex.getMessage()));
                    }
                    serverTime = new Long(new Date().getTime());
                }
                this.agentConnection.timeCreated = new Date().getTime();
                this.agentConnection.serverTimeDiff = serverTime - this.agentConnection.timeCreated;
                this.agentConnection.lastActivityTime = new Date(this.agentConnection.timeCreated).getTime() + this.agentConnection.serverTimeDiff;
                this.agentConnection.setupConnectionListenerHook();
            }
            catch (Exception ex2) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Connection attempt failed with exception " + ex2.getMessage()), (Throwable)ex2);
                }
                this.status = 1;
                this.exception = ex2;
                Object object = this.monitor;
                synchronized (object) {
                    this.monitor.notifyAll();
                }
                return;
            }
        }
        this.agentConnection.setConnectionCleanupHook(new ConnectionCleanupHook(this.agentConnection));
        Runtime.getRuntime().addShutdownHook(this.agentConnection.getConnectionCleanupHook());
        this.status = 0;
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }
}

