/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.connection;

import com.sybase.ua.connection.AgentCredentials;
import com.sybase.ua.connection.ConnectionInfo;
import com.sybase.ua.connection.JmxConnectionException;
import com.sybase.ua.connection.JmxUtil;
import com.sybase.ua.connection.LegacyJmxAgentConnection;
import com.sybase.ua.connection.RuntimeJmxExceptionWrapper;
import com.sybase.ua.connection.RuntimeJmxMBeanOperationExceptionWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXPrincipal;
import javax.management.remote.JMXServiceURL;

class JmxAgentConnection {
    private final ConnectionInfo _connectionInfo;
    private AgentCredentials _agentCredentials;
    private final Stack<AgentCredentials> _additionalCredentials = new Stack();
    private final Map<String, Object> _jmxConnectorEnv;
    private final Map<String, Object> _clientEnvMap;
    private String _serverSessionId = null;
    private JMXConnector _jmxConnector;

    static AgentCredentials createCredentials(ConnectionInfo info, String username, Serializable pwdObj) throws IllegalStateException {
        return AgentCredentials.createCredentials(username, pwdObj, info.getEncryptionAlgorithm(), info.getCipherProviderClass());
    }

    static JMXConnector doAnonymousConnection(JMXServiceURL url) throws JmxConnectionException {
        HashMap<String, Object> credentialsMap = new HashMap<String, Object>();
        credentialsMap.put("com.sybase.ua.security.username", new JMXPrincipal("anonymous"));
        credentialsMap.put("com.sybase.ua.security.password", new char[0]);
        HashMap<String, HashMap<String, Object>> jmxConnectionEnv = new HashMap<String, HashMap<String, Object>>();
        jmxConnectionEnv.put("jmx.remote.credentials", credentialsMap);
        try {
            return JMXConnectorFactory.connect(url, jmxConnectionEnv);
        }
        catch (IOException e) {
            throw new JmxConnectionException(url, "Failed to make an anonymous connection to the server", e);
        }
    }

    static JmxAgentConnection doConnect(ConnectionInfo info, AgentCredentials credentials, Map<String, Object> jmxConnectionEnv) throws SecurityException, IllegalStateException {
        JmxAgentConnection connection = null;
        connection = info.compareVersion(3, 1, 1) >= 0 ? new JmxAgentConnection(info, credentials, jmxConnectionEnv) : new LegacyJmxAgentConnection(info, credentials, jmxConnectionEnv);
        connection.connect();
        return connection;
    }

    static JmxAgentConnection doConnect(ConnectionInfo info, String username, Serializable pwd, Map<String, Object> jmxConnectionEnv) {
        AgentCredentials creds = JmxAgentConnection.createCredentials(info, username, pwd);
        return JmxAgentConnection.doConnect(info, creds, jmxConnectionEnv);
    }

    static JmxAgentConnection doConnect(JMXServiceURL url, String username, Serializable pwd) {
        return JmxAgentConnection.doConnect(url, username, pwd, null);
    }

    static JmxAgentConnection doConnect(JMXServiceURL url, String username, Serializable pwd, Map<String, Object> jmxConnectionEnv) {
        ConnectionInfo info = ConnectionInfo.getConnectionInfoPrototype(url);
        return JmxAgentConnection.doConnect(info, username, pwd, jmxConnectionEnv);
    }

    protected static JMXConnector doJmxConnection(JMXServiceURL jmxUrl, Map<String, Object> credentialsMap, Map<String, Object> jmxConnectionEnv) throws IOException {
        jmxConnectionEnv.put("jmx.remote.credentials", credentialsMap);
        return JMXConnectorFactory.connect(jmxUrl, jmxConnectionEnv);
    }

    public JmxAgentConnection(ConnectionInfo connectionInfo, AgentCredentials credentials) {
        this(connectionInfo, credentials, new HashMap<String, Object>());
    }

    public JmxAgentConnection(ConnectionInfo connectionInfo, AgentCredentials credentials, Map<String, Object> jmxConnectionEnv) {
        this._connectionInfo = connectionInfo;
        this._agentCredentials = credentials;
        this._jmxConnectorEnv = jmxConnectionEnv != null ? new HashMap<String, Object>(jmxConnectionEnv) : new HashMap();
        this._clientEnvMap = this._connectionInfo.getClientEnvironmentMap();
    }

    public void checkConnection() throws IllegalStateException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Connection not available.");
        }
    }

    public void connect() throws SecurityException {
        this.doConnect(this.getCurrentCredentials());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        try {
            JMXConnector connector = this.getJmxConnector();
            if (connector != null) {
                connector.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this._jmxConnector = null;
            this._serverSessionId = null;
        }
    }

    public ConnectionInfo getConnectionInfo() {
        return this._connectionInfo;
    }

    public JMXConnector getJmxConnector() {
        return this._jmxConnector;
    }

    public MBeanServerConnection getMBeanServerConnection() {
        try {
            return this._jmxConnector.getMBeanServerConnection();
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable");
        }
    }

    public boolean isConnected() {
        try {
            if (this._jmxConnector == null) {
                return false;
            }
            this._jmxConnector.getConnectionId();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void login(AgentCredentials credentials) throws SecurityException {
        if (!this.isConnected()) {
            this._agentCredentials = credentials;
            this.connect();
        } else {
            if (this.hasCredentials(credentials)) {
                return;
            }
            this._additionalCredentials.push(credentials);
            Object[] params = new Object[]{this.getServerSessionId(), credentials.getUsername().getName(), credentials.getPassword()};
            String[] paramTypes = new String[]{"java.lang.String", "java.lang.String", credentials.getPassword().getClass().getName()};
            try {
                this.getMBeanServerConnection().invoke(JmxUtil.getServiceObjectName("SecurityService"), "login", params, paramTypes);
            }
            catch (InstanceNotFoundException e) {
                throw new IllegalStateException(e);
            }
            catch (MBeanException e) {
                throw new IllegalStateException(e.getCause());
            }
            catch (ReflectionException e) {
                throw new IllegalStateException(e.getCause());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void logout() {
        if (!this.isConnected()) {
            return;
        }
        if (!this._additionalCredentials.isEmpty()) {
            this._additionalCredentials.pop();
        }
        try {
            this.getMBeanServerConnection().invoke(JmxUtil.getServiceObjectName("SecurityService"), "logout", new Object[]{this.getServerSessionId()}, new String[]{"java.lang.String"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String getClientSessionId() {
        try {
            return this._jmxConnector != null ? this._jmxConnector.getConnectionId() : null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    String getCurrentUsername() {
        AgentCredentials creds = this.getCurrentCredentials();
        return creds != null ? creds.getUsername().getName() : null;
    }

    String getServerSessionId() {
        return this._serverSessionId;
    }

    protected String acquireServerSessionId() throws IOException {
        try {
            return (String)this.getMBeanServerConnection().invoke(JmxUtil.getServiceObjectName("SessionService"), "findServerSessionForClient", new Object[0], new String[0]);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanOperationExceptionWrapper(JmxUtil.getServiceObjectName("SessionService"), "findServerSessionForClient", new String[0], e);
        }
    }

    protected void doConnect(AgentCredentials credentials) {
        if (this.isConnected()) {
            throw new IllegalStateException("Client is already connected.");
        }
        JMXServiceURL jmxUrl = this._connectionInfo.getJmxServiceUrl();
        try {
            HashMap<String, Object> credentialsMap = new HashMap<String, Object>();
            credentialsMap.put("com.sybase.ua.security.username", credentials.getUsername());
            credentialsMap.put("com.sybase.ua.security.password", credentials.getPassword());
            credentialsMap.put("com.sybase.ua.security.clientenv", this._clientEnvMap);
            this._jmxConnector = JmxAgentConnection.doJmxConnection(jmxUrl, credentialsMap, this._jmxConnectorEnv);
            this._jmxConnector.addConnectionNotificationListener(new JmxAgentConnectionNotificationListener(this), null, null);
            this._serverSessionId = this.acquireServerSessionId();
        }
        catch (RuntimeJmxExceptionWrapper mbe) {
            throw new JmxConnectionException(jmxUrl, "Failed to acquire required server session id: " + mbe.getCause().getMessage(), mbe.getCause());
        }
        catch (IOException ioe) {
            throw new JmxConnectionException(jmxUrl, "Connection to remote agent failed: " + ioe.getMessage());
        }
    }

    protected AgentCredentials getCurrentCredentials() {
        if (!this._additionalCredentials.isEmpty()) {
            return this._additionalCredentials.peek();
        }
        return this._agentCredentials;
    }

    protected boolean hasCredentials(AgentCredentials credentials) {
        return this._agentCredentials.equals(credentials) || this._additionalCredentials.search(credentials) != -1;
    }

    private static class JmxAgentConnectionNotificationListener
    implements NotificationListener,
    NotificationFilter {
        private static final long serialVersionUID = -4117581172377315850L;
        private final JmxAgentConnection _jmxConnection;

        JmxAgentConnectionNotificationListener(JmxAgentConnection jmxConnection) {
            this._jmxConnection = jmxConnection;
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (!(notification instanceof JMXConnectionNotification)) {
                return;
            }
            if (!notification.getType().equals("jmx.remote.connection.closed")) {
                return;
            }
            String jmxConnId = ((JMXConnectionNotification)notification).getConnectionId();
            String currentConnectionId = this._jmxConnection.getClientSessionId();
            if (currentConnectionId == null) {
                return;
            }
            if (currentConnectionId.equalsIgnoreCase(jmxConnId)) {
                this._jmxConnection.disconnect();
            }
        }

        @Override
        public boolean isNotificationEnabled(Notification notification) {
            if (!(notification instanceof JMXConnectionNotification)) {
                return false;
            }
            return notification.getType().equals("jmx.remote.connection.closed");
        }
    }
}

