/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.connection;

import com.sybase.ua.util.AgentClientUtil;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Hashtable;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public enum JmxUtil {
    INSTANCE;


    public static void checkConnection(MBeanServerConnection mbsc) throws IllegalArgumentException {
        if (mbsc == null) {
            throw new IllegalArgumentException("Connection unavailable (null)");
        }
        try {
            mbsc.getDefaultDomain();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Connection unavailable");
        }
    }

    public static final ObjectName createObjectName(String name) throws IllegalArgumentException {
        try {
            return ObjectName.getInstance(name);
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException(mone);
        }
    }

    public static final ObjectName createObjectName(String domain, Hashtable<String, String> nameProps) throws IllegalArgumentException {
        try {
            return ObjectName.getInstance(domain, nameProps);
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException(mone);
        }
    }

    public static final ObjectName createObjectName(String domain, String key, String value) throws IllegalArgumentException {
        try {
            return new ObjectName(domain, key, value);
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException(mone);
        }
    }

    public static Throwable extractUndeclaredCause(UndeclaredThrowableException ute) {
        Throwable te;
        Throwable t = ute.getUndeclaredThrowable();
        while (t != null && t instanceof UndeclaredThrowableException && (te = ((UndeclaredThrowableException)t).getUndeclaredThrowable()) != null) {
            t = te;
        }
        return t;
    }

    public static final ObjectName getPluginObjectName(String pluginId, String version, int instanceNumber) throws IllegalArgumentException {
        try {
            return AgentClientUtil.getPluginObjectName(pluginId, version, instanceNumber);
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException(mone);
        }
    }

    public static final ObjectName getServiceObjectName(String serviceId) throws IllegalArgumentException {
        try {
            return AgentClientUtil.getServiceObjectName(serviceId);
        }
        catch (MalformedObjectNameException mone) {
            throw new IllegalArgumentException(mone);
        }
    }
}

