/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.connection;

import com.sybase.ua.connection.RuntimeJmxMBeanAttributeExceptionWrapper;
import com.sybase.ua.connection.RuntimeJmxMBeanOperationExceptionWrapper;
import com.sybase.ua.connection.RuntimeJmxMBeanServerOperationExceptionWrapper;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;

class MBeanServerConnectionDelegate
implements MBeanServerConnection {
    private final MBeanServerConnection _connection;

    public MBeanServerConnectionDelegate(MBeanServerConnection conn) {
        this._connection = conn;
    }

    public static void checkConnection(MBeanServerConnection mbsc) throws IllegalStateException {
        if (mbsc == null) {
            throw new IllegalStateException("Connection unavailable (null)");
        }
        try {
            mbsc.getDefaultDomain();
        }
        catch (Exception e) {
            throw new IllegalStateException("Connection unavailable");
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        try {
            this._connection.addNotificationListener(name, listener, filter, handback);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeJmxMBeanOperationExceptionWrapper(name, "addNotificationListener", new String[]{NotificationListener.class.getName(), NotificationFilter.class.getName(), Object.class.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) {
        try {
            this._connection.addNotificationListener(name, listener, filter, handback);
        }
        catch (InstanceNotFoundException e) {
            throw new RuntimeJmxMBeanOperationExceptionWrapper(name, "addNotificationListener", new String[]{ObjectName.class.getName(), NotificationFilter.class.getName(), Object.class.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) {
        try {
            return this._connection.createMBean(className, name, params, signature);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanServerOperationExceptionWrapper(name, "createMBean", new String[]{String.class.getName(), ObjectName.class.getName(), Object[].class.getName(), String[].class.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) {
        try {
            return this._connection.createMBean(className, name, loaderName, params, signature);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanServerOperationExceptionWrapper(name, "createMBean", new String[]{String.class.getName(), ObjectName.class.getName(), ObjectName.class.getName(), Object[].class.getName(), String[].class.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) {
        try {
            return this._connection.createMBean(className, name, loaderName);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanServerOperationExceptionWrapper(name, "createMBean", new String[]{String.class.getName(), ObjectName.class.getName(), ObjectName.class.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) {
        try {
            return this._connection.createMBean(className, name);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanServerOperationExceptionWrapper(name, "createMBean", new String[]{String.class.getName(), ObjectName.class.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) {
        try {
            return this._connection.getAttribute(name, attribute);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanAttributeExceptionWrapper(name, new String[]{attribute}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) {
        try {
            return this._connection.getAttributes(name, attributes);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanAttributeExceptionWrapper(name, attributes, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public String getDefaultDomain() {
        try {
            return this._connection.getDefaultDomain();
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public String[] getDomains() {
        try {
            return this._connection.getDomains();
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public Integer getMBeanCount() {
        try {
            return this._connection.getMBeanCount();
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) {
        try {
            return this._connection.getMBeanInfo(name);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanServerOperationExceptionWrapper(name, "getMBeanInfo", new String[]{ObjectName.class.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) {
        try {
            return this._connection.getObjectInstance(name);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanServerOperationExceptionWrapper(name, "getObjectInstance", new String[]{ObjectName.class.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) {
        try {
            return this._connection.invoke(name, operationName, params, signature);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanOperationExceptionWrapper(name, operationName, signature, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) {
        try {
            return this._connection.isInstanceOf(name, className);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanServerOperationExceptionWrapper(name, "isInstanceOf", new String[]{ObjectName.class.getName(), String.class.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public boolean isRegistered(ObjectName name) throws IOException {
        try {
            return this._connection.isRegistered(name);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        try {
            return this._connection.queryMBeans(name, query);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        try {
            return this._connection.queryNames(name, query);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        try {
            this._connection.removeNotificationListener(name, listener, filter, handback);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanOperationExceptionWrapper(name, "removeNotificationListener", new String[]{ObjectName.class.getName(), NotificationListener.class.getName(), NotificationFilter.class.getName(), Object.class.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) {
        try {
            this._connection.removeNotificationListener(name, listener);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanOperationExceptionWrapper(name, "removeNotificationListener", new String[]{ObjectName.class.getName(), NotificationListener.class.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) {
        try {
            this._connection.removeNotificationListener(name, listener, filter, handback);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanOperationExceptionWrapper(name, "removeNotificationListener", new String[]{ObjectName.class.getName(), ObjectName.class.getName(), NotificationFilter.class.getName(), Object.class.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) {
        try {
            this._connection.removeNotificationListener(name, listener);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanOperationExceptionWrapper(name, "removeNotificationListener", new String[]{ObjectName.class.getName(), ObjectName.class.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) {
        try {
            this._connection.setAttribute(name, attribute);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanAttributeExceptionWrapper(name, new String[]{attribute.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) {
        try {
            return this._connection.setAttributes(name, attributes);
        }
        catch (JMException e) {
            LinkedList<String> attnames = new LinkedList<String>();
            for (Attribute att : attributes) {
                attnames.add(att.getName());
            }
            throw new RuntimeJmxMBeanAttributeExceptionWrapper(name, attnames.toArray(new String[attnames.size()]), e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }

    @Override
    public void unregisterMBean(ObjectName name) {
        try {
            this._connection.unregisterMBean(name);
        }
        catch (JMException e) {
            throw new RuntimeJmxMBeanServerOperationExceptionWrapper(name, "unregisterMBean", new String[]{ObjectName.class.getName()}, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Connection unavailable", e);
        }
    }
}

