/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.connection;

import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentInfo;
import com.sybase.ua.AgentURL;
import com.sybase.ua.AuthenticationException;
import com.sybase.ua.AuthorizationException;
import com.sybase.ua.ConnectionListener;
import com.sybase.ua.InvalidAgentURLException;
import com.sybase.ua.JMXException;
import com.sybase.ua.LoginModuleNotFoundException;
import com.sybase.ua.PluginInfo;
import com.sybase.ua.ServiceInfo;
import com.sybase.ua.connection.AgentConnectionListener;
import com.sybase.ua.connection.AgentConnectionListenerImpl;
import com.sybase.ua.connection.ConnectionInfo;
import com.sybase.ua.connection.JmxAgentConnection;
import com.sybase.ua.connection.JmxUtil;
import com.sybase.ua.plugin.AgentPluginException;
import com.sybase.ua.plugin.AgentPluginMBean;
import com.sybase.ua.service.AgentServiceMBean;
import com.sybase.ua.util.AgentClientUtil;
import com.sybase.ua.util.StringUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMX;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.remote.JMXServiceURL;

class ServerManagedSessionAgentConnection
implements AgentConnection {
    private static final String INVALID_PLUGIN_OBJECT_NAME_FORMAT_MSG = "Complete plugin object name specification is invalid: {0}The plugin id specification format is: pluginId_pluginVersion_pluginInstance.";
    private final AgentURL agentURL;
    private final AgentConnectionListener connectionListenerHook;
    private final ConnectionInfo _agentConnectionInfo;
    private JmxAgentConnection _jmxConnection;

    protected static void throwJMXException(Throwable t) throws AuthenticationException, AuthorizationException, JMXException {
        try {
            if (t instanceof UndeclaredThrowableException) {
                throw JmxUtil.extractUndeclaredCause((UndeclaredThrowableException)t);
            }
            if (t instanceof InvocationTargetException) {
                throw t.getCause();
            }
            throw t;
        }
        catch (MBeanException e) {
            Exception targetException = e.getTargetException();
            if (targetException instanceof AuthenticationException) {
                throw (AuthenticationException)targetException;
            }
            throw new JMXException("Other MBean exception", targetException.getMessage(), targetException);
        }
        catch (AuthenticationException auth) {
            throw auth;
        }
        catch (AuthorizationException auth) {
            throw auth;
        }
        catch (LoginModuleNotFoundException loginmod) {
            throw new JMXException("Access denied", "Login module not found.");
        }
        catch (MalformedObjectNameException e) {
            throw new JMXException("Malformed MBean name", e.getMessage(), e);
        }
        catch (InstanceNotFoundException e) {
            throw new JMXException("MBean instance not found", e.getMessage(), e);
        }
        catch (AttributeNotFoundException e) {
            throw new JMXException("Attribute not found", e.getMessage(), e);
        }
        catch (InvalidAttributeValueException e) {
            throw new JMXException("Invalid attribute value", e.getMessage(), e);
        }
        catch (ReflectionException e) {
            throw new JMXException("Reflection Exception", e.getMessage(), e);
        }
        catch (IOException e) {
            throw new JMXException("IO Exception", e.getMessage(), e);
        }
        catch (Throwable t2) {
            throw new JMXException("Other MBean exception", t2.getMessage(), t2);
        }
    }

    public ServerManagedSessionAgentConnection(AgentURL agentURL) {
        this.agentURL = agentURL;
        this.connectionListenerHook = new AgentConnectionListenerImpl();
        this._agentConnectionInfo = ConnectionInfo.getConnectionInfoPrototype(this.agentURL.getJmxServiceURL());
    }

    public ServerManagedSessionAgentConnection(String agentURL) {
        this(AgentURL.createAgentURL(agentURL));
    }

    public ServerManagedSessionAgentConnection(String protocol, String host, int port) {
        this(AgentURL.createAgentURL(protocol, host, port));
    }

    public ServerManagedSessionAgentConnection(String protocol, String host, String port) {
        this(protocol, host, Integer.valueOf(port));
    }

    @Override
    public void addConnectionListener(ConnectionListener listener) {
        AgentConnectionListenerImpl connectionListenerHookImpl = (AgentConnectionListenerImpl)this.connectionListenerHook;
        connectionListenerHookImpl.addConnectionListener(listener);
    }

    @Override
    public void connect() throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException, InvalidAgentURLException {
        this.connect("anonymous", "".toCharArray());
    }

    @Override
    @Deprecated
    public void connect(char[] authorizationKey, char[] signature) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException, InvalidAgentURLException {
        this.connect(authorizationKey, signature, null);
    }

    @Override
    @Deprecated
    public void connect(char[] authorizationKey, char[] signature, Map<String, Object> jmxConnectorMap) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException, InvalidAgentURLException {
        throw new UnsupportedOperationException("The server does not currently support authorization key and signature based authentication");
    }

    @Override
    public void connect(long clientHeartbeatPeriod) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException, InvalidAgentURLException {
        HashMap<String, Object> jmxConnectorMap = new HashMap<String, Object>(1);
        jmxConnectorMap.put("jmx.remote.x.client.connection.check.period", clientHeartbeatPeriod);
        this.connect("anonymous", null, jmxConnectorMap);
    }

    @Override
    public void connect(Map<String, Object> credentialMap) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException, InvalidAgentURLException {
        this.connect(credentialMap, null);
    }

    @Override
    public void connect(Map<String, Object> credentialMap, Map<String, Object> jmxConnectorMap) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException, InvalidAgentURLException {
        if (this.isConnected()) {
            return;
        }
        if (credentialMap == null) {
            this.connect("anonymous", null, jmxConnectorMap);
        } else if (credentialMap.containsKey("username")) {
            this._jmxConnection = JmxAgentConnection.doConnect(this.getConnectionInfo(), credentialMap.get("username").toString(), (Serializable)credentialMap.get("password"), jmxConnectorMap);
        } else {
            if (credentialMap.containsKey("authorizationkey")) {
                throw new UnsupportedOperationException("The server does not currently support authorization key and signature based authentication");
            }
            this._jmxConnection = JmxAgentConnection.doConnect(this.getConnectionInfo(), "anonymous", (Serializable)new char[0], jmxConnectorMap);
        }
    }

    @Override
    public void connect(String username, char[] password) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException, InvalidAgentURLException {
        this.connect(username, password, null);
    }

    @Override
    public void connect(String username, char[] passwd, Map<String, Object> jmxConnectorMap) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException, InvalidAgentURLException {
        if (this.isConnected()) {
            return;
        }
        this._jmxConnection = JmxAgentConnection.doConnect(this.getConnectionInfo(), username, (Serializable)passwd, jmxConnectorMap);
    }

    @Override
    public void disconnect() throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        if (!this.isConnected()) {
            return;
        }
        this._jmxConnection.disconnect();
        if (this.connectionListenerHook != null) {
            try {
                ((AgentConnectionListenerImpl)this.connectionListenerHook).destroy();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public AgentInfo getAgentInfo() throws AuthenticationException, AuthorizationException, JMXException {
        return this.getConnectionInfo().getAgentInfo();
    }

    @Override
    public AgentInfo getAgentInfo(boolean cached) throws AuthenticationException, AuthorizationException, JMXException {
        try {
            if (cached) {
                return this.getAgentInfo();
            }
            if (this.isConnected()) {
                AgentInfo agentInfo = (AgentInfo)this.getAgentServiceProperty("Agent", "agentInfo");
                this.getConnectionInfo().setAgentInfo(agentInfo);
                return agentInfo;
            }
            return null;
        }
        catch (LoginModuleNotFoundException e) {
            throw new IllegalStateException("Server login modules are not configured properly.  Please contact your server administrator.");
        }
    }

    public String getAgentPluginIdFromObjectNameString(String id_version_instance) throws AgentPluginException {
        return this.splitPluginObjectNameString(id_version_instance)[0];
    }

    @Override
    public List<String> getAgentPluginIds() throws AuthenticationException, AuthorizationException, JMXException {
        ArrayList<String> pluginIds = new ArrayList<String>(3);
        List<PluginInfo> pis = this.getAgentInfo().getPluginInfos();
        for (PluginInfo pi : pis) {
            pluginIds.add(pi.getId());
        }
        Collections.sort(pluginIds);
        return pluginIds;
    }

    public String getAgentPluginInstanceFromObjectNameString(String id_version_instance) throws AgentPluginException {
        return this.splitPluginObjectNameString(id_version_instance)[2];
    }

    @Override
    public int[] getAgentPluginInstanceNumbers(String pluginId, String pluginVersion) throws AuthenticationException, AuthorizationException, JMXException {
        List<PluginInfo> pis = this.getAgentInfo().getPluginInfos(pluginId, pluginVersion);
        int[] pluginInstances = new int[pis.size()];
        int i = 0;
        for (PluginInfo pi : pis) {
            pluginInstances[i++] = pi.getInstanceNumber();
        }
        Arrays.sort(pluginInstances);
        return pluginInstances;
    }

    @Override
    public String getAgentPluginLatestVersion(String pluginId) throws AuthenticationException, AuthorizationException, JMXException {
        List<String> versions = this.getAgentPluginVersions(pluginId);
        if (versions.isEmpty()) {
            throw new JMXException("Plugin version not found", "No versions are found with plugin id " + pluginId);
        }
        String latestVersion = versions.get(versions.size() - 1);
        return latestVersion;
    }

    @Override
    public List<String> getAgentPluginMBeanNames() throws AuthenticationException, AuthorizationException, JMXException {
        this._jmxConnection.checkConnection();
        ArrayList<String> mbeanNames = new ArrayList<String>();
        ObjectName objNamePattern = JmxUtil.createObjectName("AgentPlugin:*");
        for (ObjectName objName : this.queryMBeans(objNamePattern, null)) {
            String mbeanName = ((Object)objName).toString();
            mbeanNames.add(mbeanName);
        }
        Collections.sort(mbeanNames);
        return mbeanNames;
    }

    @Override
    public Map<String, Object> getAgentPluginProperties(String mbeanName) throws AuthenticationException, AuthorizationException, JMXException {
        TreeMap<String, Object> properties = new TreeMap<String, Object>();
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        if (mbeanServerConn == null) {
            return properties;
        }
        ObjectName objName = JmxUtil.createObjectName(mbeanName);
        AttributeList mbeanAttributeList = this.getMBeanAttributes(objName);
        for (Attribute att : mbeanAttributeList.asList()) {
            properties.put(att.getName(), att.getValue());
        }
        return properties;
    }

    @Override
    public Map<String, Object> getAgentPluginProperties(String pluginId, String pluginVersion, int instanceNumber) throws AuthenticationException, AuthorizationException, JMXException {
        String mbeanName = AgentClientUtil.getPluginMBeanName(pluginId, pluginVersion, instanceNumber);
        return this.getAgentPluginProperties(mbeanName);
    }

    @Override
    public Object getAgentPluginProperty(String mbeanName, String propertyName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = JmxUtil.createObjectName(mbeanName);
        return this.getMBeanAttribute(objName, propertyName);
    }

    @Override
    public Object getAgentPluginProperty(String pluginId, String pluginVersion, int instanceNumber, String propertyName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = JmxUtil.getPluginObjectName(pluginId, pluginVersion, instanceNumber);
        return this.getMBeanAttribute(objName, propertyName);
    }

    @Override
    public List<String> getAgentPluginPropertyNames(String mbeanName) throws AuthenticationException, AuthorizationException, JMXException {
        ArrayList<String> propertyNames = new ArrayList<String>(this.getAgentPluginProperties(mbeanName).keySet());
        Collections.sort(propertyNames);
        return propertyNames;
    }

    @Override
    public List<String> getAgentPluginPropertyNames(String pluginId, String pluginVersion, int instanceNumber) throws AuthenticationException, AuthorizationException, JMXException {
        String mbeanName = AgentClientUtil.getPluginMBeanName(pluginId, pluginVersion, instanceNumber);
        return this.getAgentPluginPropertyNames(mbeanName);
    }

    public String getAgentPluginVersionFromObjectNameString(String id_version_instance) throws AgentPluginException {
        return this.splitPluginObjectNameString(id_version_instance)[1];
    }

    @Override
    public List<String> getAgentPluginVersions(String pluginId) throws AuthenticationException, AuthorizationException, JMXException {
        ArrayList<String> pluginVersions = new ArrayList<String>(3);
        List<PluginInfo> pis = this.getAgentInfo().getPluginInfos();
        for (PluginInfo pi : pis) {
            if (!pi.getId().equals(pluginId)) continue;
            pluginVersions.add(pi.getVersion());
        }
        Collections.sort(pluginVersions);
        return pluginVersions;
    }

    @Override
    public List<String> getAgentServiceIds() throws AuthenticationException, AuthorizationException, JMXException {
        ArrayList<String> serviceIds = new ArrayList<String>();
        for (ServiceInfo si : this.getAgentInfo().getServiceInfos()) {
            serviceIds.add(si.getId());
        }
        Collections.sort(serviceIds);
        return serviceIds;
    }

    @Override
    public List<String> getAgentServiceMBeanNames() throws AuthenticationException, AuthorizationException, JMXException {
        this._jmxConnection.checkConnection();
        ArrayList<String> mbeanNames = new ArrayList<String>();
        ObjectName objNamePattern = JmxUtil.createObjectName("AgentService:*");
        for (ObjectName objName : this.queryMBeans(objNamePattern, null)) {
            String mbeanName = objName.toString();
            mbeanNames.add(mbeanName);
        }
        Collections.sort(mbeanNames);
        return mbeanNames;
    }

    @Override
    public Object getAgentServiceProperty(String serviceId, String propertyName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = JmxUtil.getServiceObjectName(serviceId);
        return this.getMBeanAttribute(objName, propertyName);
    }

    @Override
    public Object getAgentServicePropertyByMBeanName(String mbeanName, String propertyName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = JmxUtil.createObjectName(mbeanName);
        return this.getMBeanAttribute(objName, propertyName);
    }

    @Override
    public AgentURL getAgentURL() {
        return this.agentURL;
    }

    @Override
    public String getAgentURLAsString() {
        return this.getAgentURLLongFormatAsString();
    }

    @Override
    public String getAgentURLLongFormatAsString() {
        return this.agentURL.getURLLongFormat();
    }

    @Override
    public String getAgentURLShortFormatAsString() {
        return this.agentURL.getURLShortFormat();
    }

    @Override
    public String getCipherProviderClass() {
        return this.getConnectionInfo().getCipherProviderClass();
    }

    @Override
    public long getClientConnectionTimeout() {
        return this.getConnectionInfo().getClientConnectionTimeout();
    }

    @Override
    public String getCurrentSecurityModule() throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        String moduleName = (String)this.invokeAgentServiceMethod("SecurityService", "getCurrentSecurityModule", new Object[]{this.getSessionID()}, new String[]{"java.lang.String"});
        return moduleName;
    }

    @Override
    public String[] getDomains() throws JMXException {
        try {
            return this.getMBeanServerConnection().getDomains();
        }
        catch (IOException e) {
            throw new JMXException("IO Exception", e.getMessage());
        }
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.getConnectionInfo().getEncryptionAlgorithm();
    }

    @Override
    public JMXServiceURL getJMXServiceURL() {
        return this.agentURL.getJmxServiceURL();
    }

    @Override
    public long getLastActivityTime() {
        return this.getConnectionInfo().getLastActivityTime();
    }

    @Override
    public Object getMBeanAttribute(ObjectName objName, String attributeName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        return this.doGetMBeanAttribute(objName, attributeName);
    }

    @Override
    public Object getMBeanAttribute(String mbeanName, String attributeName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = JmxUtil.createObjectName(mbeanName);
        return this.getMBeanAttribute(objName, attributeName);
    }

    public List<String> getMBeanAttributeNames(ObjectName objectName) throws JMXException {
        MBeanAttributeInfo[] attributeInfos;
        ArrayList<String> attributeNames = new ArrayList<String>();
        MBeanInfo mbeanInfo = this.getMBeanInfo(objectName);
        for (MBeanAttributeInfo attributeInfo : attributeInfos = mbeanInfo.getAttributes()) {
            String name = attributeInfo.getName();
            attributeNames.add(name);
        }
        return attributeNames;
    }

    public AttributeList getMBeanAttributes(ObjectName name) throws AuthenticationException, AuthorizationException, JMXException {
        List<String> attributeNames = this.getMBeanAttributeNames(name);
        return this.getMBeanAttributes(name, attributeNames);
    }

    public AttributeList getMBeanAttributes(ObjectName name, List<String> attributeNames) throws AuthenticationException, AuthorizationException, JMXException {
        return this.getMBeanAttributes(name, attributeNames.toArray(new String[attributeNames.size()]));
    }

    public AttributeList getMBeanAttributes(ObjectName name, String ... attributeNames) throws AuthenticationException, AuthorizationException, JMXException {
        try {
            return this.getMBeanServerConnection().getAttributes(name, attributeNames);
        }
        catch (Exception e) {
            ServerManagedSessionAgentConnection.throwJMXException(e);
            return null;
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objName) throws JMXException {
        try {
            return this.getMBeanServerConnection().getMBeanInfo(objName);
        }
        catch (InstanceNotFoundException e) {
            throw new JMXException("MBean instance not found", e);
        }
        catch (IntrospectionException e) {
            throw new JMXException("Introspection Exception", e);
        }
        catch (ReflectionException e) {
            throw new JMXException("Reflection Exception", e);
        }
        catch (IOException e) {
            throw new JMXException("IO Exception", e);
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(String mbeanName) throws JMXException {
        ObjectName objName = JmxUtil.createObjectName(mbeanName);
        return this.getMBeanInfo(objName);
    }

    public <T extends AgentPluginMBean> T getPluginProxy(Class<T> pluginMBeanInterface, String pluginId, String pluginVersion, int instanceNumber) throws JMXException {
        return (T)((AgentPluginMBean)JMX.newMBeanProxy(this.getMBeanServerConnection(), JmxUtil.getPluginObjectName(pluginId, pluginVersion, instanceNumber), pluginMBeanInterface));
    }

    @Override
    public String getProtocol() {
        return this.agentURL.getProtocol();
    }

    public <T extends AgentServiceMBean> T getServiceProxy(Class<T> serviceMBeanInterface, String serviceId) throws JMXException {
        return (T)((AgentServiceMBean)JMX.newMBeanProxy(this.getMBeanServerConnection(), JmxUtil.getServiceObjectName(serviceId), serviceMBeanInterface));
    }

    @Override
    public String getSessionID() {
        return this.isConnected() ? this._jmxConnection.getServerSessionId() : null;
    }

    @Override
    public String[] getSessionSecurityModules() throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        String[] moduleNames = (String[])this.invokeAgentServiceMethod("SecurityService", "getSessionSecurityModules", new Object[]{this.getSessionID()}, new String[]{"java.lang.String"});
        return moduleNames;
    }

    @Override
    public long getTimeCreated() {
        return this.getConnectionInfo().getTimeCreated();
    }

    @Override
    public String getUsername() {
        return this.isConnected() ? this._jmxConnection.getCurrentUsername() : null;
    }

    @Override
    public boolean hasAccess(String resourceURL, String permission) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        boolean hasAccess = false;
        try {
            hasAccess = (Boolean)this.getMBeanServerConnection().invoke(JmxUtil.getServiceObjectName("SecurityService"), "hasAccess", new Object[]{this.getSessionID(), resourceURL, permission}, new String[]{"java.lang.String", "java.lang.String", "java.lang.String"});
            return hasAccess;
        }
        catch (Exception e) {
            ServerManagedSessionAgentConnection.throwJMXException(e);
            return hasAccess;
        }
    }

    @Override
    public Object invokeAgentPluginMethod(String mbeanName, String methodName, Object[] paramValues, String[] paramTypes) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException {
        ObjectName objName = JmxUtil.createObjectName(mbeanName);
        return this.invokeMBeanOperation(objName, methodName, paramValues, paramTypes);
    }

    @Override
    public Object invokeAgentPluginMethod(String pluginId, String pluginVersion, int instanceNumber, String methodName, Object[] paramValues, String[] paramTypes) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException {
        ObjectName objName = JmxUtil.getPluginObjectName(pluginId, pluginVersion, instanceNumber);
        return this.invokeMBeanOperation(objName, methodName, paramValues, paramTypes);
    }

    @Override
    public Object invokeAgentServiceMethod(String serviceId, String methodName, Object[] paramValues, String[] paramTypes) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException {
        ObjectName objName = JmxUtil.getServiceObjectName(serviceId);
        return this.invokeMBeanOperation(objName, methodName, paramValues, paramTypes);
    }

    @Override
    public Object invokeMBeanOperation(ObjectName objName, String operationName, Object[] paramValues, String[] paramTypes) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException {
        return this.doInvokeMBeanOperation(objName, operationName, paramValues, paramTypes);
    }

    @Override
    public Object invokeMBeanOperation(String mbeanName, String operationName, Object[] paramValues, String[] paramTypes) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        return this.invokeMBeanOperation(JmxUtil.createObjectName(mbeanName), operationName, paramValues, paramTypes);
    }

    public boolean isAgentPlugin(ObjectName name) {
        return name.getDomain().equals("AgentPlugin");
    }

    @Override
    public boolean isAgentPluginAvailable(String pluginId, String pluginVersion, int instanceNumber) throws AuthenticationException, AuthorizationException, JMXException {
        String mbeanName = AgentClientUtil.getPluginMBeanName(pluginId, pluginVersion, instanceNumber);
        return this.isMBeanAvailable(mbeanName);
    }

    public boolean isAgentPluginLoaded(String mbeanName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        Boolean pluginLoaded;
        return this.isMBeanAvailable(mbeanName) && (pluginLoaded = (Boolean)this.getAgentPluginProperty(mbeanName, "loaded")) != false;
    }

    @Override
    public boolean isAgentPluginLoaded(String pluginId, String pluginVersion, int instanceNumber) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        String mbeanName = AgentClientUtil.getPluginMBeanName(pluginId, pluginVersion, instanceNumber);
        return this.isAgentPluginLoaded(mbeanName);
    }

    @Override
    public boolean isAgentPluginMethodAvailable(String pluginId, String pluginVersion, int instanceNumber, String method) throws AuthenticationException, AuthorizationException, JMXException {
        String mbeanName = AgentClientUtil.getPluginMBeanName(pluginId, pluginVersion, instanceNumber);
        return this.isMBeanMethodAvailable(mbeanName, method);
    }

    public boolean isAgentService(ObjectName name) {
        return name.getDomain().equals("AgentService");
    }

    @Override
    public boolean isAgentServiceAvailable(String serviceId) throws JMXException {
        String mbeanName = AgentClientUtil.getServiceMBeanName(serviceId);
        return this.isMBeanAvailable(mbeanName);
    }

    @Override
    public boolean isAgentServiceMethodAvailable(String serviceId, String method) throws AuthenticationException, AuthorizationException, JMXException {
        String mbeanName = AgentClientUtil.getServiceMBeanName(serviceId);
        return this.isMBeanMethodAvailable(mbeanName, method);
    }

    @Override
    public boolean isAgentServiceStarted(String serviceId) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        String mbeanName = AgentClientUtil.getServiceMBeanName(serviceId);
        if (this.isMBeanAvailable(mbeanName)) {
            return (Boolean)this.getAgentServiceProperty(serviceId, "started");
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        return this._jmxConnection != null && this._jmxConnection.isConnected();
    }

    public boolean isManagedObject(ObjectName name) {
        return name.getDomain().equals("ManagedObject");
    }

    @Override
    public boolean isSecureConnection() {
        return this.getConnectionInfo().isRequireSecureConnectionPassword();
    }

    @Override
    public boolean isTimedOut() {
        return false;
    }

    @Override
    @Deprecated
    public void login(char[] authorizationKey, char[] signature) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        throw new UnsupportedOperationException("The server does not currently support authorization key and signature based authentication");
    }

    @Override
    public void login(Map<String, Object> credentialMap) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        if (credentialMap == null) {
            this.login("anonymous", null);
            return;
        }
        String username = (String)credentialMap.get("username");
        char[] password = (char[])credentialMap.get("password");
        char[] authorizationKey = (char[])credentialMap.get("authorizationkey");
        char[] signature = (char[])credentialMap.get("signature");
        if (username != null) {
            this.login(username, password);
        } else if (authorizationKey != null) {
            this.login(authorizationKey, signature);
        }
    }

    @Override
    public void login(String username, char[] password) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        this._jmxConnection.login(JmxAgentConnection.createCredentials(this.getConnectionInfo(), username, (Serializable)password));
    }

    @Override
    public void logout() {
        if (!this.isConnected()) {
            return;
        }
        this._jmxConnection.logout();
    }

    @Override
    public Set<ObjectName> queryMBeans(ObjectName objNamePattern, QueryExp query) throws JMXException {
        try {
            return this.getMBeanServerConnection().queryNames(objNamePattern, null);
        }
        catch (IOException e) {
            throw new JMXException("IO Exception", e);
        }
    }

    @Override
    public Set<ObjectName> queryMBeans(String mbeanNamePattern, QueryExp query) throws JMXException {
        return this.queryMBeans(JmxUtil.createObjectName(mbeanNamePattern), query);
    }

    @Override
    @Deprecated
    public void reloadACLCache() throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        this.invokeAgentServiceMethod("SecurityService", "reloadACLCache", new Object[]{this.getSessionID()}, new String[]{"java.lang.String"});
    }

    @Override
    public void removeConnectionListener(ConnectionListener listener) {
        if (this.connectionListenerHook != null) {
            try {
                AgentConnectionListenerImpl connectionListenerHookImpl = (AgentConnectionListenerImpl)this.connectionListenerHook;
                connectionListenerHookImpl.removeConnectionListener(listener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String retrieveUsername() throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        return (String)this.invokeAgentServiceMethod("SecurityService", "getUsername", new Object[]{this.getSessionID()}, new String[]{"java.lang.String"});
    }

    @Override
    public void setAgentPluginProperty(String pluginId, String pluginVersion, int instanceNumber, String propertyName, Object propertyValue) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = JmxUtil.getPluginObjectName(pluginId, pluginVersion, instanceNumber);
        this.setMBeanAttribute(objName, propertyName, propertyValue);
    }

    @Override
    public void setAgentServiceProperty(String serviceId, String propertyName, Object propertyValue) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = JmxUtil.getServiceObjectName(serviceId);
        this.setMBeanAttribute(objName, propertyName, propertyValue);
    }

    @Override
    @Deprecated
    public void setCipherProviderClass(String cipherProviderClass) {
    }

    @Override
    public void setClientConnectionTimeout(long clientConnectionTimeout) {
        this.getConnectionInfo().setClientConnectionTimeout(clientConnectionTimeout);
    }

    @Override
    @Deprecated
    public synchronized void setConnected(boolean connected) {
    }

    @Override
    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
    }

    @Override
    public void setMBeanAttribute(ObjectName objName, String attributeName, Object attributeValue) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        this.doSetMBeanAttribute(objName, attributeName, attributeValue);
    }

    @Override
    public void setMBeanAttribute(String mbeanName, String attributeName, Object attributeValue) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        ObjectName objName = JmxUtil.createObjectName(mbeanName);
        this.setMBeanAttribute(objName, attributeName, attributeValue);
    }

    @Override
    @Deprecated
    public void setSecureConnection(boolean secureConnection) {
    }

    @Override
    public void setTimedOut(boolean timedOut) {
    }

    protected synchronized AgentInfo createAgentInfo() throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        return (AgentInfo)this.getAgentServiceProperty("Agent", "agentInfo");
    }

    protected Object doGetMBeanAttribute(ObjectName objName, String attributeName) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        String normalizedAttributeName = this.normalizeAttributeName(objName, attributeName);
        try {
            return this.getMBeanServerConnection().getAttribute(objName, normalizedAttributeName);
        }
        catch (Exception e) {
            ServerManagedSessionAgentConnection.throwJMXException(e);
            return null;
        }
    }

    protected Object doInvokeMBeanOperation(ObjectName objName, String operationName, Object[] paramValues, String[] paramTypes) throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException {
        try {
            return this.getMBeanServerConnection().invoke(objName, operationName, paramValues, paramTypes);
        }
        catch (Throwable t) {
            ServerManagedSessionAgentConnection.throwJMXException(t);
            return null;
        }
    }

    protected void doSetMBeanAttribute(ObjectName objName, String attributeName, Object attributeValue) throws AuthenticationException, LoginModuleNotFoundException, AuthorizationException, JMXException {
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        String normalizedAttributeName = this.normalizeAttributeName(objName, attributeName);
        Attribute attribute = new Attribute(normalizedAttributeName, attributeValue);
        try {
            mbeanServerConn.setAttribute(objName, attribute);
        }
        catch (Throwable t) {
            ServerManagedSessionAgentConnection.throwJMXException(t);
        }
    }

    protected ConnectionInfo getConnectionInfo() {
        return this._agentConnectionInfo;
    }

    protected boolean isMBeanAvailable(String mbeanName) throws JMXException {
        if (!this.isConnected()) {
            return false;
        }
        ObjectName objNamePattern = JmxUtil.createObjectName(mbeanName);
        MBeanServerConnection mbeanServerConn = this.getMBeanServerConnection();
        try {
            Set<ObjectName> namesset = mbeanServerConn.queryNames(objNamePattern, null);
            return namesset != null && !namesset.isEmpty();
        }
        catch (IOException e) {
            throw new JMXException("Connection lost", e.getMessage());
        }
    }

    protected boolean isMBeanMethodAvailable(String mbeanName, String method) throws JMXException {
        if (!this.isConnected()) {
            return false;
        }
        ObjectName objName = JmxUtil.createObjectName(mbeanName);
        MBeanServerConnection connection = this.getMBeanServerConnection();
        try {
            MBeanOperationInfo[] operationInfos;
            MBeanInfo mbeanInfo = connection.getMBeanInfo(objName);
            for (MBeanOperationInfo operationInfo : operationInfos = mbeanInfo.getOperations()) {
                if (!method.equals(operationInfo.getName())) continue;
                return true;
            }
            return false;
        }
        catch (InstanceNotFoundException e) {
            return false;
        }
        catch (IntrospectionException e) {
            throw new JMXException("Introspection Exception", e);
        }
        catch (ReflectionException e) {
            throw new JMXException("Reflection Exception", e);
        }
        catch (IOException e) {
            throw new JMXException("IO Exception", e);
        }
    }

    protected String normalizeAttributeName(ObjectName objName, String attributeName) throws JMXException {
        boolean isStandardMBean = true;
        MBeanInfo mbeanInfo = this.getMBeanInfo(objName);
        if (mbeanInfo instanceof ModelMBeanInfoSupport) {
            isStandardMBean = false;
        }
        return isStandardMBean ? StringUtil.toUpper(attributeName, 0) : StringUtil.toLower(attributeName, 0);
    }

    protected synchronized void setupConnectionListenerHook() throws AuthenticationException, AuthorizationException, LoginModuleNotFoundException, JMXException {
        if (this.agentURL == null) {
            return;
        }
        String protocol = this.agentURL.getProtocol();
        if (this.connectionListenerHook == null) {
            return;
        }
        ((AgentConnectionListenerImpl)this.connectionListenerHook).init(this);
        if (protocol.equals("rmi")) {
            if (!this.isAgentServiceAvailable("RMIService")) {
                throw new JMXException("Service is not started", "RMI Service not available. ");
            }
            this.invokeAgentServiceMethod("RMIService", "addConnectionListener", new Object[]{this.connectionListenerHook}, new String[]{AgentConnectionListener.class.getName()});
        }
    }

    protected String[] splitPluginObjectNameString(String objectNameString) throws AgentPluginException {
        if (objectNameString == null) {
            throw new AgentPluginException(MessageFormat.format(INVALID_PLUGIN_OBJECT_NAME_FORMAT_MSG, objectNameString));
        }
        String[] splitOName = objectNameString.split("_");
        if (splitOName.length != 3) {
            throw new AgentPluginException(MessageFormat.format(INVALID_PLUGIN_OBJECT_NAME_FORMAT_MSG, objectNameString));
        }
        if (!splitOName[0].matches("[\\w\\.\\-]+")) {
            throw new AgentPluginException(MessageFormat.format(INVALID_PLUGIN_OBJECT_NAME_FORMAT_MSG, objectNameString) + "Plugin ID portion of name is invalid.  It must be of the form \"[\\w\\.\\-]+\"");
        }
        if (!splitOName[1].matches("\\d+[\\.\\d]+")) {
            throw new AgentPluginException(MessageFormat.format(INVALID_PLUGIN_OBJECT_NAME_FORMAT_MSG, objectNameString) + "Version portion of name is invalid.  It must be of the form \"\\d+[\\.\\d]+\"");
        }
        if (!splitOName[2].matches("\\d+")) {
            throw new AgentPluginException(MessageFormat.format(INVALID_PLUGIN_OBJECT_NAME_FORMAT_MSG, objectNameString) + "Instance portion of name is invalid.  It must be numeric.");
        }
        return splitOName;
    }

    private MBeanServerConnection getMBeanServerConnection() {
        if (this._jmxConnection == null) {
            throw new IllegalStateException("Not connected");
        }
        return this._jmxConnection.getMBeanServerConnection();
    }
}

