/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.discovery;

import com.sybase.ua.AgentInfo;
import com.sybase.ua.discovery.AgentDiscoveryAdaptorBase;
import com.sybase.ua.discovery.AgentDiscoveryJiniBroadcastListener;
import com.sybase.ua.discovery.AgentIdentity;
import com.sybase.ua.discovery.DiscoveryException;
import java.io.IOException;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscovery;

public class AgentDiscoveryJiniAdaptor
extends AgentDiscoveryAdaptorBase {
    private static final String DEFAULT_JINI_PORT = "4160";
    private ServiceRegistrar jiniRegistrar = null;
    private LookupDiscovery lookupDiscovery = null;
    private AgentDiscoveryJiniBroadcastListener broadcastListener;
    private Object monitor = null;
    private ServiceRegistrar[] jiniRegistrars;

    public static List<AgentInfo> getAgentInfos(ServiceRegistrar registrar) throws DiscoveryException {
        ServiceTemplate template = new ServiceTemplate(null, new Class[]{AgentIdentity.class}, null);
        return AgentDiscoveryJiniAdaptor.getAgentInfos(registrar, template);
    }

    public static List<AgentInfo> getAgentInfos(ServiceRegistrar registrar, ServiceTemplate template) throws DiscoveryException {
        ArrayList<AgentInfo> agentInfos = new ArrayList<AgentInfo>();
        ServiceMatches matches = null;
        try {
            log.debug((Object)"Looking up registered entries...");
            matches = registrar.lookup(template, Integer.MAX_VALUE);
        }
        catch (Throwable t) {
            throw new DiscoveryException("Failed to lookup Jini registrar for AgentIdentity.", t);
        }
        log.info((Object)"Please wait...");
        for (int i = 0; i < matches.totalMatches; ++i) {
            ServiceItem item = matches.items[i];
            item.attributeSets[0].toString();
            Object o = item.service;
            if (o == null) continue;
            AgentIdentity agentIdentity = (AgentIdentity)o;
            AgentInfo agentInfo = null;
            try {
                agentInfo = agentIdentity.getAgentInfo();
            }
            catch (RemoteException e) {
                agentInfo = new AgentInfo();
                try {
                    agentInfo.setHost(agentIdentity.getHost());
                    agentInfo.setRMIPort(agentIdentity.getPort());
                }
                catch (RemoteException ex) {
                    continue;
                }
            }
            agentInfos.add(agentInfo);
        }
        return agentInfos;
    }

    public AgentDiscoveryJiniAdaptor() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
    }

    @Override
    public List<AgentInfo> discover() throws DiscoveryException {
        List<AgentInfo> agentInfos = null;
        agentInfos = this.getHost() == null || this.getHost().trim().equals("") ? this.useBroadcast() : this.useAddress();
        return agentInfos;
    }

    private ServiceRegistrar getJiniRegistrar() throws DiscoveryException {
        if (this.jiniRegistrar != null) {
            return this.jiniRegistrar;
        }
        if (this.getHost() != null) {
            String jurl = "jini://" + this.getHost();
            if (this.getPort() != null) {
                jurl = jurl + ":" + this.getPort();
            }
            try {
                LookupLocator lookup = new LookupLocator(jurl);
                this.jiniRegistrar = lookup.getRegistrar();
            }
            catch (Exception e) {
                throw new DiscoveryException("Failed to get Jini registrar. host: " + this.getHost() + ", port: " + this.getPort(), e);
            }
        }
        return this.jiniRegistrar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceRegistrar[] getJiniRegistrars() throws DiscoveryException {
        if (this.jiniRegistrars != null && this.jiniRegistrars.length > 0) {
            return this.jiniRegistrars;
        }
        if (this.lookupDiscovery == null) {
            try {
                this.lookupDiscovery = new LookupDiscovery(null);
            }
            catch (IOException e) {
                throw new DiscoveryException(e);
            }
        }
        if (this.broadcastListener == null) {
            this.broadcastListener = new AgentDiscoveryJiniBroadcastListener();
            this.monitor = new Object();
            this.broadcastListener.setMonitor(this.monitor);
        }
        this.lookupDiscovery.addDiscoveryListener((DiscoveryListener)this.broadcastListener);
        log.debug((Object)"Searching JINI registars on the local subnet...");
        long timeStart = System.currentTimeMillis();
        Object object = this.monitor;
        synchronized (object) {
            try {
                this.monitor.wait(this.getTimeOut());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.jiniRegistrars = this.lookupDiscovery.getRegistrars();
        this.lookupDiscovery.removeDiscoveryListener((DiscoveryListener)this.broadcastListener);
        long timeEnd = System.currentTimeMillis();
        long timeElapsed = timeEnd - timeStart;
        this.setTimeElapsed(timeElapsed);
        if (timeElapsed < this.getTimeOut()) {
            if (!this.broadcastListener.isRegistrarFound()) {
                log.info((Object)"No JINI server can be discovered on your local subnet.");
                log.info((Object)"If your JINI server is located on a different subnet, please specifiy the JINI server address.");
            }
        } else {
            log.info((Object)("Discovery timed out after " + this.getTimeOut() / 1000L + " seconds."));
            if (this.broadcastListener.isRegistrarFound()) {
                log.info((Object)"This is possibly caused by slow network response from JINI broadcast service.");
                log.info((Object)"You can either increase the timeout value or ");
                log.info((Object)"use address based discovery by specifying JINI server address.");
            } else {
                log.info((Object)"No JINI server can be discovered on your local subnet.");
                log.info((Object)"If your JINI server is located on a different subnet, please specifiy the JINI server address.");
            }
        }
        this.broadcastListener.reset();
        return this.jiniRegistrars;
    }

    private List<AgentInfo> useAddress() throws DiscoveryException {
        if (this.getPort() == null) {
            this.setPort(DEFAULT_JINI_PORT);
        }
        if (this.getPort().trim().equals("")) {
            this.setPort(DEFAULT_JINI_PORT);
        }
        log.info((Object)("Contacting Jini service at host: " + this.getHost() + "..."));
        long timeStart = System.currentTimeMillis();
        ServiceRegistrar registrar = this.getJiniRegistrar();
        if (registrar == null) {
            throw new DiscoveryException("Cannot locate Jini registrar. host: " + this.getHost() + ", port: " + this.getPort());
        }
        log.debug((Object)"JINI registrar found.");
        log.debug((Object)("Registrar service ID: " + registrar.getServiceID()));
        try {
            List<AgentInfo> agentInfos = AgentDiscoveryJiniAdaptor.getAgentInfos(registrar);
            long timeEnd = System.currentTimeMillis();
            long timeElapsed = timeEnd - timeStart;
            this.setTimeElapsed(timeElapsed);
            return agentInfos;
        }
        catch (Throwable t) {
            log.error((Object)t.getMessage(), t);
            throw new DiscoveryException("Failed to discover Jini services using address", t);
        }
    }

    private List<AgentInfo> useBroadcast() throws DiscoveryException {
        log.info((Object)"Using JINI broadcast mechanism.");
        ServiceRegistrar[] registrars = this.getJiniRegistrars();
        ArrayList<AgentInfo> agentInfos = new ArrayList<AgentInfo>();
        if (registrars != null) {
            for (ServiceRegistrar registrar : registrars) {
                log.debug((Object)("Registrar service ID: " + registrar.getServiceID()));
                try {
                    List<AgentInfo> agentInfoList = AgentDiscoveryJiniAdaptor.getAgentInfos(registrar);
                    if (agentInfoList == null || agentInfoList.isEmpty()) continue;
                    agentInfos.addAll(agentInfoList);
                }
                catch (Throwable t) {
                    log.error((Object)t.getMessage(), t);
                }
            }
        }
        return agentInfos;
    }
}

