/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.discovery;

import com.sybase.ua.AgentInfo;
import com.sybase.ua.discovery.AgentDiscoveryAdaptorBase;
import com.sybase.ua.discovery.DiscoveryException;
import com.sybase.ua.discovery.ldap.AgentNode;
import com.sybase.ua.util.ldap.LDAPConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class AgentDiscoveryLdapAdaptor
extends AgentDiscoveryAdaptorBase {
    public static final String OBJECTCLASS_AGENT = "uaAgent";
    public static final String OBJECTCLASS_AGENTINFO = "uaObject";
    public static final String OBJECTCLASS_PLUGIN = "uaPlugin";
    public static final String OBJECTCLASS_SERVICE = "uaService";
    public static final String AGENTINFO_CN = "agentInfo";
    public static final String OBJECTCLASS_PLUGIN_PROPERTIES = "uaDiscoveryProperties";
    public static final String OBJECTCLASS_SERVICE_PROPERTIES = "uaDiscoveryProperties";
    public static final String DEFAULT_LDAP_PORT = "389";
    public static final String DEFAULT_BASE_DN = "dc=sybase,dc=com";
    public static final String DEFAULT_LDAP_FILTER = "objectclass=uaAgent";
    public static final String PROP_HOST = "HOST";
    public static final String PROP_PORT = "PORT";
    public static final String PROP_USER_DN = "USER_DN";
    public static final String PROP_PASSWORD = "PASSWORD";
    public static final String PROP_AUTHENTICATION_METHOD = "AUTHENTICATION_METHOD";
    public static final String PROP_LDAP_FACTORY = "LDAP_FACTORY";
    public static final String PROP_BASE_DN = "BASE_DN";
    public static final String PROP_LDAP_FILTER = "LDAP_FILTER";
    public static final String UPDATE_MAP_OBJECT_CLASS = "OBJECT_CLASS";
    public static final String UPDATE_MAP_AGENTINFO = "AGENTINFO";
    public static final String UPDATE_MAP_PLUGININFO = "PLUGININFO";
    public static final String UPDATE_MAP_SERVICEINFO = "SERVICEINFO";
    public static final String UPDATE_MAP_MAX_LEVELS = "MAX_LEVELS";
    transient LDAPConnection ldapConnection;
    private Properties properties;

    @Override
    public List<AgentInfo> discover() throws DiscoveryException {
        return this.discover(null);
    }

    @Override
    public List<AgentInfo> discover(Properties discoveryProperties) throws DiscoveryException {
        if (this.getHost() == null || this.getHost().trim().equals("")) {
            throw new DiscoveryException("LDAP host is missing.");
        }
        if (this.getPort() == null || this.getPort().trim().equals("")) {
            this.setPort(DEFAULT_LDAP_PORT);
        }
        if (discoveryProperties == null) {
            discoveryProperties = new Properties();
        }
        if (discoveryProperties.getProperty(PROP_HOST) == null) {
            discoveryProperties.setProperty(PROP_HOST, this.getHost());
        }
        if (discoveryProperties.getProperty(PROP_PORT) == null) {
            discoveryProperties.setProperty(PROP_PORT, this.getPort());
        }
        if (discoveryProperties.getProperty(PROP_BASE_DN) == null) {
            discoveryProperties.setProperty(PROP_BASE_DN, DEFAULT_BASE_DN);
        }
        this.setProperties(discoveryProperties);
        this.createLdapConnection();
        long timeStart = System.currentTimeMillis();
        List<AgentInfo> agentInfos = this.searchLdap();
        long timeEnd = System.currentTimeMillis();
        long timeElapsed = timeEnd - timeStart;
        this.setTimeElapsed(timeElapsed);
        return agentInfos;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(String key) {
        String value = (String)this.properties.get(key);
        return value;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private void createLdapConnection() {
        if (this.ldapConnection != null) {
            return;
        }
        try {
            this.ldapConnection = LDAPConnection.createLDAPConnection(this.properties);
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private List<DirContext> findUaAgents(DirContext ctx, String baseDn) throws NamingException {
        ArrayList<DirContext> agentNodes = new ArrayList<DirContext>(10);
        SearchControls sctl = new SearchControls();
        sctl.setSearchScope(2);
        sctl.setReturningObjFlag(true);
        sctl.setTimeLimit((int)this.getTimeOut());
        String filter = DEFAULT_LDAP_FILTER;
        String filterProp = this.getProperty(PROP_LDAP_FILTER);
        if (filterProp != null && !filterProp.trim().equals("")) {
            filter = filterProp;
        }
        NamingEnumeration<SearchResult> registryEnum = ctx.search(baseDn, filter, sctl);
        while (registryEnum.hasMore()) {
            SearchResult result = registryEnum.next();
            DirContext agentNode = (DirContext)result.getObject();
            agentNodes.add(agentNode);
        }
        return agentNodes;
    }

    private List<AgentInfo> searchLdap() {
        ArrayList<AgentInfo> agentInfos = new ArrayList<AgentInfo>(5);
        try {
            this.ldapConnection.connect();
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return agentInfos;
        }
        DirContext ctx = this.ldapConnection.getDirectoryContext();
        String baseDn = this.properties.getProperty(PROP_BASE_DN);
        if (baseDn != null && !baseDn.trim().equals("")) {
            baseDn = DEFAULT_BASE_DN;
        }
        List<DirContext> agentNodes = null;
        try {
            agentNodes = this.findUaAgents(ctx, baseDn);
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return agentInfos;
        }
        for (DirContext agentNode : agentNodes) {
            AgentInfo agentInfo;
            String status;
            Object obj = null;
            try {
                String agentNodeDn = agentNode.getNameInNamespace();
                String agentInfoNodeDn = "cn=agentInfo," + agentNodeDn;
                obj = ctx.lookup(agentInfoNodeDn);
            }
            catch (NameNotFoundException e) {
                obj = AgentNode.restoreAgentInfo(agentNode);
            }
            catch (NamingException e) {
                if (!log.isDebugEnabled()) continue;
                log.error((Object)e.getMessage());
                continue;
            }
            if (obj == null || !(obj instanceof AgentInfo) || !(status = (agentInfo = obj).getStatus()).equals("RUNNING")) continue;
            agentInfos.add(agentInfo);
        }
        try {
            this.ldapConnection.disconnect();
        }
        catch (NamingException e) {
            // empty catch block
        }
        return agentInfos;
    }
}

