/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.discovery;

import com.sybase.ua.AgentInfo;
import com.sybase.ua.AgentInfoV3;
import com.sybase.ua.service.AgentServiceException;
import com.sybase.ua.services.Agent;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPMulticastClient {
    private static Log log = LogFactory.getLog(UDPMulticastClient.class);
    public static final int TIME_OUT = 5000;
    private String localhost;
    private List<AgentInfo> agentInfos = new ArrayList<AgentInfo>();
    private DatagramSocket inboundSocket;
    private int inboundPort = 5432;
    private boolean running;
    private final String requestString;
    private InetAddress groupAddress;
    private DatagramPacket requestPacket;
    private DatagramSocket outboundSocket;
    private int outboundPort = 3221;
    public static final int UDP_SERVER_DEFAULT_BROADCAST_PORT = 4446;
    public static final String UDP_SERVER_BROADCAST_GROUP = "232.0.0.1";
    public static final String UDP_SERVER_REQUEST_HEADER = "header=UNIFIED_AGENT:UDP:REQUEST:DISCOVERY";
    public static final String UDP_SERVER_RESPONSE_HEADER = "header=UNIFIED_AGENT:UDP:RESPONSE:DISCOVERY";

    public UDPMulticastClient() {
        this.discoverHostName();
        try {
            this.outboundSocket = new DatagramSocket();
            this.outboundPort = this.outboundSocket.getLocalPort();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.inboundSocket = new DatagramSocket();
            this.inboundPort = this.inboundSocket.getLocalPort();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.requestString = this.buildRequestString();
        try {
            this.groupAddress = InetAddress.getByName(UDP_SERVER_BROADCAST_GROUP);
            this.requestPacket = new DatagramPacket(this.requestString.getBytes(), this.requestString.getBytes().length, this.groupAddress, 4446);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void dispose() {
        if (this.inboundSocket != null && !this.inboundSocket.isClosed()) {
            this.inboundSocket.close();
            this.inboundSocket = null;
        }
        if (this.outboundSocket != null && !this.outboundSocket.isClosed()) {
            this.outboundSocket.close();
            this.outboundSocket = null;
        }
        if (this.requestPacket != null) {
            this.requestPacket = null;
        }
        if (this.groupAddress != null) {
            this.groupAddress = null;
        }
    }

    public List<AgentInfo> getAgentInfos() {
        return this.agentInfos;
    }

    public boolean isRunning() {
        return this.running;
    }

    public synchronized void setRunning(boolean running) {
        this.running = running;
    }

    public void start() {
        this.setRunning(true);
        if (this.agentInfos == null) {
            this.agentInfos = new ArrayList<AgentInfo>();
        } else {
            this.agentInfos.clear();
        }
        try {
            log.debug((Object)"Using UDP broadcast mechanism.");
            this.broadcastRequest();
            this.waitForResponse();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            log.error((Object)e.getMessage());
        }
        this.setRunning(false);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private void broadcastRequest() throws Exception {
        if (this.requestPacket != null) {
            if (this.outboundSocket == null || this.outboundSocket.isClosed()) {
                this.outboundSocket = new DatagramSocket(this.outboundPort);
            }
            this.outboundSocket.send(this.requestPacket);
            log.debug((Object)("UDP outbound port: " + this.outboundPort));
        }
    }

    private String buildRequestString() {
        String s = new String("header=UNIFIED_AGENT:UDP:REQUEST:DISCOVERY,host=" + this.localhost + ",udp-port=" + this.inboundPort + ",footer=EOM");
        return s;
    }

    private void discoverHostName() {
        try {
            this.localhost = (String)Agent.getInstance().getAgentServiceAttribute("Agent", "host");
        }
        catch (AgentServiceException ase) {
            this.localhost = null;
        }
        catch (NoClassDefFoundError ncdfe) {
            this.localhost = null;
        }
        if (this.localhost != null && !this.localhost.equals("")) {
            return;
        }
        try {
            InetAddress localhostAddr = InetAddress.getLocalHost();
            this.localhost = localhostAddr.getCanonicalHostName();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            } else {
                log.error((Object)e.getMessage());
            }
            this.localhost = "localhost";
        }
    }

    private void handleResponse(String resString) throws Exception {
        if (resString == null || resString.trim().equals("")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(resString, ",");
        st.nextToken();
        String part2 = st.nextToken();
        part2.substring(part2.indexOf("=") + 1);
        String part3 = st.nextToken();
        String host = part3.substring(part3.indexOf("=") + 1);
        String part4 = st.nextToken();
        String rmiPort = part4.substring(part4.indexOf("=") + 1);
        String part5 = st.nextToken();
        String agentHome = part5.substring(part5.indexOf("=") + 1);
        String part6 = st.nextToken();
        String version = part6.substring(part6.indexOf("=") + 1);
        String part7 = st.nextToken();
        String buildNumber = part7.substring(part7.indexOf("=") + 1);
        String part8 = st.nextToken();
        String osName = part8.substring(part8.indexOf("=") + 1);
        String part9 = st.nextToken();
        String osVersion = part9.substring(part9.indexOf("=") + 1);
        String part10 = st.nextToken();
        String osArch = part10.substring(part10.indexOf("=") + 1);
        String part11 = st.nextToken();
        String timeStartedString = part11.substring(part11.indexOf("=") + 1);
        long timeStartedLong = new Long(timeStartedString);
        String part12 = st.nextToken();
        String isSecuredString = part12.substring(part12.indexOf("=") + 1);
        Boolean isSecured = new Boolean(isSecuredString);
        String part13 = st.nextToken();
        String inetAddress = part13.startsWith("inetaddr") ? part13.substring(part13.indexOf("=") + 1) : null;
        AgentInfo agentInfo = new AgentInfo();
        agentInfo.setHost(host);
        agentInfo.setRMIPort(rmiPort);
        agentInfo.setAgentHome(agentHome);
        agentInfo.setVersion(version);
        agentInfo.setBuildNumber(buildNumber);
        agentInfo.setOSName(osName);
        agentInfo.setOSVersion(osVersion);
        agentInfo.setOSArchitecture(osArch);
        agentInfo.setTimeStarted(new Date(timeStartedLong));
        agentInfo.setSecurityAgent(isSecured);
        if (inetAddress == null) {
            this.agentInfos.add(agentInfo);
        } else {
            AgentInfoV3 agentInfoV3 = new AgentInfoV3(agentInfo);
            agentInfoV3.setInetAddress(inetAddress);
            this.agentInfos.add(agentInfoV3);
        }
    }

    private void waitForResponse() throws IOException {
        if (this.inboundSocket == null || this.inboundSocket.isClosed()) {
            this.inboundSocket = new DatagramSocket(this.inboundPort);
        }
        log.debug((Object)("UDP inbound port: " + this.inboundPort));
        byte[] buf = new byte[1024];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        this.inboundSocket.setSoTimeout(5000);
        String resString = null;
        while (this.isRunning()) {
            try {
                this.inboundSocket.receive(packet);
            }
            catch (SocketTimeoutException e) {
                break;
            }
            resString = new String(packet.getData());
            if (resString == null) continue;
            if ((resString = resString.trim()).startsWith(UDP_SERVER_RESPONSE_HEADER)) {
                try {
                    this.handleResponse(resString);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                continue;
            }
            log.debug((Object)("Not a valid response header: " + resString));
            log.debug((Object)"Ignore the response.");
        }
    }
}

