/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.discovery.ldap;

import com.sybase.ua.AgentInfo;
import com.sybase.ua.PluginInfo;
import com.sybase.ua.ServiceInfo;
import com.sybase.ua.discovery.ldap.PluginsNode;
import com.sybase.ua.discovery.ldap.ServicesNode;
import com.sybase.ua.services.AgentMBean;
import com.sybase.ua.util.ldap.LDAPNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AgentNode
extends LDAPNode {
    private static Log log = LogFactory.getLog(AgentNode.class);

    public static AgentInfo restoreAgentInfo(DirContext agentNode) {
        AgentInfo agentInfo = null;
        try {
            Attributes attrs = agentNode.getAttributes("");
            String host = (String)attrs.get("uaHost").get(0);
            String version = (String)attrs.get("uaVersion").get(0);
            String buildNumber = (String)attrs.get("uaBuildNumber").get(0);
            String generalizedTimePattern = "yyyy.MM.dd.hh.mm.ss z";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd.hh.mm.ss z");
            Date timeStarted = null;
            Date timeChecked = null;
            Date timeUpdated = null;
            try {
                timeStarted = simpleDateFormat.parse((String)attrs.get("uaTimeStarted").get(0));
                timeChecked = simpleDateFormat.parse((String)attrs.get("uaTimeChecked").get(0));
                timeUpdated = simpleDateFormat.parse((String)attrs.get("uaTimeUpdated").get(0));
            }
            catch (ParseException parseException) {
                log.error((Object)parseException.getMessage());
            }
            String rmiPort = (String)attrs.get("uaRmiPort").get(0);
            String agentHome = (String)attrs.get("uaAgentHome").get(0);
            String osName = (String)attrs.get("uaOsName").get(0);
            String osArch = (String)attrs.get("uaOsArchitecture").get(0);
            String osVersion = (String)attrs.get("uaOsVersion").get(0);
            String status = (String)attrs.get("uaStatus").get(0);
            DirContext pluginsNode = PluginsNode.findPluginsNode(agentNode);
            List<PluginInfo> pluginInfos = PluginsNode.restorePluginInfos(pluginsNode);
            DirContext servicesNode = ServicesNode.findServicesNode(agentNode);
            List<ServiceInfo> serviceInfos = ServicesNode.restoreServiceInfos(servicesNode);
            agentInfo = new AgentInfo(host, version, buildNumber, timeStarted, rmiPort, agentHome, osName, osVersion, osArch, pluginInfos, serviceInfos);
            agentInfo.setStatus(status);
            agentInfo.setTimeChecked(timeChecked);
            agentInfo.setTimeUpdated(timeUpdated);
        }
        catch (NamingException e) {
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            log.error((Object)e.getMessage());
        }
        return agentInfo;
    }

    public AgentNode(String agentNodeCn, String agentNodeDn, AgentInfo agentInfo, DirContext ctx) {
        super(agentNodeCn, agentNodeDn, ctx);
        Attributes attrs = this.getAttributes();
        attrs.put("objectClass", "uaAgent");
        attrs.put("cn", agentNodeCn);
        attrs.put("uaVersion", agentInfo.getVersion());
        attrs.put("uaBuildNumber", agentInfo.getBuildNumber());
        attrs.put("uaHost", agentInfo.getHost());
        attrs.put("uaAgentHome", agentInfo.getAgentHome());
        String rmiPort = (String)agentInfo.getServiceInfo("RMIService").getDiscoveryProperty("port");
        if (rmiPort != null && !rmiPort.trim().equals("")) {
            attrs.put("uaRmiPort", rmiPort);
        }
        attrs.put("uaStatus", agentInfo.getStatus());
        String generalizedTimePattern = "yyyy.MM.dd.hh.mm.ss z";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd.hh.mm.ss z");
        attrs.put("uaTimeStarted", sdf.format(agentInfo.getTimeStarted()));
        attrs.put("uaOsName", agentInfo.getOSName());
        attrs.put("uaOsVersion", agentInfo.getOSVersion());
        attrs.put("uaOsArchitecture", agentInfo.getOSArchitecture());
        attrs.put("uaTimeUpdated", sdf.format(agentInfo.getTimeUpdated()));
        attrs.put("uaTimeChecked", sdf.format(agentInfo.getTimeChecked()));
    }

    public AgentNode(String agentNodeCn, String agentNodeDn, AgentMBean agentMBean, String rmiPort, String agentStatus, DirContext ctx) {
        super(agentNodeCn, agentNodeDn, ctx);
        Attributes attrs = this.getAttributes();
        attrs.put("objectClass", "uaAgent");
        attrs.put("cn", agentNodeCn);
        attrs.put("uaVersion", agentMBean.getVersion());
        attrs.put("uaBuildNumber", agentMBean.getBuildNumber());
        attrs.put("uaHost", agentMBean.getHost());
        attrs.put("uaAgentHome", agentMBean.getAgentHome());
        if (rmiPort != null && !rmiPort.trim().equals("")) {
            attrs.put("uaRmiPort", rmiPort);
        }
        attrs.put("uaStatus", agentStatus);
        String generalizedTimePattern = "yyyy.MM.dd.hh.mm.ss z";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd.hh.mm.ss z");
        attrs.put("uaTimeStarted", sdf.format(agentMBean.getTimeStarted()));
        attrs.put("uaOsName", agentMBean.getOSName());
        attrs.put("uaOsVersion", agentMBean.getOSVersion());
        attrs.put("uaOsArchitecture", agentMBean.getOSArchitecture());
        Date now = new Date();
        attrs.put("uaTimeUpdated", sdf.format(now));
        attrs.put("uaTimeChecked", sdf.format(now));
    }
}

