/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.discovery.ldap;

import com.sybase.ua.PluginInfo;
import com.sybase.ua.discovery.ldap.DiscoveryPropertiesNode;
import com.sybase.ua.util.ldap.LDAPNode;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;

public class PluginNode
extends LDAPNode {
    public static DirContext findDiscoveryPropertiesNode(DirContext pluginNode) throws NamingException {
        DirContext discoveryPropssNode = (DirContext)pluginNode.lookup("cn=discoveryProperties");
        return discoveryPropssNode;
    }

    public static PluginInfo restorePluginInfo(DirContext pluginNode) throws NamingException {
        Attributes attrs = pluginNode.getAttributes("");
        String name = (String)attrs.get("name").get(0);
        String version = (String)attrs.get("uaPluginVersion").get(0);
        String id = (String)attrs.get("uaId").get(0);
        String providerName = (String)attrs.get("uaProviderName").get(0);
        String instanceNumberStr = (String)attrs.get("uaInstanceNumber").get(0);
        int instanceNumber = new Integer(instanceNumberStr);
        String pluginHome = (String)attrs.get("uaPluginHome").get(0);
        boolean enabled = "true".equalsIgnoreCase((String)attrs.get("uaEnabled").get(0));
        boolean loaded = "true".equalsIgnoreCase((String)attrs.get("uaLoaded").get(0));
        boolean registerOnStartup = "true".equalsIgnoreCase((String)attrs.get("uaRegisterOnStartup").get(0));
        DirContext discoveryPropsNode = PluginNode.findDiscoveryPropertiesNode(pluginNode);
        Map<String, Object> discoveryProps = DiscoveryPropertiesNode.restoreDiscoveryProperties(discoveryPropsNode);
        PluginInfo pluginInfo = new PluginInfo(name, id, version, instanceNumber, providerName, loaded, enabled, registerOnStartup, pluginHome, discoveryProps);
        return pluginInfo;
    }

    public PluginNode(String pluginNodeCn, String pluginNodeDn, PluginInfo pluginInfo, DirContext ctx) {
        super(pluginNodeCn, pluginNodeDn, ctx);
        Attributes attrs = this.getAttributes();
        attrs.put("objectClass", "uaPlugin");
        attrs.put("cn", pluginNodeCn);
        attrs.put("name", pluginInfo.getName());
        attrs.put("uaId", pluginInfo.getId());
        attrs.put("uaPluginVersion", pluginInfo.getVersion());
        attrs.put("uaInstanceNumber", new Integer(pluginInfo.getInstanceNumber()).toString());
        attrs.put("uaPluginHome", pluginInfo.getPluginHome());
        attrs.put("uaProviderName", pluginInfo.getProviderName());
        attrs.put("uaLoaded", new Boolean(pluginInfo.isLoaded()).toString());
        attrs.put("uaEnabled", new Boolean(pluginInfo.isEnabled()).toString());
        attrs.put("uaRegisterOnStartup", new Boolean(pluginInfo.isRegisterOnStartup()).toString());
    }
}

