/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.discovery.ldap;

import com.sybase.ua.PluginInfo;
import com.sybase.ua.discovery.ldap.PluginNode;
import com.sybase.ua.util.ldap.LDAPNode;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;

public class PluginsNode
extends LDAPNode {
    public static final String COMMON_NAME = "plugins";

    public static DirContext findPluginsNode(DirContext agentNode) throws NamingException {
        DirContext pluginsNode = (DirContext)agentNode.lookup("cn=plugins");
        return pluginsNode;
    }

    public static List<PluginInfo> restorePluginInfos(DirContext pluginsNode) throws NamingException {
        ArrayList<PluginInfo> pluginInfos = new ArrayList<PluginInfo>(1);
        NamingEnumeration<Binding> children = pluginsNode.listBindings("");
        while (children.hasMore()) {
            Binding binding = children.next();
            DirContext pluginNode = (DirContext)binding.getObject();
            PluginInfo pluginInfo = PluginNode.restorePluginInfo(pluginNode);
            if (pluginInfo == null) continue;
            pluginInfos.add(pluginInfo);
        }
        return pluginInfos;
    }

    public PluginsNode(String pluginsNodeCn, String pluginsNodeDn, DirContext ctx) {
        super(pluginsNodeCn, pluginsNodeDn, ctx);
        Attributes attrs = this.getAttributes();
        attrs.put("objectClass", "uaPlugins");
        attrs.put("cn", pluginsNodeCn);
        attrs.put("description", "Agent plugin container");
    }
}

