/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.discovery.ldap;

import com.sybase.ua.ServiceInfo;
import com.sybase.ua.discovery.ldap.DiscoveryPropertiesNode;
import com.sybase.ua.util.ldap.LDAPNode;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;

public class ServiceNode
extends LDAPNode {
    public static DirContext findDiscoveryPropertiesNode(DirContext serviceNode) throws NamingException {
        DirContext discoveryPropssNode = (DirContext)serviceNode.lookup("cn=discoveryProperties");
        return discoveryPropssNode;
    }

    public static ServiceInfo restoreServiceInfo(DirContext serviceNode) throws NamingException {
        Attributes attrs = serviceNode.getAttributes("");
        String name = (String)attrs.get("name").get(0);
        String id = (String)attrs.get("uaId").get(0);
        boolean started = "true".equalsIgnoreCase((String)attrs.get("uaStarted").get(0));
        boolean inited = "true".equalsIgnoreCase((String)attrs.get("uaInited").get(0));
        DirContext discoveryPropsNode = ServiceNode.findDiscoveryPropertiesNode(serviceNode);
        Map<String, Object> discoveryProps = DiscoveryPropertiesNode.restoreDiscoveryProperties(discoveryPropsNode);
        ServiceInfo serviceInfo = new ServiceInfo(name, id, started, inited, discoveryProps);
        return serviceInfo;
    }

    public ServiceNode(String serviceNodeCn, String serviceNodeDn, ServiceInfo serviceInfo, DirContext ctx) {
        super(serviceNodeCn, serviceNodeDn, ctx);
        Attributes attrs = this.getAttributes();
        attrs.put("objectClass", "uaService");
        attrs.put("cn", serviceNodeCn);
        attrs.put("name", serviceInfo.getName());
        attrs.put("uaId", serviceInfo.getId());
        BasicAttribute uaStartedAttr = new BasicAttribute("uaStarted", new Boolean(serviceInfo.isStarted()).toString());
        attrs.put(uaStartedAttr);
        attrs.put("uaInited", new Boolean(serviceInfo.isInited()).toString());
    }
}

