/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.discovery.ldap;

import com.sybase.ua.ServiceInfo;
import com.sybase.ua.discovery.ldap.ServiceNode;
import com.sybase.ua.util.ldap.LDAPNode;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;

public class ServicesNode
extends LDAPNode {
    public static final String COMMON_NAME = "services";

    public static DirContext findServicesNode(DirContext agentNode) throws NamingException {
        DirContext servicesNode = (DirContext)agentNode.lookup("cn=services");
        return servicesNode;
    }

    public static List<ServiceInfo> restoreServiceInfos(DirContext servicesNode) throws NamingException {
        ArrayList<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>(1);
        NamingEnumeration<Binding> children = servicesNode.listBindings("");
        while (children.hasMore()) {
            Binding binding = children.next();
            DirContext serviceNode = (DirContext)binding.getObject();
            ServiceInfo serviceInfo = ServiceNode.restoreServiceInfo(serviceNode);
            if (serviceInfo == null) continue;
            serviceInfos.add(serviceInfo);
        }
        return serviceInfos;
    }

    public ServicesNode(String servicesNodeCn, String servicesNodeDn, DirContext ctx) {
        super(servicesNodeCn, servicesNodeDn, ctx);
        Attributes attrs = this.getAttributes();
        attrs.put("objectClass", "uaServices");
        attrs.put("cn", servicesNodeCn);
        attrs.put("description", "Agent service container");
    }
}

