/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.loader;

import com.sybase.ua.util.LogUtil;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class ClassLoaderBase
extends URLClassLoader {
    protected static LogUtil log = new LogUtil();
    private boolean delegate = true;
    private final List<String> urlStrings = new ArrayList<String>(1);
    private final List<ClassLoaderBase> children = new ArrayList<ClassLoaderBase>(1);

    public ClassLoaderBase(URL[] urls) {
        this(urls, null);
        for (URL url : urls) {
            this.urlStrings.add(url.toString());
        }
    }

    public ClassLoaderBase(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        for (URL url : urls) {
            this.urlStrings.add(url.toString());
        }
        if (parent != null && parent instanceof ClassLoaderBase) {
            ((ClassLoaderBase)parent).addChild(this);
        }
    }

    public void addChild(ClassLoaderBase childClassLoader) {
        this.children.add(childClassLoader);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
        this.urlStrings.add(url.toString());
    }

    public void addURLs(List<URL> urls) {
        for (URL url : urls) {
            this.addURL(url);
        }
    }

    public void addURLs(URL[] urls) {
        for (URL url : urls) {
            this.addURL(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ClassLoaderBase classLoaderBase = this;
            synchronized (classLoaderBase) {
                clazz = this.findLoadedClass(name);
                if (clazz != null) {
                    return clazz;
                }
                clazz = super.findClass(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    public Class<?> findClassNoDelegate(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.findLoadedClass(name);
            if (clazz != null) {
                return clazz;
            }
            clazz = super.findClass(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    public List<ClassLoaderBase> getChildren() {
        return this.children;
    }

    public List<String> getURLStrings() {
        return this.urlStrings;
    }

    public boolean isDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        this.delegate = delegate;
    }
}

