/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.loader;

import com.sybase.ua.loader.ClassLoaderBase;
import com.sybase.ua.loader.CommonClassLoader;
import com.sybase.ua.loader.PluginClassLoader;
import com.sybase.ua.loader.ServerClassLoader;
import com.sybase.ua.loader.ServiceClassLoader;
import com.sybase.ua.loader.SharedClassLoader;
import com.sybase.ua.util.LogUtil;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ClassLoaderFactory {
    private static LogUtil log = new LogUtil();

    public static List<URL> buildURLList(File[] classesDirs, File[] libDirs, File[] jarFiles) throws Exception {
        URL url;
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (classesDirs != null) {
            for (File classesDir : classesDirs) {
                File file = classesDir;
                if (file == null || !file.exists() || !file.canRead()) continue;
                url = null;
                if (file.isDirectory()) {
                    log.debug("Classpath: including dir " + file.getAbsolutePath());
                    url = file.toURI().toURL();
                    urlList.add(url);
                    continue;
                }
                if (!file.getCanonicalPath().toLowerCase().endsWith(".jar")) continue;
                log.debug("Classpath: including JAR file " + file.getAbsolutePath());
                url = file.toURI().toURL();
                urlList.add(url);
            }
        }
        if (libDirs != null) {
            for (File libDir : libDirs) {
                String[] filenames;
                File directory = libDir;
                if (directory == null || !directory.isDirectory() || !directory.exists() || !directory.canRead()) continue;
                for (String filename2 : filenames = directory.list()) {
                    String filename = filename2.toLowerCase();
                    if (!filename.toLowerCase().endsWith(".jar")) continue;
                    File file = new File(directory, filename2);
                    log.debug("Classpath: including JAR file " + file.getAbsolutePath());
                    URL url2 = file.toURI().toURL();
                    urlList.add(url2);
                }
            }
        }
        if (jarFiles != null) {
            for (File jarFile2 : jarFiles) {
                File jarFile = jarFile2;
                if (jarFile == null || jarFile.isDirectory() || !jarFile.exists() || !jarFile.canRead()) continue;
                log.debug("Classpath: including JAR file " + jarFile.getAbsolutePath());
                url = jarFile.toURI().toURL();
                urlList.add(url);
            }
        }
        return urlList;
    }

    public static ClassLoader createCommonClassLoader(String agentHome) throws Exception {
        return ClassLoaderFactory.createCommonClassLoader(agentHome, null);
    }

    public static ClassLoader createCommonClassLoader(String agentHome, ClassLoader parent) throws Exception {
        File[] classesDirs = new File[1];
        File[] libDirs = new File[3];
        classesDirs[0] = new File(agentHome, "common" + File.separator + "classes");
        libDirs[0] = new File(agentHome, "common" + File.separator + "lib");
        libDirs[1] = new File(agentHome, "common" + File.separator + "endorsed");
        if (System.getProperty("com.sybase.platform", "windows").toLowerCase().startsWith("aix")) {
            libDirs[2] = new File(agentHome, "common" + File.separator + "lib" + File.separator + "extra" + File.separator + "aix");
        }
        List<URL> urlList = ClassLoaderFactory.buildURLList(classesDirs, libDirs, null);
        URL[] array = urlList.toArray(new URL[urlList.size()]);
        CommonClassLoader classLoader = new CommonClassLoader(array, parent);
        classLoader.setDelegate(true);
        return classLoader;
    }

    public static ClassLoaderBase createDynamicClassLoader(File[] classesDirs, File[] libDirs, File[] jarFiles, ClassLoader parent) throws Exception {
        List<URL> urlList = ClassLoaderFactory.buildURLList(classesDirs, libDirs, jarFiles);
        URL[] array = urlList.toArray(new URL[urlList.size()]);
        ClassLoaderBase classLoader = null;
        classLoader = parent == null ? new ClassLoaderBase(array) : new ClassLoaderBase(array, parent);
        classLoader.setDelegate(true);
        return classLoader;
    }

    public static PluginClassLoader createPluginClassLoader(String agentHome, String pluginHome, ClassLoader parent) throws Exception {
        PluginClassLoader classLoader = null;
        File[] classesDirs = new File[1];
        File[] libDirs = new File[2];
        classesDirs[0] = new File(pluginHome, "classes");
        libDirs[0] = new File(pluginHome, "lib");
        libDirs[1] = new File(pluginHome, "endorsed");
        classLoader = ClassLoaderFactory.createPluginClassLoader(classesDirs, libDirs, parent);
        return classLoader;
    }

    public static ClassLoader createServerClassLoader(String agentHome, ClassLoader parent) throws Exception {
        File[] classesDirs = new File[1];
        File[] libDirs = new File[2];
        classesDirs[0] = new File(agentHome, "server" + File.separator + "classes");
        libDirs[0] = new File(agentHome, "server" + File.separator + "lib");
        libDirs[1] = new File(agentHome, "server" + File.separator + "endorsed");
        List<URL> urlList = ClassLoaderFactory.buildURLList(classesDirs, libDirs, null);
        URL[] array = urlList.toArray(new URL[urlList.size()]);
        ServerClassLoader classLoader = new ServerClassLoader(array, parent);
        classLoader.setDelegate(true);
        return classLoader;
    }

    public static ServiceClassLoader createServiceClassLoader(String serviceHome, ClassLoader parent) throws Exception {
        ServiceClassLoader classLoader = null;
        File[] classesDirs = new File[1];
        File[] libDirs = new File[2];
        classesDirs[0] = new File(serviceHome, "classes");
        libDirs[0] = new File(serviceHome, "lib");
        libDirs[1] = new File(serviceHome, "endorsed");
        classLoader = ClassLoaderFactory.createServiceClassLoader(classesDirs, libDirs, parent);
        return classLoader;
    }

    public static ClassLoader createSharedClassLoader(String agentHome, ClassLoader parent) throws Exception {
        File[] classesDirs = new File[1];
        File[] libDirs = new File[2];
        classesDirs[0] = new File(agentHome, "shared" + File.separator + "classes");
        libDirs[0] = new File(agentHome, "shared" + File.separator + "lib");
        libDirs[1] = new File(agentHome, "shared" + File.separator + "endorsed");
        List<URL> urlList = ClassLoaderFactory.buildURLList(classesDirs, libDirs, null);
        URL[] array = urlList.toArray(new URL[urlList.size()]);
        SharedClassLoader classLoader = new SharedClassLoader(array, parent);
        classLoader.setDelegate(true);
        return classLoader;
    }

    private static PluginClassLoader createPluginClassLoader(File[] classesDirs, File[] libDirs, ClassLoader parent) throws Exception {
        List<URL> urlList = ClassLoaderFactory.buildURLList(classesDirs, libDirs, null);
        URL[] array = urlList.toArray(new URL[urlList.size()]);
        PluginClassLoader classLoader = null;
        classLoader = parent == null ? new PluginClassLoader(array) : new PluginClassLoader(array, parent);
        classLoader.setDelegate(false);
        return classLoader;
    }

    private static ServiceClassLoader createServiceClassLoader(File[] classesDirs, File[] libDirs, ClassLoader parent) throws Exception {
        List<URL> urlList = ClassLoaderFactory.buildURLList(classesDirs, libDirs, null);
        URL[] array = urlList.toArray(new URL[urlList.size()]);
        ServiceClassLoader classLoader = null;
        classLoader = parent == null ? new ServiceClassLoader(array) : new ServiceClassLoader(array, parent);
        classLoader.setDelegate(false);
        return classLoader;
    }

    private ClassLoaderFactory() {
    }
}

