/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.loader;

import com.sybase.ua.loader.ClassConflictException;
import com.sybase.ua.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassMapHelper {
    private static final Log log = LogFactory.getLog(ClassMapHelper.class);

    public static void buildClassMapForMBean(ClassLoader serverClassLoader, ClassLoader mbeanClassLoader, Class<?> mbeanClass) throws Exception {
        Method[] methods;
        for (Method method : methods = mbeanClass.getMethods()) {
            Class<?>[] paramTypes;
            for (Class<?> paramType : paramTypes = method.getParameterTypes()) {
                ClassMapHelper.addParameterClass(serverClassLoader, mbeanClassLoader, paramType);
            }
        }
    }

    public static void removeClassMapEntriesForMBean(ClassLoader serverClassLoader, ClassLoader mbeanClassLoader) {
        Map classMap = null;
        try {
            classMap = (Map)ReflectionUtil.invoke(serverClassLoader, "getClassMap", null, null);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            log.error((Object)e.getMessage());
        }
        if (classMap == null) {
            return;
        }
        HashSet clonedKeys = new HashSet(classMap.keySet());
        for (String classname : clonedKeys) {
            if (classMap.get(classname) != mbeanClassLoader) continue;
            classMap.remove(classname);
        }
    }

    private static void addParameterClass(ClassLoader serverClassLoader, ClassLoader mbeanClassLoader, Class<?> paramType) throws Exception {
        if (mbeanClassLoader == paramType.getClassLoader()) {
            ClassLoader cl;
            Map classMap = null;
            try {
                classMap = (Map)ReflectionUtil.invoke(serverClassLoader, "getClassMap", null, null);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                log.error((Object)e.getMessage());
            }
            if (classMap == null) {
                return;
            }
            String classname = paramType.getName();
            if (classname.startsWith("[L") && classname.endsWith(";")) {
                classname = classname.substring(2, classname.length() - 1);
            }
            if (classMap.containsKey(classname) && (cl = (ClassLoader)classMap.get(classname)) != mbeanClassLoader) {
                throw new ClassConflictException("Class conflict is found: " + classname);
            }
            try {
                Class[] classTypes = new Class[]{String.class, ClassLoader.class};
                ReflectionUtil.invoke(serverClassLoader, "addToClassMap", classTypes, new Object[]{classname, mbeanClassLoader});
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                log.error((Object)e.getMessage());
            }
        }
    }
}

