/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.loader;

import com.sybase.ua.loader.ClassLoaderBase;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PluginClassLoader
extends ClassLoaderBase {
    private String pluginName;
    private String pluginVersion;
    private List<ClassLoader> dependentClassLoaders = new ArrayList<ClassLoader>(1);

    public PluginClassLoader(URL[] urls) {
        this(urls, null);
    }

    public PluginClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public void addDependentClassLoader(ClassLoader classloader) {
        if (!this.dependentClassLoaders.contains(classloader)) {
            this.dependentClassLoaders.add(classloader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            PluginClassLoader pluginClassLoader = this;
            synchronized (pluginClassLoader) {
                clazz = this.findLoadedClass(name);
                if (clazz != null) {
                    return clazz;
                }
                clazz = super.findClass(name);
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
        if (clazz == null) {
            for (ClassLoader cl : this.dependentClassLoaders) {
                try {
                    clazz = ((ClassLoaderBase)cl).findClass(name);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (clazz == null) continue;
                break;
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public void removeDependentClassLoader(ClassLoader classloader) {
        if (this.dependentClassLoaders.contains(classloader)) {
            this.dependentClassLoaders.remove(classloader);
        }
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public void setPluginVersion(String pluginVersion) {
        this.pluginVersion = pluginVersion;
    }

    protected void finalize() throws Throwable {
        if (this.dependentClassLoaders != null) {
            this.dependentClassLoaders.clear();
            this.dependentClassLoaders = null;
        }
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        block4: {
            c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (this.getParent() == null) break block4;
                    c = this.getParent().loadClass(name);
                }
            }
        }
        if (c != null && resolve) {
            this.resolveClass(c);
        }
        return c;
    }
}

