/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.loader;

import com.sybase.ua.loader.ClassLoaderBase;
import com.sybase.ua.loader.PluginClassLoader;
import com.sybase.ua.loader.ServiceClassLoader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServerClassLoader
extends ClassLoaderBase {
    private final Map<String, ClassLoader> classMap = new HashMap<String, ClassLoader>();
    private final List<ClassLoader> extraClassLoaders = new ArrayList<ClassLoader>();

    public ServerClassLoader(URL[] urls) {
        this(urls, null);
    }

    public ServerClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public synchronized void addExtraClassLoader(ClassLoader classloader) {
        if (!this.extraClassLoaders.contains(classloader)) {
            this.extraClassLoaders.add(classloader);
        }
    }

    public synchronized void addToClassMap(String classname, ClassLoader classloader) {
        if (!this.classMap.containsKey(classname)) {
            this.classMap.put(classname, classloader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class clazz = null;
        try {
            ServerClassLoader serverClassLoader = this;
            synchronized (serverClassLoader) {
                clazz = this.findLoadedClass(name);
                if (clazz != null) {
                    return clazz;
                }
                clazz = super.findClass(name);
            }
        }
        catch (ClassNotFoundException e) {
        }
        catch (Exception e) {
            log.debug(e.getMessage());
        }
        if (clazz == null) {
            if (this.classMap.containsKey(name)) {
                ClassLoader extraCL = this.classMap.get(name);
                if (extraCL.getClass().getName().equals(ServiceClassLoader.class.getName()) || extraCL.getClass().getName().equals(PluginClassLoader.class.getName())) {
                    try {
                        Method method = extraCL.getClass().getMethod("findClassNoDelegate", String.class);
                        clazz = (Class)method.invoke((Object)extraCL, (Object[])new String[]{name});
                    }
                    catch (Exception e) {}
                }
            } else {
                ArrayList<ClassLoader> extraClassLoadersClone = new ArrayList<ClassLoader>(this.extraClassLoaders);
                for (ClassLoader extraClassLoader : extraClassLoadersClone) {
                    if (!extraClassLoader.getClass().getName().equals(ServiceClassLoader.class.getName()) && !extraClassLoader.getClass().getName().equals(PluginClassLoader.class.getName())) continue;
                    try {
                        Method method = extraClassLoader.getClass().getMethod("findClassNoDelegate", String.class);
                        clazz = (Class)method.invoke((Object)extraClassLoader, (Object[])new String[]{name});
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (clazz == null) continue;
                    break;
                }
                extraClassLoadersClone.clear();
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    public Map<String, ClassLoader> getClassMap() {
        return this.classMap;
    }

    public List<ClassLoader> getExtraClassLoaders() {
        return this.extraClassLoaders;
    }

    public synchronized void removeExtraClassLoader(ClassLoader classloader) {
        if (this.extraClassLoaders.contains(classloader)) {
            this.extraClassLoaders.remove(classloader);
        }
    }

    public synchronized void removeFromClassMap(String classname) {
        if (this.classMap.containsKey(classname)) {
            this.classMap.remove(classname);
        }
    }

    protected void finalize() throws Throwable {
        if (this.classMap != null) {
            this.classMap.clear();
        }
        if (this.extraClassLoaders != null) {
            this.extraClassLoaders.clear();
        }
    }
}

