/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.loader;

import com.sybase.ua.loader.ClassLoaderBase;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ServiceClassLoader
extends ClassLoaderBase {
    private String serviceID;
    private String serviceVersion;
    private final List<ServiceClassLoader> dependantServiceClassLoaders = new ArrayList<ServiceClassLoader>(1);
    private final List<ClassLoader> primordialServiceClassLoaders = new ArrayList<ClassLoader>(6);

    public ServiceClassLoader(URL[] urls) {
        this(urls, null);
    }

    public ServiceClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public void addDependantServiceClassLoader(ServiceClassLoader dependantServiceClassLoader) {
        this.dependantServiceClassLoaders.add(dependantServiceClassLoader);
    }

    public void addPrimordialServiceClassLoader(ClassLoader primordialServiceClassLoader) {
        this.primordialServiceClassLoaders.add(primordialServiceClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ServiceClassLoader serviceClassLoader = this;
            synchronized (serviceClassLoader) {
                clazz = this.findLoadedClass(name);
                if (clazz != null) {
                    return clazz;
                }
                clazz = super.findClass(name);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (clazz == null) {
            for (ServiceClassLoader dependentServiceClassLoader : this.dependantServiceClassLoaders) {
                try {
                    clazz = dependentServiceClassLoader.findClass(name);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (clazz == null) continue;
                break;
            }
        }
        if (clazz == null) {
            for (ClassLoader primordialServiceClassLoader : this.primordialServiceClassLoaders) {
                if (!(primordialServiceClassLoader instanceof ServiceClassLoader)) continue;
                try {
                    clazz = ((ServiceClassLoader)primordialServiceClassLoader).findClass(name);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (clazz == null) continue;
                break;
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    public List<ServiceClassLoader> getDependantServiceClassLoaders() {
        return this.dependantServiceClassLoaders;
    }

    public List<ClassLoader> getPrimordialServiceClassLoaders() {
        return this.primordialServiceClassLoaders;
    }

    public String getServiceID() {
        return this.serviceID;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public void setServiceID(String serviceID) {
        this.serviceID = serviceID;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        block4: {
            c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    if (this.getParent() == null) break block4;
                    c = this.getParent().loadClass(name);
                }
            }
        }
        if (c != null && resolve) {
            this.resolveClass(c);
        }
        return c;
    }
}

