/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.migration;

import com.sybase.ua.migration.MalformatVersionException;
import com.sybase.ua.migration.Migratable;
import com.sybase.ua.migration.MigrationException;
import com.sybase.ua.migration.MigrationPatch;
import com.sybase.ua.migration.Version;
import com.sybase.ua.migration.VersionRange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMigrationPatch
implements MigrationPatch {
    private VersionRange migrationConditionVersionRange;
    private Version versionAfterMigration;
    private final Migratable migratableComponent;
    protected Log log = LogFactory.getLog(this.getClass());

    public AbstractMigrationPatch(Migratable migratableComponent) {
        this.migratableComponent = migratableComponent;
        try {
            this.migrationConditionVersionRange = this.getMigrationConditionVersionRange();
            this.versionAfterMigration = this.getVersionAfterMigration();
        }
        catch (MalformatVersionException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Migratable getMigratableComponent() {
        return this.migratableComponent;
    }

    @Override
    public void install() throws MigrationException {
        if (this.migratableComponent == null) {
            this.log.debug((Object)"Migratable component is null.");
            return;
        }
        this.doInstall(this.migratableComponent);
        try {
            this.updateMigratableResourceVersion();
        }
        catch (MalformatVersionException e) {
            throw new MigrationException("Failed to update migratable resource's version: " + e.getMessage());
        }
        this.doPostInstall(this.migratableComponent);
    }

    @Override
    public boolean isMigrationNeeded() throws MalformatVersionException {
        boolean resourceVersionFallsWithinMigrationCondition = this.getMigrationConditionVersionRange().fallsWithinRange(this.migratableComponent.getMigratableResourceVersion());
        return resourceVersionFallsWithinMigrationCondition;
    }

    public void setMigrationConditionVersionRange(VersionRange migrationConditionVersionRange) {
        this.migrationConditionVersionRange = migrationConditionVersionRange;
    }

    public void setVersionAfterMigration(Version versionAfterMigration) {
        this.versionAfterMigration = versionAfterMigration;
    }

    public String toString() {
        return this.getDescription();
    }

    protected abstract void doInstall(Migratable var1) throws MigrationException;

    protected abstract void doPostInstall(Migratable var1) throws MigrationException;

    private void updateMigratableResourceVersion() throws MalformatVersionException {
        this.migratableComponent.setMigratableResourceVersionAfterMigration(this.getVersionAfterMigration().getVersionAsString());
    }
}

