/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ua.migration;

import com.sybase.ua.migration.MalformatVersionException;
import com.sybase.ua.migration.Migratable;
import com.sybase.ua.migration.MigrationException;
import com.sybase.ua.migration.MigrationPatch;
import com.sybase.ua.migration.MigrationTask;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractMigrationTask
implements MigrationTask {
    private final Log log;
    private final List patches = new ArrayList(1);
    private final List installedPatches = new ArrayList(1);

    public AbstractMigrationTask() {
        this.log = LogFactory.getLog(this.getClass());
    }

    @Override
    public void addInstalledPatch(MigrationPatch patch) {
        this.installedPatches.add(patch);
    }

    @Override
    public void addPatch(MigrationPatch patch) {
        this.patches.add(patch);
    }

    @Override
    public void apply() throws MigrationException {
        for (MigrationPatch patch : this.patches) {
            Migratable migratableComponent = patch.getMigratableComponent();
            try {
                if (!patch.isMigrationNeeded()) continue;
                this.log.debug((Object)("Migration needed: resource version - " + migratableComponent.getMigratableResourceVersion() + ", component version - " + migratableComponent.getMigratableComponentVersion()));
                this.log.info((Object)("Installing migration patch: " + patch.getDescription()));
                patch.install();
                this.addInstalledPatch(patch);
            }
            catch (MalformatVersionException e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public List getInstalledPatches() {
        return this.installedPatches;
    }

    @Override
    public List getPatches() {
        return this.patches;
    }

    @Override
    public boolean removePatch(MigrationPatch patch) {
        return this.patches.remove(patch);
    }
}

